package com.reyun.sdktestdemo;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;

import android.Manifest;
import android.app.Application;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.hardware.Camera;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.provider.Telephony;
import android.telephony.CellInfo;
import android.telephony.NeighboringCellInfo;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.TextView;

import com.reyun.wandun.WdCallback;
import com.reyun.wandun.WdMain;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.List;

public class MainActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            requestPermissions(new String[]{
                    Manifest.permission.READ_PHONE_STATE,
                    Manifest.permission.READ_EXTERNAL_STORAGE,
                    Manifest.permission.WRITE_EXTERNAL_STORAGE,
                    Manifest.permission.ACCESS_FINE_LOCATION,
                    Manifest.permission.ACCESS_COARSE_LOCATION
            }, 100);
        }


        WifiManager wm = (WifiManager) getApplicationContext().getSystemService(Service.WIFI_SERVICE);
        WifiInfo wi = wm.getConnectionInfo();
        String ssid = wi.getSSID();
        String bssid = wi.getBSSID();
        int ip = wi.getIpAddress();



        // Example of a call to a native method
        TextView tv = findViewById(R.id.sample_text);
        tv.setText("hello world!");
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if(requestCode == 100) {
            if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
                // TODO: Consider calling
                //    ActivityCompat#requestPermissions
                // here to request the missing permissions, and then overriding
                //   public void onRequestPermissionsResult(int requestCode, String[] permissions,
                //                                          int[] grantResults)
                // to handle the case where the user grants the permission. See the documentation
                // for ActivityCompat#requestPermissions for more details.
                return;
            }
            Location bestLocation = null;
            LocationManager lm = (LocationManager) getApplicationContext().getSystemService(Service.LOCATION_SERVICE);
            Log.d("testdemo-1", "ha ha ha...");
            List<String> list = lm.getAllProviders();
            for (String provider : list) {
                Location l = lm.getLastKnownLocation(provider);
                if (l == null) {
                    continue;
                }
                if (bestLocation == null || l.getAccuracy() < bestLocation.getAccuracy()) {
                    // Found best last known location: %s", l);
                    Log.d("testdemo-1", "provider: " + provider);
                    bestLocation = l;
                }
            }
            if(bestLocation != null) {
                double lat = bestLocation.getLatitude();
                double lon = bestLocation.getLongitude();
                Log.d("testdemo-1", lat + ", " + lon);
            }

            TelephonyManager tm = (TelephonyManager) getApplicationContext().getSystemService(Service.TELEPHONY_SERVICE);
            List<CellInfo> cellInfos = tm.getAllCellInfo();



            //初始化sdk环境
            WdMain wm = WdMain.getInstance();
            wm.init(getApplicationContext(), "test-a341fsfr3123ddadfs");
            //同步获取唯一id
            wm.getWdId(new WdCallback() {
                @Override
                public void onWdId(String wdId) {
                    Log.d("demo", "onWdId: " + wdId);
                }
            /*
            @Override
            public void onError(String errorMsg) {
                Log.d(TAG, "onError: " + errorMsg);
            }*/
            });
        }

    }
}

