//
// Created by 12567 on 2021/3/31.
//

#include <jni.h>
#include <syscall.h>
#include "wdun.h"
#include "cJSON.h"
#include "wd_jni.h"
#include "collect.h"
#include "fake_dlfcn.h"

//import asm symbol
IMPORTWDSYSCALL

#define WDMAIN_CLASS_NAME              "com/reyun/wandun/WdMain"
#define WDMAIN_GETWDID_METHOD_NAME     "getWdIdNative"
#define WDMAIN_GETWDID_METHOD_SIG      "()Ljava/lang/String;"
#define WDMAIN_INIT_METHOD_NAME        "initNative"
#define WDMAIN_INIT_METHOD_SIG         "(Landroid/content/Context;)V"

jobject g_app_context = NULL;

struct wd_funcs g_funcs;

JNIEXPORT jstring jni_get_wdid(JNIEnv* env, jobject thiz) {
    do_collect(env);
    return NULL;
}

JNIEXPORT void jni_init(JNIEnv* env, jobject thiz, jobject context) {
    if(!g_app_context) {
        g_app_context = (*env)->NewGlobalRef(env, context);
    }
}

JNIEXPORT jint JNI_OnLoad(JavaVM* vm, void* reserved) {
    int pid = WDSYSCALL(SYS_getpid);
    JNIEnv* env = NULL;
    if((*vm)->GetEnv(vm, (void**)&env, JNI_VERSION_1_6) == JNI_OK) {
        jclass cls = (*env)->FindClass(env, WDMAIN_CLASS_NAME);
        JNINativeMethod methods[] = {{WDMAIN_GETWDID_METHOD_NAME, WDMAIN_GETWDID_METHOD_SIG, (void*)jni_get_wdid},
                                     {WDMAIN_INIT_METHOD_NAME, WDMAIN_INIT_METHOD_SIG, (void*)jni_init}};
        (*env)->RegisterNatives(env, cls, methods, sizeof(methods)/sizeof(JNINativeMethod));
        (*env)->DeleteLocalRef(env, cls);
    }

    //find lic needed symbol
    struct so_info* si = fake_dlopen("libc.so", 0);
    g_funcs.wd_popen = fake_dlsym(si, "popen");
    g_funcs.wd_pclose = fake_dlsym(si, "pclose");
    g_funcs.wd_system_property_get = fake_dlsym(si, "__system_property_get");
    fake_dlclose(si);
    return JNI_VERSION_1_6;
}

