//
// Created by Fear1ess on 2021/4/2.
//

#ifndef REYUNSDK_COLLECT_H
#define REYUNSDK_COLLECT_H

#include <jni.h>
#include "cJSON.h"

void do_collect(JNIEnv* env);
cJSON* collect_init();
void collect_app_info(JNIEnv* env, cJSON* json);
int  collect_permissions(JNIEnv* env, cJSON* json);
void collect_imei(JNIEnv* env, cJSON* json);
void collect_android_id(JNIEnv* env, cJSON* json);
void collect_mac_addr(JNIEnv* env, cJSON* json);
void collect_build_info(JNIEnv* env, cJSON* json);
void collect_prop_info(JNIEnv* env, cJSON* json);
void collect_settings_info(JNIEnv* env, cJSON* json);
void collect_display_info(JNIEnv* env, cJSON* json);
void collect_proxy_info(JNIEnv* env, cJSON* json);
void collect_camera_info(JNIEnv* env, cJSON* json);
void collect_battery_info(JNIEnv* env, cJSON* json);
void collect_env(JNIEnv* env, cJSON* json);
void collect_libs_info(JNIEnv* env, cJSON* json);
void collect_cpu_info(JNIEnv* env, cJSON* json);
void collect_sensor_info(JNIEnv* env, cJSON* json);
void collect_mem_info(JNIEnv* env, cJSON* json);
void collect_network_info(JNIEnv* env, cJSON* json);
void collect_user_agent(JNIEnv* env, cJSON* json);
void collect_location_info(JNIEnv* env, cJSON* json);
void collect_cell_info(JNIEnv* env, cJSON* json);

/** Network type is unknown */
#define NETWORK_TYPE_UNKNOWN 0
/** Current network is GPRS */
#define NETWORK_TYPE_GPRS    1
/** Current network is EDGE */
#define NETWORK_TYPE_EDGE    2
/** Current network is UMTS */
#define NETWORK_TYPE_UMTS    3
/** Current network is CDMA: Either IS95A or IS95B*/
#define NETWORK_TYPE_CDMA    4
/** Current network is EVDO revision 0*/
#define NETWORK_TYPE_EVDO_0  5
/** Current network is EVDO revision A*/
#define NETWORK_TYPE_EVDO_A  6
/** Current network is 1xRTT*/
#define NETWORK_TYPE_1xRTT   7
/** Current network is HSDPA */
#define NETWORK_TYPE_HSDPA   8
/** Current network is HSUPA */
#define NETWORK_TYPE_HSUPA   9
/** Current network is HSPA */
#define NETWORK_TYPE_HSPA    10
/** Current network is iDen */
#define NETWORK_TYPE_IDEN    11
/** Current network is EVDO revision B*/
#define NETWORK_TYPE_EVDO_B  12
/** Current network is LTE */
#define NETWORK_TYPE_LTE     13
/** Current network is eHRPD */
#define NETWORK_TYPE_EHRPD   14
/** Current network is HSPA+ */
#define NETWORK_TYPE_HSPAP   15
/** Current network is GSM */
#define NETWORK_TYPE_GSM     16
/** Current network is TD_SCDMA */
#define NETWORK_TYPE_TD_SCDMA  17
/** Current network is IWLAN */
#define NETWORK_TYPE_IWLAN   18
/** Current network is LTE_CA {@hide} */
#define NETWORK_TYPE_LTE_CA  19
/** Current network is NR(New Radio) 5G. */
#define NETWORK_TYPE_NR      20

#define PERMISSION_READ_EXTERNAL_STORAGE   0x1
#define PERMISSION_WRITE_EXTERNAL_STORAGE  0x2
#define PERMISSION_READ_PHONE_STATE        0x4
#define PERMISSION_ACCESS_NETWORK_STATE    0x8
#define PERMISSION_ACCESS_WIFI_STATE       0x10
#define PERMISSION_ACCESS_COARSE_LOCATION  0x20
#define PERMISSION_ACCESS_FINE_LOCATION    0x40


#endif //REYUNSDK_COLLECT_H
