//
// Created by Fear1ess on 2021/3/31.
//

#ifndef REYUNSDK_WD_SYSCALL_H
#define REYUNSDK_WD_SYSCALL_H

#define WD_SYSCALL_BASE 0xcd
#define WDNUM(x) (x + WD_SYSCALL_BASE)


#ifdef __arm__
#define WDSYSCALL(cmd, args...) wd_syscall32(WDNUM(cmd), ##args)
#define WD_SYS_mmap SYS_mmap2
#endif

#ifdef __aarch64__
#define WDSYSCALL(cmd, args...) wd_syscall64(WDNUM(cmd), ##args)
#define WD_SYS_mmap SYS_mmap
#endif

#define IMPORTWDSYSCALL  \
__attribute__((visibility("hidden"))) extern long wd_syscall32(int cmd, ...);\
__attribute__((visibility("hidden"))) extern long wd_syscall64(int cmd, ...);

long wd_set_errno(int n);


#endif //REYUNSDK_WD_SYSCALL_H
