package com.mobvista.apptag.entity;

import com.gitee.sunchenbin.mybatis.actable.annotation.Column;
import com.gitee.sunchenbin.mybatis.actable.annotation.Table;
import com.gitee.sunchenbin.mybatis.actable.constants.MySqlTypeConstant;

import java.io.Serializable;
import java.util.Date;

/**
 * @author wangjf
 */
@Table(name = "storage")
public class Storage implements Serializable {

    private static final long serialVersionUID = 1L;
    //  APP 包名
    @Column(name = "package_name", type = MySqlTypeConstant.VARCHAR, isKey = true, isNull = false)
    private String packageName;
    //  APP 名称
    @Column(name = "app_name", type = MySqlTypeConstant.VARCHAR)
    private String appName;
    //  平台：ios,android
    @Column(name = "platform", type = MySqlTypeConstant.VARCHAR, length = 10)
    private String platform;
    //  标签
    @Column(name = "tag", type = MySqlTypeConstant.TEXT)
    private String tag;
    //  入库时间
    @Column(name = "update_time", type = MySqlTypeConstant.DATETIME, isNull = false)
    private Date updateTime;
    //  标注人员（仅超管用户可以修改已入库的标签）
    @Column(name = "user_id", type = MySqlTypeConstant.VARCHAR, length = 100)
    private String userId;

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}