package com.mobvista.apptag.utils;

import com.google.gson.*;

/**
 * @package: com.mobvista.dmp.server.utils
 * @author: wangjf
 * @date: 2019-06-18
 * @time: 17:57
 * @emial: jinfeng.wang@mobvista.com
 * @phone: 152-1062-7698
 */
public class GsonUtil {
    public static JsonElement toJsonTree(Object obj) {
        if (obj != null) {
            Gson gson = new Gson();
            return gson.toJsonTree(obj);
        }
        return null;
    }

    public static String toJson(Object obj) {
        if (null == obj) {
            return null;
        }
        Gson gson = new Gson();
        return gson.toJson(obj);
    }

    public static <T> T fromJson(JsonElement json, Class<T> clazz) {
        if (json == null || clazz == null) {
            return null;
        }
        Gson gson = new Gson();
        return gson.fromJson(json, clazz);
    }

    /**
     * 将字符串转换为JsonArray
     *
     * @param str
     * @return
     */
    public static JsonArray String2JsonArray(String str) {
        if (null != str && !"".equals(str)) {
            JsonParser parser = new JsonParser();
            JsonElement element = parser.parse(str);
            return element.getAsJsonArray();
        }
        return new JsonArray();
    }

    /**
     * 将字符串转换为JsonObject
     *
     * @param str
     * @return
     */
    public static JsonObject String2JsonObject(String str) {
        if (null != str && !"".equals(str)) {
            JsonParser parser = new JsonParser();
            JsonElement element = parser.parse(str);
            return element.getAsJsonObject();
        }
        return null;
    }
}
