package com.mobvista.apptag.entity;

import java.io.Serializable;

import com.gitee.sunchenbin.mybatis.actable.annotation.Column;
import com.gitee.sunchenbin.mybatis.actable.annotation.Table;
import com.gitee.sunchenbin.mybatis.actable.constants.MySqlTypeConstant;

/**
 * @author wangjf
 */

@Table(name = "tag_feat")
public class Feat implements Serializable {

    private static final long serialVersionUID = 1L;

    // 一级标签
    @Column(name = "first_tag", type = MySqlTypeConstant.VARCHAR, length = 255)
    private String firstTag;

    // 二级标签
    @Column(name = "second_tag", type = MySqlTypeConstant.VARCHAR, length = 255)
    private String secondTag;

    // 一级标签ID
    @Column(name = "first_id", type = MySqlTypeConstant.VARCHAR, length = 10)
    private String firstId;

    // 二级标签ID
    @Column(name = "second_id", type = MySqlTypeConstant.VARCHAR, length = 10, isKey = true)
    private String secondId;

    // type ID
    @Column(name = "feat_id", type = MySqlTypeConstant.VARCHAR, length = 2)
    private String featId;

    /**
     * @return the firstTag
     */
    public String getFirstTag() {
        return firstTag;
    }

    /**
     * @param firstTag the firstTag to set
     */
    public void setFirstTag(String firstTag) {
        this.firstTag = firstTag;
    }

    /**
     * @return the featId
     */
    public String getFeatId() {
        return featId;
    }

    /**
     * @param featId the featId to set
     */
    public void setFeatId(String featId) {
        this.featId = featId;
    }

    /**
     * @return the secondId
     */
    public String getSecondId() {
        return secondId;
    }

    /**
     * @param secondId the secondId to set
     */
    public void setSecondId(String secondId) {
        this.secondId = secondId;
    }

    /**
     * @return the firstId
     */
    public String getFirstId() {
        return firstId;
    }

    /**
     * @param firstId the firstId to set
     */
    public void setFirstId(String firstId) {
        this.firstId = firstId;
    }

    /**
     * @return the secondTag
     */
    public String getSecondTag() {
        return secondTag;
    }

    /**
     * @param secondTag the secondTag to set
     */
    public void setSecondTag(String secondTag) {
        this.secondTag = secondTag;
    }

}