package com.mobvista.apptag.mapper;

import java.util.List;

import com.mobvista.apptag.entity.Feat;

import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;

/**
 * @author wangjf
 */

public interface FeatDao {

        @Select("SELECT DISTINCT * FROM tag_feat WHERE feat_id = #{featId}")
        @Results({ @Result(property = "firstTag", column = "first_tag"),
                        @Result(property = "secondTag", column = "second_tag"),
                        @Result(property = "firstId", column = "first_id"),
                        @Result(property = "secondId", column = "second_id"),
                        @Result(property = "featId", column = "feat_id") })
        List<Feat> list(String featId);

        @Select("SELECT feat_id, first_tag, first_id FROM tag_feat WHERE feat_id = #{featId} GROUP BY feat_id, first_tag, first_id")
        @Results({ @Result(property = "firstTag", column = "first_tag"),
                        @Result(property = "secondTag", column = "second_tag"),
                        @Result(property = "firstId", column = "first_id"),
                        @Result(property = "secondId", column = "second_id"),
                        @Result(property = "featId", column = "feat_id") })
        List<Feat> firstList(String featId);

        @Select("SELECT * FROM tag_feat")
        @Results({ @Result(property = "firstTag", column = "first_tag"),
                        @Result(property = "secondTag", column = "second_tag"),
                        @Result(property = "firstId", column = "first_id"),
                        @Result(property = "secondId", column = "second_id"),
                        @Result(property = "featId", column = "feat_id") })
        List<Feat> listAll();
}