package com.mobvista.apptag.mapper;

import java.util.List;

import com.mobvista.apptag.entity.TagResult;

import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;

/**
 * @author wangjf
 */

public interface ResultDao {

    @Insert("REPLACE INTO tag_result(package_name,app_name,platform,feat_id,comment,user_id,update_time) VALUES(#{packageName}, #{appName}, #{platform}, #{featId}, #{comment}, #{userId}, #{updateTime})")
    boolean save(TagResult tagResult);

    @Select("SELECT * FROM tag_result WHERE package_name = #{packageName}")
    @Results({@Result(property = "packageName", column = "package_name"),
            @Result(property = "appName", column = "app_name"),
            @Result(property = "platform", column = "platform"),
            @Result(property = "featId", column = "feat_id"),
            @Result(property = "comments", column = "comments"),
            @Result(property = "userId", column = "user_id"),
            @Result(property = "updateTime", column = "update_time")})
    TagResult find(String packageName);

    @Select("SELECT * FROM tag_result WHERE user_id = #{userId}")
    @Results({@Result(property = "packageName", column = "package_name"),
            @Result(property = "appName", column = "app_name"),
            @Result(property = "platform", column = "platform"),
            @Result(property = "featId", column = "feat_id"),
            @Result(property = "comments", column = "comments"),
            @Result(property = "userId", column = "user_id"),
            @Result(property = "updateTime", column = "update_time")})
    List<TagResult> list(String userId);

    @Select("SELECT * FROM tag_result")
    @Results({@Result(property = "packageName", column = "package_name"),
            @Result(property = "appName", column = "app_name"),
            @Result(property = "platform", column = "platform"),
            @Result(property = "featId", column = "feat_id"),
            @Result(property = "comments", column = "comments"),
            @Result(property = "userId", column = "user_id"),
            @Result(property = "updateTime", column = "update_time")})
    List<TagResult> listAll();

    @Select("SELECT COUNT(1) FROM tag_result WHERE user_id = #{userId}")
    int count(String userId);

    @Select("SELECT COUNT(1) FROM tag_result")
    int countAll();
}