package com.mobvista.apptag.mapper;

import java.util.List;

import com.mobvista.apptag.entity.User;

import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

/**
 * @author wangjf
 */

public interface UserDao {

        @Insert("REPLACE INTO user(user_id,user_name,password,state,role,update_time,count) VALUES(#{userId},#{userName},#{password},#{state},#{role},#{updateTime},${count})")
        boolean save(User user);

        @Update("UPDATE user SET role = #{role}, update_time = #{updateTime}, count = #{count} WHERE user_id = #{userId}")
        void update(User user);

        @Select("SELECT * FROM user WHERE user_id = #{userId}")
        @Results({ @Result(property = "userId", column = "user_id"),
                        @Result(property = "userName", column = "user_name"),
                        @Result(property = "count", column = "count"),
                        @Result(property = "updateTime", column = "update_time"),
                        @Result(property = "role", column = "role") })
        User find(String userId);

        @Select("SELECT * FROM user")
        @Results({ @Result(property = "userId", column = "user_id"),
                        @Result(property = "userName", column = "user_name"),
                        @Result(property = "count", column = "count"),
                        @Result(property = "updateTime", column = "update_time"),
                        @Result(property = "role", column = "role") })
        List<User> list();

        @Select("SELECT COUNT(1) FROM user")
        int count();
}