package com.mobvista.apptag.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.mobvista.apptag.entity.Feat;
import com.mobvista.apptag.mapper.FeatDao;
import com.mobvista.apptag.service.FeatService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author wangjf
 */

@Service("featService")
public class FeatServiceImpl implements FeatService {

    @Autowired
    private FeatDao featDao;

    @Override
    public Map<String, String> getMap() {
        Map<String, String> map = new HashMap<>();
        List<Feat> feats = featDao.listAll();
        for (Feat feat : feats) {
            map.put(feat.getSecondId(), feat.getSecondTag());
        }
        return map;
    }
}