package com.mobvista.apptag.utils;

import com.mongodb.MongoClientSettings;
import com.mongodb.ServerAddress;
import com.mongodb.client.*;
import com.mongodb.client.model.Filters;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/**
 * @package: com.mobvista.apptag.utils
 * @author: wangjf
 * @date: 2019-07-17
 * @time: 11:38
 * @email: jinfeng.wang@mobvista.com
 * @phone: 152-1062-7698
 */
public class GetPackageFromMongo {
    public static void main(String[] args) {
        try {
            String mongoUrl = "internal-beijing-adServerMongo-virginia-1390640500.us-east-1.elb.amazonaws.com";

            //  MongoClientOptions.Builder builder = new MongoClientOptions.Builder()
            MongoClientSettings settings = MongoClientSettings.builder()
                    .retryWrites(true)
                    .applyToConnectionPoolSettings(builder ->
                            builder.maxConnectionIdleTime(3000, TimeUnit.MILLISECONDS))
                    .applyToConnectionPoolSettings(builder ->
                            builder.maxSize(100))
                    .applyToConnectionPoolSettings(builder ->
                            builder.minSize(10))
                    .applyToClusterSettings(builder -> {
                        builder.hosts(Arrays.asList(new ServerAddress(mongoUrl, 27017)));
                    }).build();

            //  MongoClient mongoClient = new MongoClient(new ServerAddress("server ip",27017), Arrays.asList(credential2),opts);
            // 连接到 mongodb 服务

            MongoClient mongoClient = MongoClients.create(settings);

            // 连接到数据库
            MongoDatabase mongoDatabase = mongoClient.getDatabase("new_adn");
            System.out.println("Connect to database successfully");

            MongoCollection<Document> collection = mongoDatabase.getCollection("campaign");
            MongoCursor<Document> findIterable = collection.find(Filters.eq("advertiserId", 903)).iterator();

            Set<String> set = new HashSet<>();

            while (findIterable.hasNext()) {
                String json = findIterable.next().toJson();
                if (GsonUtil.String2JsonObject(json).has("packageName")) {
                    String packageName = GsonUtil.String2JsonObject(json).get("packageName").getAsString();
                    if (StringUtils.isNotBlank(packageName)) {
                        set.add(packageName);
                    }
                }
            }
            System.out.println("packageNames.size ===>>> " + set.size());
            MySqlUtil mySqlUtil = new MySqlUtil();
            mySqlUtil.insert(set);
        } catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
        }
    }
}
