#!/usr/sh

check_await() {
    while [[ true ]];
    do
        if hadoop fs -ls "$1" > /dev/null 2>&1
        then
            break
        fi
        sleep 300
    done
}

today=${ScheduleTime:-$1}
date=$(date +"%Y%m%d" -d "-1 day $today")
date_path=$(date +%Y/%m/%d -d "-1 day $today")

INPUT="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dim_adn_adx_package/${date_path}"

check_await ${INPUT}/_SUCCESS
root_dir=`pwd`

if [[ ! -d "${root_dir}/adx_package/${date}" ]]; then
  mkdir -p ${root_dir}/adx_package/${date}
else
  rm -rf ${root_dir}/adx_package/${date}
  mkdir -p ${root_dir}/adx_package/${date}
fi

result="${root_dir}/adx_package/${date}/package.txt"

hdfs dfs -text ${INPUT}/* >${result}
if [[ $? -ne 0 ]]; then
    exit 255
fi

java -jar -Dloader.main=com.mobvista.apptag.utils.GetPackageFromAdxFile apptag.jar ${result}

if [[ $? -ne 0 ]]; then
    exit 255
fi