package com.mobvista.apptag.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mobvista.apptag.config.WebSecurityConfig;
import com.mobvista.apptag.entity.ECTag;
import com.mobvista.apptag.entity.Feat;
import com.mobvista.apptag.entity.Tag;
import com.mobvista.apptag.mapper.FeatDao;
import com.mobvista.apptag.mapper.TagDao;
import com.mobvista.apptag.mapper.UserDao;
import com.mobvista.apptag.service.*;
import com.mobvista.apptag.utils.PageUtil;
import com.mobvista.apptag.utils.Query;
import com.mobvista.apptag.utils.R;
import net.sf.json.JSONArray;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author wangjf
 */
@Controller
@RequestMapping("/ec_tag")
public class ECTagController {

    @Autowired
    private ECTagService ecTagService;

    @Autowired
    private ECResultService ecResultService;

    @Autowired
    private FeatService featService;

    @Autowired
    private TagDao tagDao;

    @Autowired
    private FeatDao featDao;

    @Autowired
    private UserDao userDao;

    public static final Logger logger = LoggerFactory.getLogger(ECTagController.class);

    @GetMapping("/edit")
    String edit(@RequestParam(name = "urlMd5") String urlMd5, Model model) {
        ECTag ecTag = ecTagService.find(urlMd5);
        model.addAttribute("ecTag", ecTag);
        List<Feat> categoryFeat = featDao.firstList("05");
        JSONArray jsonArray = JSONArray.fromObject(categoryFeat);
        model.addAttribute("firstECTag", jsonArray);
        List<Feat> secondCategoryFeat = featDao.list("05");
        JSONArray secondJsonArray = JSONArray.fromObject(secondCategoryFeat);
        model.addAttribute("secondECTag", secondJsonArray);
        return "ec_tag/edit";
    }

    @PostMapping("/save")
    @ResponseBody
    R save(@SessionAttribute(WebSecurityConfig.SESSION_KEY) String userName,
           @RequestParam(name = "urlMd5") String urlMd5,
           @RequestParam(name = "ecCode", required = false) String ecCode) {
        Map<String, String> codeMap = new HashMap<String, String>();
        Map<String, String> featMap = featService.getMap();

        // 类型标签
        if (StringUtils.isNotBlank(ecCode)) {
            String[] codes = ecCode.split(",");
            for (String code : codes) {
                codeMap.put(code, featMap.get(code));
            }
        }

        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            json = mapper.writeValueAsString(codeMap);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }

        if (ecTagService.update(urlMd5, userName) && ecResultService.save(urlMd5, userName, json)) {
            return R.ok();
        } else {
            return R.error(1, "保存失败！");
        }
    }

    @PostMapping("/list")
    @ResponseBody
    public PageUtil list(@SessionAttribute(WebSecurityConfig.SESSION_KEY) String userName,
                         @RequestBody Query query, @RequestParam(name = "tag", required = false, defaultValue = "0") int tag) {
        List<ECTag> tags = ecTagService.list(userName, query);
        int total = ecTagService.count(userName, query);
        PageUtil pageUtil = new PageUtil(tags, total);
        return pageUtil;
    }

    @GetMapping("")
    String falseTag(Model model) {
        return "ec_tag/list";
    }
}