package com.mobvista.apptag.entity;

import com.gitee.sunchenbin.mybatis.actable.annotation.Column;
import com.gitee.sunchenbin.mybatis.actable.annotation.Table;
import com.gitee.sunchenbin.mybatis.actable.constants.MySqlTypeConstant;

import java.io.Serializable;
import java.util.Date;

/**
 * @author wangjf
 */
@Table(name = "ec_storage")
public class ECStorage implements Serializable {

    private static final long serialVersionUID = 1L;
    @Column(name = "url_md5",type = MySqlTypeConstant.VARCHAR,isKey = true,isNull = false)
    private String urlMd5;
    @Column(name = "preview_url", type = MySqlTypeConstant.TEXT, isNull = false)
    private String previewUrl;
    //  标签
    @Column(name = "tag", type = MySqlTypeConstant.TEXT)
    private String tag;
    //  入库时间
    @Column(name = "update_time", type = MySqlTypeConstant.DATETIME, isNull = false)
    private Date updateTime;
    //  标注人员（仅超管用户可以修改已入库的标签）
    @Column(name = "user_id", type = MySqlTypeConstant.VARCHAR, length = 100)
    private String userId;

    public String getUrlMd5() {
        return urlMd5;
    }

    public void setUrlMd5(String urlMd5) {
        this.urlMd5 = urlMd5;
    }

    public String getPreviewUrl() {
        return previewUrl;
    }

    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}