package com.mobvista.apptag.entity;

import com.gitee.sunchenbin.mybatis.actable.annotation.Column;
import com.gitee.sunchenbin.mybatis.actable.annotation.Table;
import com.gitee.sunchenbin.mybatis.actable.constants.MySqlTypeConstant;

import java.io.Serializable;
import java.util.Date;

/**
 * @author wangjf
 */
@Table(name = "ec_tag_list")
public class ECTag implements Serializable {

    private static final long serialVersionUID = -1507448849738387249L;
    // 电商单子中的 URL
    @Column(name = "url_md5", type = MySqlTypeConstant.VARCHAR, isKey = true, isNull = false)
    private String urlMd5;
    // 电商单子中的 URL
    @Column(name = "preview_url", type = MySqlTypeConstant.TEXT, isNull = false)
    private String previewUrl;
    // 标注者
    @Column(name = "user_id", type = MySqlTypeConstant.VARCHAR)
    private String userId;
    // 标注状态：0.未标注,1.已标注
    @Column(name = "tag", type = MySqlTypeConstant.INT, length = 10, defaultValue = "0")
    private Integer tag;
    // 入库状态：0.未入库,1.已入库
    @Column(name = "flag", type = MySqlTypeConstant.INT, length = 10, defaultValue = "0")
    private Integer flag;
    // 标注时间
    @Column(name = "update_time", type = MySqlTypeConstant.DATETIME)
    private Date updateTime;

    public String getUrlMd5() {
        return urlMd5;
    }

    public void setUrlMd5(String urlMd5) {
        this.urlMd5 = urlMd5;
    }

    public String getPreviewUrl() {
        return previewUrl;
    }

    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    /**
     * @return the user_id
     */
    public String getUserId() {
        return userId;
    }

    /**
     * @param userId the userId to set
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }

    /**
     * @return the tag
     */
    public Integer getTag() {
        return tag;
    }

    /**
     * @param tag the tag to set
     */
    public void setTag(Integer tag) {
        this.tag = tag;
    }

    /**
     * @return the flag
     */
    public Integer getFlag() {
        return flag;
    }

    /**
     * @param flag the flag to set
     */
    public void setFlag(Integer flag) {
        this.flag = flag;
    }

    /**
     * @return the updateTime
     */
    public Date getUpdateTime() {
        return updateTime;
    }

    /**
     * @param updateTime the updateTime to set
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

}