package com.mobvista.apptag.entity;

import com.gitee.sunchenbin.mybatis.actable.annotation.Column;
import com.gitee.sunchenbin.mybatis.actable.annotation.Table;
import com.gitee.sunchenbin.mybatis.actable.constants.MySqlTypeConstant;

import java.io.Serializable;
import java.util.Date;

/**
 * @author wangjf
 */
@Table(name = "ec_tag_result")
public class ECTagResult implements Serializable {

    private static final long serialVersionUID = 1L;
    // URL MD5
    @Column(name = "url_md5", type = MySqlTypeConstant.VARCHAR, isNull = false)
    private String urlMd5;
    @Column(name = "preview_url", type = MySqlTypeConstant.VARCHAR)
    private String previewUrl;
    // 标注的标签ID
    @Column(name = "feat_id", type = MySqlTypeConstant.VARCHAR)
    private String featId;
    // 标注的中文全名
    @Column(name = "comment", type = MySqlTypeConstant.VARCHAR)
    private String comment;
    // 是否入库
    @Column(name = "flag", type = MySqlTypeConstant.INT,defaultValue = "0")
    private Integer flag;
    // 用户ID
    @Column(name = "user_id", type = MySqlTypeConstant.VARCHAR, isNull = false)
    private String userId;
    // 入库时间
    @Column(name = "update_time", type = MySqlTypeConstant.DATETIME, isNull = false)
    private Date updateTime;

    public String getUrlMd5() {
        return urlMd5;
    }

    public void setUrlMd5(String urlMd5) {
        this.urlMd5 = urlMd5;
    }

    public String getPreviewUrl() {
        return previewUrl;
    }

    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    /**
     * @param featId the featId to set
     */
    public void setFeatId(String featId) {
        this.featId = featId;
    }

    /**
     * @return the featId
     */
    public String getFeatId() {
        return featId;
    }

    /**
     * @return the comment
     */
    public String getComment() {
        return comment;
    }

    /**
     * @param comment the comment to set
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    /**
     *
     * @return the flag
     */
    public Integer getFlag() {
        return flag;
    }

    /**
     *
     * @param flag the flag to set
     */
    public void setFlag(Integer flag) {
        this.flag = flag;
    }

    /**
     * @return the userId
     */
    //  @Id
    public String getUserId() {
        return userId;
    }

    /**
     * @param userId the userId to set
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }

    /**
     * @return the updateTime
     */
    public Date getUpdateTime() {
        return updateTime;
    }

    /**
     * @param updateTime the updateTime to set
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

}