package com.mobvista.apptag.mapper;

import com.mobvista.apptag.entity.ECTagResult;
import com.mobvista.apptag.entity.TagResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.*;

import java.util.List;

/**
 * @author wangjf
 */

public interface ECResultDao {

    @Insert("REPLACE INTO ec_tag_result(url_md5,preview_url,feat_id,comment,user_id,update_time) VALUES(#{urlMd5}, #{previewUrl}, #{featId}, #{comment}, #{userId}, #{updateTime})")
    boolean save(ECTagResult ecTagResult);

    @Delete("DELETE FROM ec_tag_result WHERE url_md5 = #{urlMd5}")
    boolean delete(String urlMd5);

    @Select("SELECT * FROM ec_tag_result WHERE url_md5 = #{urlMd5} AND user_id = #{userId}")
    @Results({@Result(property = "urlMd5", column = "url_md5"),
            @Result(property = "previewUrl", column = "preview_url"),
            @Result(property = "featId", column = "feat_id"),
            @Result(property = "comments", column = "comments"),
            @Result(property = "userId", column = "user_id"),
            @Result(property = "updateTime", column = "update_time")})
    ECTagResult find(String urlMd5, String userId);

    @SelectProvider(type = MapperProvider.class, method = "list")
    @Results({@Result(property = "urlMd5", column = "url_md5"),
            @Result(property = "previewUrl", column = "preview_url"),
            @Result(property = "featId", column = "feat_id"),
            @Result(property = "comments", column = "comments"),
            @Result(property = "userId", column = "user_id"),
            @Result(property = "updateTime", column = "update_time")})
    List<ECTagResult> list(String userId, String search);

    @SelectProvider(type = MapperProvider.class, method = "count")
    int count(String userId, String search);

    @SelectProvider(type = MapperProvider.class, method = "listAll")
    @Results({@Result(property = "urlMd5", column = "url_md5"),
            @Result(property = "previewUrl", column = "preview_url"),
            @Result(property = "featId", column = "feat_id"),
            @Result(property = "comments", column = "comments"),
            @Result(property = "userId", column = "user_id"),
            @Result(property = "updateTime", column = "update_time")})
    List<ECTagResult> listAll(String search);

    @SelectProvider(type = MapperProvider.class, method = "countAll")
    int countAll(String search);

    class MapperProvider {
        public String list(String userId, String search) {
            String sql = "SELECT * FROM ec_tag_result WHERE user_id = #{userId} AND flag != 1";
            if (StringUtils.isNotBlank(search)) {
                sql += " AND LOWER(preview_url) LIKE '%" + search + "%'";
            }
            return sql;
        }

        public String count(String userId, String search) {
            String sql = "SELECT COUNT(1) FROM ec_tag_result WHERE user_id = #{userId} AND flag != 1";
            if (StringUtils.isNotBlank(search)) {
                sql += " AND LOWER(preview_url) LIKE '%" + search + "%'";
            }
            return sql;
        }

        public String listAll(String search) {
            String sql = "SELECT * FROM ec_tag_result WHERE flag != 1";
            if (StringUtils.isNotBlank(search)) {
                sql += " AND LOWER(preview_url) LIKE '%" + search + "%'";
            }
            return sql;
        }

        public String countAll(String search) {
            String sql = "SELECT COUNT(1) FROM ec_tag_result WHERE flag != 1";
            if (StringUtils.isNotBlank(search)) {
                sql += " AND LOWER(preview_url) LIKE '%" + search + "%'";
            }
            return sql;
        }
    }
}