package com.mobvista.apptag.mapper;

import com.mobvista.apptag.entity.ECTag;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.*;

import java.util.List;

/**
 * @author wangjf
 */

public interface ECTagDao {

    @Update("UPDATE ec_tag_list SET user_id = #{userId}, tag = #{tag}, update_time = #{updateTime} WHERE preview_url = #{previewUrl}")
    boolean update(ECTag tag);

    @SelectProvider(type = MapperProvider.class, method = "list")
    @Results({@Result(property = "urlMd5", column = "url_md5"),
            @Result(property = "previewUrl", column = "preview_url"),
            @Result(property = "tag", column = "tag"),
            @Result(property = "flag", column = "flag"),
            @Result(property = "userId", column = "user_id"),
            @Result(property = "updateTime", column = "update_time")})
    List<ECTag> list(String search, int tag, String userId);

    @SelectProvider(type = MapperProvider.class, method = "count")
    int count(String search, int tag, String userId);

    class MapperProvider {
        public String list(String search, int tag, String userId) {
            String sql = "SELECT * FROM ec_tag_list WHERE tag < " + tag;

            if (StringUtils.isNotBlank(userId)) {
                sql += " AND (user_id NOT LIKE '%" + userId + "%' OR user_id IS NULL) AND flag = 0";
            }
            if (StringUtils.isNotBlank(search)) {
                sql += " AND LOWER(preview_url) LIKE '%" + search + "%'";
            }
            return sql;
        }

        public String count(String search, int tag, String userId) {
            String sql = "SELECT COUNT(1) FROM ec_tag_list WHERE tag < " + tag;
            if (StringUtils.isNotBlank(userId)) {
                sql += " AND (user_id NOT LIKE '%" + userId + "%' OR user_id IS NULL) AND flag = 0";
            }
            if (StringUtils.isNotBlank(search)) {
                sql += " AND LOWER(preview_url) LIKE '%" + search + "%'";
            }
            return sql;
        }
    }

    @Select("SELECT * FROM ec_tag_list WHERE tag = #{tag} ORDER BY install DESC")
    @Results({@Result(property = "urlMd5", column = "url_md5"),
            @Result(property = "previewUrl", column = "preview_url"),
            @Result(property = "tag", column = "tag"),
            @Result(property = "flag", column = "flag"),
            @Result(property = "userId", column = "user_id"),
            @Result(property = "updateTime", column = "update_time")})
    List<ECTag> listAll(int tag);

    @Select("SELECT * FROM ec_tag_list LIMIT 1")
    @Results({@Result(property = "urlMd5", column = "url_md5"),
            @Result(property = "previewUrl", column = "preview_url"),
            @Result(property = "tag", column = "tag"),
            @Result(property = "flag", column = "flag"),
            @Result(property = "userId", column = "user_id"),
            @Result(property = "updateTime", column = "update_time")})
    ECTag one();

    @Select("SELECT * FROM ec_tag_list WHERE url_md5 = #{urlMd5}")
    @Results({@Result(property = "urlMd5", column = "url_md5"),
            @Result(property = "previewUrl", column = "preview_url"),
            @Result(property = "tag", column = "tag"),
            @Result(property = "flag", column = "flag"),
            @Result(property = "userId", column = "user_id"),
            @Result(property = "updateTime", column = "update_time")})
    ECTag find(String urlMd5);
}