package com.mobvista.apptag.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;

/**
 * @package: com.mobvista.apptag.utils
 * @author: wangjf
 * @date: 2019-07-17
 * @time: 11:38
 * @email: jinfeng.wang@mobvista.com
 * @phone: 152-1062-7698
 */
public class GetPackageFromAdxFile {

    public static void main(String[] args) {
        try {
            String filePath = "";
            if (args.length == 1) {
                filePath = args[0];
            } else {
                System.out.println("Please check input!");
                System.exit(1);
            }
            Set<String> set = readTxtFileIntoStringSet(filePath);
            System.out.println("packageNames.size ===>>> " + set.size());
            MySqlUtil mySqlUtil = new MySqlUtil();
            mySqlUtil.insert(set);
        } catch (Exception e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public static Set<String> readTxtFileIntoStringSet(String filePath) {

        Set<String> set = new HashSet<>();
        try {
            String encoding = "GBK";
            File file = new File(filePath);
            //  判断文件是否存在
            if (file.isFile() && file.exists()) {
                //  考虑到编码格式
                InputStreamReader read = new InputStreamReader(
                        new FileInputStream(file), encoding);
                BufferedReader bufferedReader = new BufferedReader(read);
                String lineTxt;
                while ((lineTxt = bufferedReader.readLine()) != null) {
                    String packageName = lineTxt;
                    set.add(packageName);
                }
                bufferedReader.close();
                read.close();
            } else {
                System.out.println("找不到指定的文件");
            }
        } catch (Exception e) {
            System.out.println("读取文件内容出错");
            e.printStackTrace();
        }
        return set;
    }
}
