var prefix = "result";
$(function () {
    load();
});

function load() {
    $("#exampleTable").bootstrapTable({
        method: "post", // 服务器数据的请求方式 get or post
        url: prefix + "/list", // 服务器数据的加载地址
        striped: true, // 设置为true会有隔行变色效果
        dataType: "json", // 服务器返回的数据类型
        pagination: true, // 设置为true会在底部显示分页条
        // queryParamsType : "limit",
        // //设置为limit则会发送符合RESTFull格式的参数
        singleSelect: false, // 设置为true将禁止多选
        iconSize: "outline",
        toolbar: "#exampleToolbar",
        // contentType : "application/x-www-form-urlencoded",
        // //发送到服务器的数据编码类型
        pageSize: 10, // 如果设置了分页，每页数据条数
        pageNumber: 1, // 如果设置了分布，首页页码
        //  search: true, // 是否显示搜索框
        showColumns: true, // 是否显示内容下拉框（选择显示的列）
        sidePagination: "server", // 设置在哪里进行分页，可选值为"client" 或者 "server"
        // queryParams : queryParams,
        queryParams: function (params) {
            return {
                // 说明：传入后台的参数包括offset开始索引，limit步长，sort排序列，order：desc或者,以及所有列的键值对
                limit: params.limit,
                offset: params.offset,
                search: $('#searchName').val()
            };
        },
        // //请求服务器数据时，你可以通过重写参数的方式添加一些额外的参数，例如 toolbar 中的参数 如果
        // queryParamsType = 'limit' ,返回参数必须包含
        // limit, offset, search, sort, order 否则, 需要包含:
        // pageSize, pageNumber, searchText, sortName,
        // sortOrder.
        // 返回false将会终止请求
        columns: [{
            // 列配置项
            // 数据类型，详细参数配置参见文档http://bootstrap-table.wenzhixin.net.cn/zh-cn/documentation/
            checkbox: true
            // 列表中显示复选框
        },
            {
                field: "packageName", // 列字段名
                title: "包名", // 列标题
                align: "center"
            },
            {
                field: "appName",
                title: "应用名称",
                align: "center"
            },
            {
                field: "platform",
                title: "平台",
                align: "center"
            },
            {
                field: "featId",
                title: "已标标签",
                align: "center"
            },
            {
                title: "操作",
                field: "packageName",
                align: "center",
                formatter: function (value, row, index) {
                    var e =
                        '<a class="btn btn-primary btn-sm ' +
                        s_edit_h +
                        '" href="#" mce_href="#" title="编辑" onclick="edit(\'' +
                        row.packageName +'\',\''+row.userId+ '\')"><i class="fa fa-edit"></i></a> ';
                    return e;
                }
            }
        ]
    });
}

function reLoad(type) {
    if (type == 1) {
        var opt = {
            query: {
                offset: 0
            }
        };
        $("#exampleTable").bootstrapTable("refresh", opt);
    } else {
        $("#exampleTable").bootstrapTable("refresh");
    }
}


function edit(package_name, user_id) {
    layer.open({
        type: 2,
        title: "标签标注",
        maxmin: true,
        shadeClose: true, // 点击遮罩关闭层
        area: ["800px", "580px"],
        content: prefix + "/edit?packageName=" + package_name + "&userId=" + user_id // iframe的url
    });
}