package com.mobvista.apptag.entity;

import com.gitee.sunchenbin.mybatis.actable.annotation.Column;
import com.gitee.sunchenbin.mybatis.actable.annotation.Table;
import com.gitee.sunchenbin.mybatis.actable.constants.MySqlTypeConstant;

import java.io.Serializable;
import java.util.Date;

/**
 * @author wangjf
 */
//  @Entity
@Table(name = "tag_result")
//  @IdClass(PrimaryKey.class)
public class TagResult implements Serializable {

    private static final long serialVersionUID = 1L;
    // APP 包名
    @Column(name = "package_name", type = MySqlTypeConstant.VARCHAR, isNull = false)
    private String packageName;
    // APP 名称
    @Column(name = "app_name", type = MySqlTypeConstant.VARCHAR)
    private String appName;
    // 平台：ios,android
    @Column(name = "platform", type = MySqlTypeConstant.VARCHAR, length = 10)
    private String platform;
    // 标注的标签ID
    @Column(name = "feat_id", type = MySqlTypeConstant.VARCHAR)
    private String featId;
    // 标注的中文全名
    @Column(name = "comment", type = MySqlTypeConstant.VARCHAR)
    private String comment;
    // 用户ID
    @Column(name = "user_id", type = MySqlTypeConstant.VARCHAR, isNull = false)
    private String userId;
    // 入库时间
    @Column(name = "update_time", type = MySqlTypeConstant.DATETIME, isNull = false)
    private Date updateTime;

    /**
     * @return the package_name
     */
    //  @Id
    public String getPackageName() {
        return packageName;
    }

    /**
     * @param packageName the packageName to set
     */
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    /**
     * @return the app_name
     */
    public String getAppName() {
        return appName;
    }

    /**
     * @param appName the appName to set
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * @return the platform
     */
    public String getPlatform() {
        return platform;
    }

    /**
     * @param platform the platform to set
     */
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    /**
     * @param featId the featId to set
     */
    public void setFeatId(String featId) {
        this.featId = featId;
    }

    /**
     * @return the featId
     */
    public String getFeatId() {
        return featId;
    }

    /**
     * @return the comment
     */
    public String getComment() {
        return comment;
    }

    /**
     * @param comment the comment to set
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    /**
     * @return the userId
     */
    //  @Id
    public String getUserId() {
        return userId;
    }

    /**
     * @param userId the userId to set
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }

    /**
     * @return the updateTime
     */
    public Date getUpdateTime() {
        return updateTime;
    }

    /**
     * @param updateTime the updateTime to set
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

}