package com.mobvista.apptag.entity;

import java.util.Date;

import com.gitee.sunchenbin.mybatis.actable.annotation.Column;
import com.gitee.sunchenbin.mybatis.actable.annotation.Table;
import com.gitee.sunchenbin.mybatis.actable.command.BaseModel;
import com.gitee.sunchenbin.mybatis.actable.constants.MySqlTypeConstant;

/**
 * @author wangjf
 */

@Table(name = "user")
public class User extends BaseModel {

    private static final long serialVersionUID = 538131959213385757L;
    // 用户ID
    @Column(name = "user_id", type = MySqlTypeConstant.VARCHAR, length = 255, isKey = true, isNull = false)
    private String userId;
    // 用户名
    @Column(name = "user_name", type = MySqlTypeConstant.VARCHAR, length = 255, isNull = true)
    private String userName;
    // 密码
    @Column(name = "password", type = MySqlTypeConstant.VARCHAR, length = 255, isNull = false)
    private String password;
    // 用户状态：0.停用,1.正常
    @Column(name = "state", type = MySqlTypeConstant.INT, length = 1, isNull = false, defaultValue = "1")
    private Integer state;
    // 用户角色：0.普通标注人员,1.超级标注员
    @Column(name = "role", type = MySqlTypeConstant.INT, length = 1, isNull = false, defaultValue = "0")
    private Integer role;
    // 更新时间
    @Column(name = "update_time", type = MySqlTypeConstant.DATETIME, isNull = false)
    private Date updateTime;
    // 标注量
    @Column(name = "count", type = MySqlTypeConstant.BIGINT, isNull = false, defaultValue = "0")
    private Integer count;

    /**
     * @return the userId
     */
    public String getUserId() {
        return userId;
    }

    /**
     * @param userId the userId to set
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }

    /**
     * @return the userName
     */
    public String getUserName() {
        return userName;
    }

    /**
     * @param userName the userName to set
     */
    public void setUserName(String userName) {
        this.userName = userName;
    }

    /**
     * @return the role
     */
    public Integer getRole() {
        return role;
    }

    /**
     * @param role the role to set
     */
    public void setRole(Integer role) {
        this.role = role;
    }

    /**
     * @return the state
     */
    public Integer getState() {
        return state;
    }

    /**
     * @param state the state to set
     */
    public void setState(Integer state) {
        this.state = state;
    }

    /**
     * @return the password
     */
    public String getPassword() {
        return password;
    }

    /**
     * @param password the password to set
     */
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * @return the updateTime
     */
    public Date getUpdateTime() {
        return updateTime;
    }

    /**
     * @param updateTime the updateTime to set
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * @return the count
     */
    public Integer getCount() {
        return count;
    }

    /**
     * @param count the count to set
     */
    public void setCount(Integer count) {
        this.count = count;
    }
}