package com.mobvista.apptag.mapper;

import com.mobvista.apptag.entity.TagResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.*;

import java.util.List;

/**
 * @author wangjf
 */

public interface ResultDao {

    @Insert("REPLACE INTO tag_result(package_name,app_name,platform,feat_id,comment,user_id,update_time) VALUES(#{packageName}, #{appName}, #{platform}, #{featId}, #{comment}, #{userId}, #{updateTime})")
    boolean save(TagResult tagResult);

    @Select("SELECT * FROM tag_result WHERE package_name = #{packageName} AND user_id = #{userId}")
    @Results({@Result(property = "packageName", column = "package_name"),
            @Result(property = "appName", column = "app_name"),
            @Result(property = "platform", column = "platform"),
            @Result(property = "featId", column = "feat_id"),
            @Result(property = "comments", column = "comments"),
            @Result(property = "userId", column = "user_id"),
            @Result(property = "updateTime", column = "update_time")})
    TagResult find(String packageName, String userId);

    /*
    @Select("SELECT * FROM tag_result WHERE user_id = #{userId}")
    @Results({@Result(property = "packageName", column = "package_name"),
            @Result(property = "appName", column = "app_name"),
            @Result(property = "platform", column = "platform"),
            @Result(property = "featId", column = "feat_id"),
            @Result(property = "comments", column = "comments"),
            @Result(property = "userId", column = "user_id"),
            @Result(property = "updateTime", column = "update_time")})
    List<TagResult> list(String userId);
     */

    @SelectProvider(type = ListMapperProvider.class, method = "list")
    @Results({@Result(property = "packageName", column = "package_name"),
            @Result(property = "appName", column = "app_name"),
            @Result(property = "platform", column = "platform"),
            @Result(property = "featId", column = "feat_id"),
            @Result(property = "comments", column = "comments"),
            @Result(property = "userId", column = "user_id"),
            @Result(property = "updateTime", column = "update_time")})
    List<TagResult> list(String userId, String search);

    class ListMapperProvider {
        public String list(String userId, String search) {
            String sql = "SELECT * FROM tag_result WHERE user_id = #{userId}";
            if (StringUtils.isNotBlank(search)) {
                sql += " AND LOWER(package_name) LIKE '%" + search + "%'";
            }
            return sql;
        }
    }

    /*
    @Select("SELECT * FROM tag_result")
    @Results({@Result(property = "packageName", column = "package_name"),
            @Result(property = "appName", column = "app_name"),
            @Result(property = "platform", column = "platform"),
            @Result(property = "featId", column = "feat_id"),
            @Result(property = "comments", column = "comments"),
            @Result(property = "userId", column = "user_id"),
            @Result(property = "updateTime", column = "update_time")})
    List<TagResult> listAll(String search);
     */

    @SelectProvider(type = ListAllMapperProvider.class, method = "listAll")
    @Results({@Result(property = "packageName", column = "package_name"),
            @Result(property = "appName", column = "app_name"),
            @Result(property = "platform", column = "platform"),
            @Result(property = "featId", column = "feat_id"),
            @Result(property = "comments", column = "comments"),
            @Result(property = "userId", column = "user_id"),
            @Result(property = "updateTime", column = "update_time")})
    List<TagResult> listAll(String search);

    class ListAllMapperProvider {
        public String listAll(String search) {
            String sql = "SELECT * FROM tag_result";
            if (StringUtils.isNotBlank(search)) {
                sql += " WHERE LOWER(package_name) LIKE '%" + search + "%'";
            }
            return sql;
        }
    }

    /*
    @Select("SELECT COUNT(1) FROM tag_result WHERE user_id = #{userId}")
    int count(String userId);
     */

    @SelectProvider(type = CountMapperProvider.class, method = "count")
    int count(String userId, String search);

    class CountMapperProvider {
        public String count(String userId, String search) {
            String sql = "SELECT COUNT(1) FROM tag_result WHERE user_id = #{userId}";
            if (StringUtils.isNotBlank(search)) {
                sql += " AND LOWER(package_name) LIKE '%" + search + "%'";
            }
            return sql;
        }
    }

    /*
    @Select("SELECT COUNT(1) FROM tag_result")
    int countAll(String search);
     */

    @SelectProvider(type = CountAllMapperProvider.class, method = "countAll")
    int countAll(String search);

    class CountAllMapperProvider {
        public String countAll(String search) {
            String sql = "SELECT COUNT(1) FROM tag_result";
            if (StringUtils.isNotBlank(search)) {
                sql += " WHERE LOWER(package_name) LIKE '%" + search + "%'";
            }
            return sql;
        }
    }
}