package com.mobvista.apptag.mapper;

import com.mobvista.apptag.entity.Tag;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.*;

import java.util.List;

/**
 * @author wangjf
 */

public interface TagDao {
    @Update("UPDATE tag_list SET user_id = #{userId}, tag = #{tag},update_time = #{updateTime} WHERE package_name = #{packageName}")
    boolean update(Tag tag);

    /*
    @Select("SELECT * FROM tag_list WHERE tag = #{tag} ORDER BY install DESC")
    @Results({@Result(property = "packageName", column = "package_name"),
            @Result(property = "appName", column = "app_name"),
            @Result(property = "platform", column = "platform"),
            @Result(property = "category", column = "category"), @Result(property = "url", column = "url"),
            @Result(property = "install", column = "install"), @Result(property = "tag", column = "tag"),
            @Result(property = "userId", column = "user_id"),
            @Result(property = "updateTime", column = "update_time")})
    List<Tag> list(int tag);
     */

    @SelectProvider(type = ListMapperProvider.class, method = "list")
    @Results({@Result(property = "packageName", column = "package_name"),
            @Result(property = "appName", column = "app_name"),
            @Result(property = "platform", column = "platform"),
            @Result(property = "category", column = "category"), @Result(property = "url", column = "url"),
            @Result(property = "install", column = "install"), @Result(property = "tag", column = "tag"),
            @Result(property = "userId", column = "user_id"),
            @Result(property = "updateTime", column = "update_time")})
    List<Tag> list(String search, int tag);

    class ListMapperProvider {
        public String list(String search, int tag) {
            String sql = "SELECT * FROM tag_list WHERE tag < " + tag;

            if (StringUtils.isNotBlank(search)) {
                sql += " AND LOWER(package_name) LIKE '%" + search + "%'";
            }
            return sql + " ORDER BY install DESC";
        }
    }

    @Select("SELECT * FROM tag_list WHERE tag = #{tag} ORDER BY install DESC")
    @Results({@Result(property = "packageName", column = "package_name"),
            @Result(property = "appName", column = "app_name"),
            @Result(property = "platform", column = "platform"),
            @Result(property = "category", column = "category"), @Result(property = "url", column = "url"),
            @Result(property = "install", column = "install"), @Result(property = "tag", column = "tag"),
            @Result(property = "userId", column = "user_id"),
            @Result(property = "updateTime", column = "update_time")})
    List<Tag> listAll(int tag);

    @Select("SELECT * FROM tag_list ORDER BY install DESC LIMIT 1")
    @Results({@Result(property = "packageName", column = "package_name"),
            @Result(property = "appName", column = "app_name"),
            @Result(property = "platform", column = "platform"),
            @Result(property = "category", column = "category"), @Result(property = "url", column = "url"),
            @Result(property = "install", column = "install"), @Result(property = "tag", column = "tag"),
            @Result(property = "userId", column = "user_id"),
            @Result(property = "updateTime", column = "update_time")})
    Tag one();

    @Select("SELECT * FROM tag_list WHERE package_name = #{packageName}")
    @Results({@Result(property = "packageName", column = "package_name"),
            @Result(property = "appName", column = "app_name"),
            @Result(property = "platform", column = "platform"),
            @Result(property = "category", column = "category"), @Result(property = "url", column = "url"),
            @Result(property = "install", column = "install"), @Result(property = "tag", column = "tag"),
            @Result(property = "userId", column = "user_id"),
            @Result(property = "updateTime", column = "update_time")})
    Tag find(String package_name);

    /*
    @Select("SELECT COUNT(1) FROM tag_list WHERE tag = #{tag}")
    int count(int tag);
     */

    @SelectProvider(type = CountMapperProvider.class, method = "count")
    int count(String search, int tag);

    class CountMapperProvider {
        public String count(String search, int tag) {
            String sql = "SELECT COUNT(1) FROM tag_list WHERE tag < " + tag;
            if (StringUtils.isNotBlank(search)) {
                sql += " AND LOWER(package_name) LIKE '%" + search + "%'";
            }
            return sql;
        }
    }
}