package com.mobvista.apptag.service.impl;

import java.util.Date;
import java.util.List;

import com.github.pagehelper.PageHelper;
import com.mobvista.apptag.entity.Tag;
import com.mobvista.apptag.entity.User;
import com.mobvista.apptag.mapper.TagDao;
import com.mobvista.apptag.mapper.UserDao;
import com.mobvista.apptag.service.TagService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("tagService")
public class TagServiceImpl implements TagService {

    @Autowired
    private TagDao tagDao;

    @Autowired
    private UserDao userDao;

    @Override
    public boolean update(String packageName, String userName) {
        Tag tag = tagDao.find(packageName);
        tag.setUpdateTime(new Date());
        tag.setTag(1);
        User user = userDao.find(userName);
        if (!user.getUserId().equals(tag.getUserId())) {
            user.setCount(user.getCount() + 1);
            this.userDao.update(user);
        }
        tag.setUserId(user.getUserId());
        return this.tagDao.update(tag);
    }

    @Override
    public Tag find(String packageName) {
        return tagDao.find(packageName);
    }

    @Override
    public List<Tag> list(int pageNum, int pageSize) {
        PageHelper.startPage(pageNum, pageSize);
        return tagDao.list(1);
    }
}