package com.mobvista.apptag.entity;

import com.gitee.sunchenbin.mybatis.actable.annotation.Column;
import com.gitee.sunchenbin.mybatis.actable.annotation.Table;
import com.gitee.sunchenbin.mybatis.actable.constants.MySqlTypeConstant;

import java.io.Serializable;
import java.util.Date;

/**
 * @author wangjf
 */
@Table(name = "storage_result")
public class StorageEntity implements Serializable {

    private static final long serialVersionUID = 1L;
    //  APP 包名
    @Column(name = "package_name", type = MySqlTypeConstant.VARCHAR, isNull = false)
    private String packageName;
    //  APP 名称
    @Column(name = "app_name", type = MySqlTypeConstant.VARCHAR)
    private String appName;
    //  平台：ios,android
    @Column(name = "platform", type = MySqlTypeConstant.VARCHAR, length = 10)
    private String platform;
    //  标签ID
    @Column(name = "feat_id", type = MySqlTypeConstant.VARCHAR, length = 10)
    private String featId;
    //  入库时间
    @Column(name = "update_time", type = MySqlTypeConstant.DATETIME, isNull = false)
    private Date updateTime;
    //  总人数，标注该 package 的总人数
    @Column(name = "user_count", type = MySqlTypeConstant.INT)
    private int userCount;
    //  标签人数，标注该 标签的 人数
    @Column(name = "tag_count", type = MySqlTypeConstant.INT)
    private int tagCount;
    //  标注比例
    @Column(name = "tag_rate", type = MySqlTypeConstant.DOUBLE)
    private double tagRate;

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getFeatId() {
        return featId;
    }

    public void setFeatId(String featId) {
        this.featId = featId;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public int getUserCount() {
        return userCount;
    }

    public void setUserCount(int userCount) {
        this.userCount = userCount;
    }

    public int getTagCount() {
        return tagCount;
    }

    public void setTagCount(int tagCount) {
        this.tagCount = tagCount;
    }

    public double getTagRate() {
        return tagRate;
    }

    public void setTagRate(double tagRate) {
        this.tagRate = tagRate;
    }
}