package com.mobvista.apptag.entity;

import com.gitee.sunchenbin.mybatis.actable.annotation.Column;
import com.gitee.sunchenbin.mybatis.actable.annotation.Table;
import com.gitee.sunchenbin.mybatis.actable.constants.MySqlTypeConstant;

import java.io.Serializable;
import java.util.Date;

/**
 * @author wangjf
 */
@Table(name = "tag_list")
public class Tag implements Serializable {

    private static final long serialVersionUID = -1507448849738387249L;
    // APP 包名
    @Column(name = "package_name", type = MySqlTypeConstant.VARCHAR, length = 255, isKey = true, isNull = false)
    private String packageName;
    // APP 名称
    @Column(name = "app_name", type = MySqlTypeConstant.VARCHAR, length = 255, isNull = true)
    private String appName;
    // 平台：ios,android
    @Column(name = "platform", type = MySqlTypeConstant.VARCHAR, length = 10, isNull = true)
    private String platform;
    // 商店类别
    @Column(name = "category", type = MySqlTypeConstant.VARCHAR, length = 255, isNull = true)
    private String category;
    // 商店链接
    @Column(name = "url", type = MySqlTypeConstant.TEXT, isNull = true)
    private String url;
    // 安装量
    @Column(name = "install", type = MySqlTypeConstant.BIGINT, length = 20, isNull = false)
    private Long install;
    // 标注者
    @Column(name = "user_id", type = MySqlTypeConstant.VARCHAR, length = 255, isNull = true)
    private String userId;
    // 标注状态：0.未标注,1.已标注
    @Column(name = "tag", type = MySqlTypeConstant.INT, length = 10, isNull = true, defaultValue = "0")
    private Integer tag;
    // 标注状态：0.未标注,1.已标注
    @Column(name = "flag", type = MySqlTypeConstant.INT, length = 10, isNull = true, defaultValue = "0")
    private Integer flag;
    // 标注时间
    @Column(name = "update_time", type = MySqlTypeConstant.DATETIME, isNull = true)
    private Date updateTime;

    /**
     * @return the packageName
     */
    public String getPackageName() {
        return packageName;
    }

    /**
     * @param packageName the packageName to set
     */
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    /**
     * @return the appName
     */

    public String getAppName() {
        return appName;
    }

    /**
     * @param appName the appName to set
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * @return the platform
     */
    public String getPlatform() {
        return platform;
    }

    /**
     * @param platform the platform to set
     */
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    /**
     * @return the category
     */
    public String getCategory() {
        return category;
    }

    /**
     * @param category the category to set
     */
    public void setCategory(String category) {
        this.category = category;
    }

    /**
     * @return the url
     */
    public String getUrl() {
        return url;
    }

    /**
     * @param url the url to set
     */
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * @return the install
     */
    public Long getInstall() {
        return install;
    }

    /**
     * @param install the install to set
     */
    public void setInstall(Long install) {
        this.install = install;
    }

    /**
     * @return the user_id
     */
    public String getUserId() {
        return userId;
    }

    /**
     * @param userId the userId to set
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }

    /**
     * @return the tag
     */
    public Integer getTag() {
        return tag;
    }

    /**
     * @param tag the tag to set
     */
    public void setTag(Integer tag) {
        this.tag = tag;
    }

    /**
     * @return the flag
     */
    public Integer getFlag() {
        return flag;
    }

    /**
     * @param flag the flag to set
     */
    public void setFlag(Integer flag) {
        this.flag = flag;
    }

    /**
     * @return the updateTime
     */
    public Date getUpdateTime() {
        return updateTime;
    }

    /**
     * @param updateTime the updateTime to set
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

}