package com.mobvista.apptag.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.mobvista.apptag.entity.Tag;
import com.mobvista.apptag.entity.TagResult;
import com.mobvista.apptag.entity.User;
import com.mobvista.apptag.mapper.ResultDao;
import com.mobvista.apptag.mapper.TagDao;
import com.mobvista.apptag.mapper.UserDao;
import com.mobvista.apptag.service.ResultService;
import com.mobvista.apptag.utils.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author wangjf
 */
@Service("resultService")
public class ResultServiceImpl implements ResultService {

    @Autowired
    private UserDao userDao;
    @Autowired
    private TagDao tagDao;
    @Autowired
    private ResultDao resultDao;

    @Override
    public boolean update(String packageName, String userName) {
        Tag tag = tagDao.find(packageName);
        User user = userDao.find(userName);
        if (!user.getUserId().equals(tag.getUserId())) {
            user.setCount(user.getCount() + 1);
            this.userDao.update(user);
        }
        tag.setUserId(user.getUserId());
        return this.tagDao.update(tag);
    }

    @Override
    public boolean save(String packageName, String userName, String json) {
        Tag tag = tagDao.find(packageName);
        User user = userDao.find(userName);
        TagResult tagResult = new TagResult();
        tagResult.setPackageName(packageName);
        tagResult.setAppName(tag.getAppName());
        tagResult.setPlatform(tag.getPlatform());
        tagResult.setFeatId(json);
        tagResult.setComment("comment");
        tagResult.setUserId(user.getUserId());
        tagResult.setUpdateTime(new Date());
        if (user.getRole() == 1) {
            resultDao.delete(packageName);
        }
        return this.resultDao.save(tagResult);
    }

    @Override
    public TagResult find(String packageName, String userId) {
        return resultDao.find(packageName, userId);
    }

    @Override
    public List<TagResult> list(String userId, Query query) {
        User user = userDao.find(userId);
        List<TagResult> results;
        PageHelper.startPage(query.getOffset() / query.getLimit() + 1, query.getLimit());
        //  results = resultDao.list(userId, query.getSearch().toLowerCase());
        if (user.getRole() == 0) {
            results = resultDao.list(userId, query.getSearch().toLowerCase());
        } else {
            results = resultDao.listAll(query.getSearch().toLowerCase());
        }

        List<TagResult> results2 = new ArrayList<>();
        for (TagResult result : results) {
            JSONObject jsonObject = JSONObject.parseObject(result.getFeatId());
            result.setFeatId(jsonObject.values().toString());
            results2.add(result);
        }
        return results2;
    }

    @Override
    public int count(String userId, String search) {
        User user = userDao.find(userId);
        if (user.getRole() == 0) {
            return resultDao.count(userId, search);
        } else {
            return resultDao.countAll(search);
        }
    }
}