/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class AESEncryptor {
    private final String KEY_GENERATION_ALG = "PBKDF2WithHmacSHA1";
    private final int HASH_ITERATIONS = 10000;
    private final int KEY_LENGTH = 128;
    private char[] humanPassphrase = new char[]{'w', 'o', 'm', 'e', 'n', 'd', 'o', 'u', 's', 'h', 'i', 'h', 'a', 'o', 'h', 'a', 'i', 'z', 'i'};
    private byte[] salt = new byte[]{1, 5, 8, 6, 7, 9, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private PBEKeySpec myKeyspec = new PBEKeySpec(this.humanPassphrase, this.salt, 10000, 128);
    private final String CIPHERMODEPADDING = "AES/CBC/PKCS7Padding";
    private SecretKeyFactory keyfactory = null;
    private SecretKey sk = null;
    private SecretKeySpec skforAES = null;
    private byte[] iv = new byte[]{10, 1, 11, 5, 4, 15, 7, 9, 23, 3, 1, 6, 8, 12, 13, 91};
    private IvParameterSpec IV;
    private static AESEncryptor mInstance;

    public static void main(String[] args) throws Exception {
    }

    public static AESEncryptor getInstance() {
        if (mInstance == null) {
            mInstance = new AESEncryptor();
        }
        return mInstance;
    }

    private AESEncryptor() {
        try {
            this.keyfactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            this.sk = this.keyfactory.generateSecret(this.myKeyspec);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        byte[] skAsByteArray = this.sk.getEncoded();
        this.skforAES = new SecretKeySpec(skAsByteArray, "AES");
        this.IV = new IvParameterSpec(this.iv);
    }

    public String decrypt(String ciphertext_base64) throws Exception {
        byte[] contentBytes = Base64.getMimeDecoder().decode(ciphertext_base64);
        contentBytes = this.decrypt("AES/CBC/PKCS7Padding", this.skforAES, this.IV, contentBytes);
        contentBytes = AESEncryptor.unzip(contentBytes);
        return new String(contentBytes, "UTF-8");
    }

    private byte[] decrypt(String cmp, SecretKey sk, IvParameterSpec IV, byte[] ciphertext) throws Exception {
        Cipher c = Cipher.getInstance(cmp);
        c.init(2, (Key)sk, IV);
        return c.doFinal(ciphertext);
    }

    private static byte[] unzip(byte[] contentBytes) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(contentBytes);
        GZIPInputStream gzip = new GZIPInputStream(in);
        byte[] buffer = new byte[256];
        int n = 0;
        while ((n = gzip.read(buffer)) >= 0) {
            out.write(buffer, 0, n);
        }
        return out.toByteArray();
    }

    public byte[] encrypt(String content) throws Exception {
        return this.encrypt("AES/CBC/PKCS7Padding", this.skforAES, this.IV, content);
    }

    public byte[] encrypt(String cmp, SecretKey sk, IvParameterSpec IV, String msg) throws Exception {
        byte[] bytes = AESEncryptor.zip(msg.getBytes("UTF-8"));
        Cipher c = Cipher.getInstance(cmp);
        c.init(1, (Key)sk, IV);
        bytes = c.doFinal(bytes);
        return Base64.getEncoder().encode(bytes);
    }

    private static byte[] zip(byte[] contentBytes) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(contentBytes);
        gzip.close();
        return out.toByteArray();
    }
}

