from microservices import redirectios
from microservices import receiveios
import string
import random
import socket
import struct
import hashlib
import time

ip = socket.inet_ntoa(struct.pack('>I', random.randint(1, 0xffffffff)))


# md5加密
def computeMD5(message):
    m = hashlib.md5()
    m.update(message.encode(encoding='utf-8'))
    return m.hexdigest()


# md5加密
def computeMD5upper(message):
    m = hashlib.md5()
    m.update(message.encode(encoding='utf-8'))
    return m.hexdigest().upper()


def idfacode():
    ret = ''
    a = "".join(random.sample(string.ascii_letters + string.digits, 8))
    b = "".join(random.sample(string.ascii_letters + string.digits, 4))
    c = "".join(random.sample(string.ascii_letters + string.digits, 4))
    d = "".join(random.sample(string.ascii_letters + string.digits, 4))
    e = "".join(random.sample(string.ascii_letters + string.digits, 12))
    i = (a + "-" + b + "-" + c + "-" + d + "-" + e).upper()
    ret += i
    return ret


def idfvcode():
    ret = ''
    a = "".join(random.sample(string.ascii_letters + string.digits, 8))
    b = "".join(random.sample(string.ascii_letters + string.digits, 4))
    c = "".join(random.sample(string.ascii_letters + string.digits, 4))
    d = "".join(random.sample(string.ascii_letters + string.digits, 4))
    e = "".join(random.sample(string.ascii_letters + string.digits, 12))
    i = (a + "-" + b + "-" + c + "-" + d + "-" + e).upper()
    ret += i
    return ret


# ------------------------点击的取值顺序-----------------
# idfa正常值，idfv为正常值；idfa_md5正常值，idfv_md5为正常值,deviceid取idfa，deviceid md5取idfa_md5
def test_atb1():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.parms['idfv'] = v
    redirectios.parms['idfv_md5'] = computeMD5(v)
    redirectios.parms['ipv4'] = ip
    redirectios.parms[
        'ua'] = 'iOS / Chrome 34: Mozilla/5.0 (iPad; CPU OS 7_0_4 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) CriOS/34.0.1847.18 Mobile/11B554a Safari/9537.53'
    redirectios.send_request3('')
    print(i)


# idfa>ipv4
# idfa为空，idfv为正常值；idfa_md5为空，idfv_md5为正常值,deviceid取ip
def test_atb2():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = ''
    redirectios.parms['idfa_md5'] = ''
    redirectios.parms['idfv'] = v
    redirectios.parms['idfv_md5'] = computeMD5(v)
    redirectios.parms['ipv4'] = ip
    redirectios.send_request3('')
    print(i)


# ------------------------精准归因-----------------
# idfa正常值，idfv为正常值；idfa_md5正常值，idfv_md5为正常值,归因结果为idfa
def test_atb3():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    print(i)


# idfa点击为小写，iafa激活为大写，无归因
def test_atb4():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i.lower()
    redirectios.parms['idfa_md5'] = ''
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = ''
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = ''
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = ''
    receiveios.send_request()
    print(i)


# idfa点击为大写，idfa激活为小写，无归因
def test_atb5():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = ''
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = i.lower()
    receiveios.data[0]['device_info']['idfa_md5'] = ''
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i.lower()
    receiveios.data[0]['device_info']['device_id_md5'] = ''
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = ''
    receiveios.send_request()
    print(i.lower())


# 激活中的idfa_md5与点击中的idfa_md5一致，点击中idfa正常，激活中idfa为空，归因结果为idfa_md5
def test_atb6():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = ''
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = v
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfv'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    print(v)


# 激活中的idfa_md5与点击中的idfa_md5大小写不一致，点击中idfa_md5为小写，激活中idfa_md5为大写，不归因
def test_atb7():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = ''
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5upper(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = v
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfv'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    print(v)


# 激活中的idfa_md5与点击中的idfa_md5大小写不一致，点击中idfa_md5为大写，激活中idfa_md5为小写，不归因
def test_atb8():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5upper(i)
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = ''
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = v
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfv'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    print(v)
    print(computeMD5(i))


# idfa点击为小写，iafa激活为大写,idfa_md5点击有值，激活无值，实时侧添加md5加密值，归因方式为idfa_md5
def test_atb9():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i.lower()
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = ''
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = ''
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = ''
    receiveios.send_request()
    print(i)


# idfa_md5激活无值，实时侧添idfa_md5加密值
def test_atb31():
    i = idfacode()
    v = idfvcode()
    receiveios.data[0]['device_info']['idfa'] = '00000000-0000-0000-0000-000000000000'
    receiveios.data[0]['device_info']['idfa_md5'] = ''
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = v
    receiveios.data[0]['device_info']['device_id_md5'] = ''
    receiveios.data[0]['device_info']['device_id_type'] = 'idfv'
    receiveios.data[0]['device_info']['device_id_md5_type'] = ''
    receiveios.send_request()
    print(v)


# -----------------------不可用归因的设备ID无法精准归因----------------------
# 激活数据中的idfa为‘00000000-0000-0000-0000-000000000000’
# idfa_md5为空
# 点击中的idfa为‘00000000-0000-0000-0000-000000000000’
# ip不同，无法归因
def test_atb10():
    i = idfacode()
    v = idfvcode()
    ip1 = socket.inet_ntoa(struct.pack('>I', random.randint(1, 0xffffffff)))
    ip2 = socket.inet_ntoa(struct.pack('>I', random.randint(1, 0xffffffff)))
    redirectios.parms['idfa'] = '00000000-0000-0000-0000-000000000000'
    redirectios.parms['idfa_md5'] = ''
    redirectios.parms['ipv4'] = ip1
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = '00000000-0000-0000-0000-000000000000'
    receiveios.data[0]['device_info']['idfa_md5'] = ''
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = v
    receiveios.data[0]['device_info']['device_id_md5'] = ''
    receiveios.data[0]['device_info']['device_id_type'] = 'idfv'
    receiveios.data[0]['device_info']['device_id_md5_type'] = ''
    receiveios.data[0]['device_info']['ipv4'] = ip2
    receiveios.send_request()
    print(v)


# 激活数据中的idfa为全0，idfa_md5为全0 md5加密，点击中的idfa为空，无法归因
def test_atb11():
    i = idfacode()
    v = idfvcode()
    ip1 = socket.inet_ntoa(struct.pack('>I', random.randint(1, 0xffffffff)))
    ip2 = socket.inet_ntoa(struct.pack('>I', random.randint(1, 0xffffffff)))
    redirectios.parms['idfa'] = ''
    redirectios.parms['idfa_md5'] = '9f89c84a559f573636a47ff8daed0d33'
    redirectios.parms['ipv4'] = ip1
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = '00000000-0000-0000-0000-000000000000'
    receiveios.data[0]['device_info']['idfa_md5'] = '9f89c84a559f573636a47ff8daed0d33'
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = v
    receiveios.data[0]['device_info']['device_id_md5'] = ''
    receiveios.data[0]['device_info']['device_id_type'] = 'idfv'
    receiveios.data[0]['device_info']['device_id_md5_type'] = ''
    receiveios.data[0]['device_info']['ipv4'] = ip2
    receiveios.send_request()
    print(v)


# 激活数据中的idfa为全0，idfa_md5为空 ，点击中的idfa为空，idfa_md5为空，无法归因
def test_atb12():
    i = idfacode()
    v = idfvcode()
    ip1 = socket.inet_ntoa(struct.pack('>I', random.randint(1, 0xffffffff)))
    ip2 = socket.inet_ntoa(struct.pack('>I', random.randint(1, 0xffffffff)))
    redirectios.parms['idfa'] = ''
    redirectios.parms['idfa_md5'] = ''
    redirectios.parms['ipv4'] = ip1
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = '00000000-0000-0000-0000-000000000000'
    receiveios.data[0]['device_info']['idfa_md5'] = ''
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = v
    receiveios.data[0]['device_info']['device_id_md5'] = ''
    receiveios.data[0]['device_info']['device_id_type'] = 'idfv'
    receiveios.data[0]['device_info']['device_id_md5_type'] = ''
    receiveios.data[0]['device_info']['ipv4'] = ip2
    receiveios.send_request()
    print(v)


# ----------------------------------概率归因--------------------------


# 无可用于归因的设备
# ip相同，ua相同（ua为原值）
# 1.ua_click_fp_ipua_switch开启，ua_click_fp_ip_switch开启，归因结果为ip_ua
# 2.ua_click_fp_ipua_switch关闭，ua_click_fp_ip_switch开启，归因结果为ipv4
# 3.ua_click_fp_ipua_switch开启，ua_click_fp_ip_switch关闭，归因结果为ip_ua
# 4.ua_click_fp_ipua_switch关闭，ua_click_fp_ip_switch关闭，归因结果为自然量

def test_atb13():
    ua = 'Mozilla/5.0 (iPhone; CPU iPhone OS 13_5_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148'
    v = idfvcode()
    ip = socket.inet_ntoa(struct.pack('>I', random.randint(1, 0xffffffff)))
    redirectios.parms['idfa'] = '00000000-0000-0000-0000-000000000000'
    redirectios.parms['idfa_md5'] = ''
    redirectios.parms['ipv4'] = ip
    redirectios.parms['ua'] = ua
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = '00000000-0000-0000-0000-000000000000'
    receiveios.data[0]['device_info']['idfa_md5'] = ''
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = v
    receiveios.data[0]['device_info']['device_id_md5'] = ''
    receiveios.data[0]['device_info']['device_id_type'] = 'idfv'
    receiveios.data[0]['device_info']['device_id_md5_type'] = ''
    receiveios.data[0]['device_info']['ipv4'] = ip
    receiveios.data[0]['device_info']['ua'] = ua
    receiveios.send_request()
    print(v)


# 无可用于归因的设备
# ip相同，ua不同
# 1.ua_click_fp_ipua_switch开启，ua_click_fp_ip_switch开启，归因结果为ipv4
# 2.ua_click_fp_ipua_switch关闭，ua_click_fp_ip_switch开启，归因结果为ipv4
# 3.ua_click_fp_ipua_switch开启，ua_click_fp_ip_switch关闭，归因结果为自然量

def test_atb14():
    ua1 = 'Mozilla/5.0 (iPhone; CPU iPhone OS 13_5_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148'
    ua2 = 'Mozilla/5.0 (iPhone; CPU iPhone OS 13_6_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148'
    v = idfvcode()
    ip = socket.inet_ntoa(struct.pack('>I', random.randint(1, 0xffffffff)))
    redirectios.parms['idfa'] = '00000000-0000-0000-0000-000000000000'
    redirectios.parms['idfa_md5'] = ''
    redirectios.parms['ipv4'] = ip
    redirectios.parms['ua'] = ua1
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = '00000000-0000-0000-0000-000000000000'
    receiveios.data[0]['device_info']['idfa_md5'] = ''
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = v
    receiveios.data[0]['device_info']['device_id_md5'] = ''
    receiveios.data[0]['device_info']['device_id_type'] = 'idfv'
    receiveios.data[0]['device_info']['device_id_md5_type'] = ''
    receiveios.data[0]['device_info']['ipv4'] = ip
    receiveios.data[0]['device_info']['ua'] = ua2
    receiveios.send_request()
    print(v)


# 无可用于归因的设备
# ip相同，ua相同（点击中的ua为编码后的）
# 1.ua_click_fp_ipua_switch开启，ua_click_fp_ip_switch开启，归因结果为ip_ua
def test_atb15():
    ua2 = 'Mozilla/5.0 (iPhone; CPU iPhone OS 13_5_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148'
    ua1 = 'Mozilla%2F5.0%20(iPhone%3B%20CPU%20iPhone%20OS%2013_5_1%20like%20Mac%20OS%20X)%20AppleWebKit%2F605.1.15%20(KHTML%2C%20like%20Gecko)%20Mobile%2F15E148'
    v = idfvcode()
    ip = socket.inet_ntoa(struct.pack('>I', random.randint(1, 0xffffffff)))
    redirectios.parms['idfa'] = '00000000-0000-0000-0000-000000000000'
    redirectios.parms['idfa_md5'] = ''
    redirectios.parms['ipv4'] = ip
    redirectios.parms['ua'] = ua1
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = '00000000-0000-0000-0000-000000000000'
    receiveios.data[0]['device_info']['idfa_md5'] = ''
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = v
    receiveios.data[0]['device_info']['device_id_md5'] = ''
    receiveios.data[0]['device_info']['device_id_type'] = 'idfv'
    receiveios.data[0]['device_info']['device_id_md5_type'] = ''
    receiveios.data[0]['device_info']['ipv4'] = ip
    receiveios.data[0]['device_info']['ua'] = ua2
    receiveios.send_request()
    print(v)


# 无可用于归因的设备
# ip相同，ua相同（激活中的ua为编码后的）
# 1.ua_click_fp_ipua_switch开启，ua_click_fp_ip_switch开启，归因结果为ip_ua
def test_atb16():
    ua2 = 'Mozilla/5.0 (iPhone; CPU iPhone OS 13_5_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148'
    ua1 = 'Mozilla%2F5.0%20(iPhone%3B%20CPU%20iPhone%20OS%2013_5_1%20like%20Mac%20OS%20X)%20AppleWebKit%2F605.1.15%20(KHTML%2C%20like%20Gecko)%20Mobile%2F15E148'
    v = idfvcode()
    ip = socket.inet_ntoa(struct.pack('>I', random.randint(1, 0xffffffff)))
    redirectios.parms['idfa'] = '00000000-0000-0000-0000-000000000000'
    redirectios.parms['idfa_md5'] = ''
    redirectios.parms['ipv4'] = ip
    redirectios.parms['ua'] = ua2
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = '00000000-0000-0000-0000-000000000000'
    receiveios.data[0]['device_info']['idfa_md5'] = ''
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = v
    receiveios.data[0]['device_info']['device_id_md5'] = ''
    receiveios.data[0]['device_info']['device_id_type'] = 'idfv'
    receiveios.data[0]['device_info']['device_id_md5_type'] = ''
    receiveios.data[0]['device_info']['ipv4'] = ip
    receiveios.data[0]['device_info']['ua'] = ua1
    receiveios.send_request()
    print(v)


# 无可用于归因的设备
# ip不同，ua相同（激活中的ua为编码后的）
# 1.ua_click_fp_ipua_switch开启，ua_click_fp_ip_switch开启，归因结果自然量
def test_atb17():
    ua2 = 'Mozilla/5.0 (iPhone; CPU iPhone OS 13_5_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148'
    ua1 = 'Mozilla%2F5.0%20(iPhone%3B%20CPU%20iPhone%20OS%2013_5_1%20like%20Mac%20OS%20X)%20AppleWebKit%2F605.1.15%20(KHTML%2C%20like%20Gecko)%20Mobile%2F15E148'
    v = idfvcode()
    ip1 = socket.inet_ntoa(struct.pack('>I', random.randint(1, 0xffffffff)))
    ip2 = socket.inet_ntoa(struct.pack('>I', random.randint(1, 0xffffffff)))
    redirectios.parms['idfa'] = '00000000-0000-0000-0000-000000000000'
    redirectios.parms['idfa_md5'] = ''
    redirectios.parms['ipv4'] = ip1
    redirectios.parms['ua'] = ua2
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = '00000000-0000-0000-0000-000000000000'
    receiveios.data[0]['device_info']['idfa_md5'] = ''
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = v
    receiveios.data[0]['device_info']['device_id_md5'] = ''
    receiveios.data[0]['device_info']['device_id_type'] = 'idfv'
    receiveios.data[0]['device_info']['device_id_md5_type'] = ''
    receiveios.data[0]['device_info']['ipv4'] = ip2
    receiveios.data[0]['device_info']['ua'] = ua1
    receiveios.send_request()
    print(v)


# -----------------last-click规则验证------------------
# 发送一次点击数据，五分钟后再次发送点击数据，归因到的为第二次的点击
def test_atb18():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(300)
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('mURv22a', '')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    print(i)


# ----------------------------------ip取值规则-激活----------------------------------
# integration_type为sdk，根据HTTP Header中的IP取值（SDK集成时，报文中也不会有ip传参）
def test_atb19():
    i = idfacode()
    v = idfvcode()
    receiveios.data[0]['collector_info']['integration_type'] = 'sdk'
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    print(i)


# integration_type为s2s，根据传参中的ipv4进行IP取值
def test_atb20():
    i = idfacode()
    v = idfvcode()
    receiveios.data[0]['collector_info']['integration_type'] = 's2s'
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['device_info']['ipv4'] = ip

    receiveios.send_request2()
    print(i)


# ---------------------------激活有效期逻辑---------------------------
# 在激活有效期（104秒）之外：归因上之后，110秒后再次发送点击激活数据，查询归因接口，可再次归因
def test_atb21():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    time.sleep(110)
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    print(i)


# 在激活有效期（104秒）之内：归因上之后，20秒后再次发送激活数据，查询归因接口，为第一次归因结果
def test_atb22():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    time.sleep(20)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    print(i)


# 在激活有效期（104秒）之外：归因上之后，200秒后再次发送激活数据，查询归因接口，为自然量
def test_atb23():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    time.sleep(200)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    print(i)


# ------------------------------------新客获取点击精准归因回溯窗口期------------------------------------
# 点击精准归因回溯窗口期设置为2分钟
# 发送点击，1分钟之后发送激活，可归因上
def test_atb24():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(60)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    print(i)


# 点击精准归因回溯窗口期设置为2分钟
# 发送点击，3分钟之后发送激活，无法归因，为自然量
def test_atb25():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(180)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    print(i)


# ------------------------------------新客获取点击IPUA概率归因回溯窗口期------------------------------------
# IPUA概率归因回溯窗口期设置30秒
# 发送点击，20秒之后发送激活，可归因上
def test_atb26():
    ua = 'Mozilla/5.0 (iPhone; CPU iPhone OS 13_5_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148'
    v = idfvcode()
    ip = socket.inet_ntoa(struct.pack('>I', random.randint(1, 0xffffffff)))
    redirectios.parms['idfa'] = '00000000-0000-0000-0000-000000000000'
    redirectios.parms['idfa_md5'] = ''
    redirectios.parms['ipv4'] = ip
    redirectios.parms['ua'] = ua
    redirectios.send_request3('')
    time.sleep(20)
    receiveios.data[0]['device_info']['idfa'] = '00000000-0000-0000-0000-000000000000'
    receiveios.data[0]['device_info']['idfa_md5'] = ''
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = v
    receiveios.data[0]['device_info']['device_id_md5'] = ''
    receiveios.data[0]['device_info']['device_id_type'] = 'idfv'
    receiveios.data[0]['device_info']['device_id_md5_type'] = ''
    receiveios.data[0]['device_info']['ipv4'] = ip
    receiveios.data[0]['device_info']['ua'] = ua
    receiveios.send_request()
    print(v)


# IPUA概率归因回溯窗口期设置30秒
# 发送点击，35秒之后发送激活，无法归因，为自然量
def test_atb27():
    ua = 'Mozilla/5.0 (iPhone; CPU iPhone OS 13_5_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148'
    v = idfvcode()
    ip = socket.inet_ntoa(struct.pack('>I', random.randint(1, 0xffffffff)))
    redirectios.parms['idfa'] = '00000000-0000-0000-0000-000000000000'
    redirectios.parms['idfa_md5'] = ''
    redirectios.parms['ipv4'] = ip
    redirectios.parms['ua'] = ua
    redirectios.send_request3('')
    time.sleep(35)
    receiveios.data[0]['device_info']['idfa'] = '00000000-0000-0000-0000-000000000000'
    receiveios.data[0]['device_info']['idfa_md5'] = ''
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = v
    receiveios.data[0]['device_info']['device_id_md5'] = ''
    receiveios.data[0]['device_info']['device_id_type'] = 'idfv'
    receiveios.data[0]['device_info']['device_id_md5_type'] = ''
    receiveios.data[0]['device_info']['ipv4'] = ip
    receiveios.data[0]['device_info']['ua'] = ua
    receiveios.send_request()
    print(v)


# ------------------------------------新客获取点击IP概率归因回溯窗口期------------------------------------
# IPUA概率归因回溯窗口期设置8秒
# 发送点击，3秒之后发送激活，可归因上
def test_atb28():
    ua1 = 'Mozilla/5.0 (iPhone; CPU iPhone OS 13_6_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148'
    ua2 = 'Mozilla/5.0 (iPhone; CPU iPhone OS 13_5_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148'
    v = idfvcode()
    ip = socket.inet_ntoa(struct.pack('>I', random.randint(1, 0xffffffff)))
    redirectios.parms['idfa'] = '00000000-0000-0000-0000-000000000000'
    redirectios.parms['idfa_md5'] = ''
    redirectios.parms['ipv4'] = ip
    redirectios.parms['ua'] = ua1
    redirectios.send_request3('')
    time.sleep(3)
    receiveios.data[0]['device_info']['idfa'] = '00000000-0000-0000-0000-000000000000'
    receiveios.data[0]['device_info']['idfa_md5'] = ''
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = v
    receiveios.data[0]['device_info']['device_id_md5'] = ''
    receiveios.data[0]['device_info']['device_id_type'] = 'idfv'
    receiveios.data[0]['device_info']['device_id_md5_type'] = ''
    receiveios.data[0]['device_info']['ipv4'] = ip
    receiveios.data[0]['device_info']['ua'] = ua2
    receiveios.send_request()
    print(v)


# IPUA概率归因回溯窗口期设置8秒
# 发送点击，10秒之后发送激活，无法归因，为自然量
def test_atb29():
    ua1 = 'Mozilla/5.0 (iPhone; CPU iPhone OS 13_6_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148'
    ua2 = 'Mozilla/5.0 (iPhone; CPU iPhone OS 13_5_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148'
    v = idfvcode()
    ip = socket.inet_ntoa(struct.pack('>I', random.randint(1, 0xffffffff)))
    redirectios.parms['idfa'] = '00000000-0000-0000-0000-000000000000'
    redirectios.parms['idfa_md5'] = ''
    redirectios.parms['ipv4'] = ip
    redirectios.parms['ua'] = ua1
    redirectios.send_request3('')
    time.sleep(10)
    receiveios.data[0]['device_info']['idfa'] = '00000000-0000-0000-0000-000000000000'
    receiveios.data[0]['device_info']['idfa_md5'] = ''
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = v
    receiveios.data[0]['device_info']['device_id_md5'] = ''
    receiveios.data[0]['device_info']['device_id_type'] = 'idfv'
    receiveios.data[0]['device_info']['device_id_md5_type'] = ''
    receiveios.data[0]['device_info']['ipv4'] = ip
    receiveios.data[0]['device_info']['ua'] = ua2
    receiveios.send_request()
    print(v)


# -------------------------------后续事件归因---------------------------------
# 目前无法验证后续事件是否匹配到了激活，等测试回调时一起测试该功能
# device_id相同-可通过device_id进行关联
def test_atb30():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['account_id'] = '456'
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    time.sleep(3)
    newList = ['startup', 'register', 'login', 'order', 'purchase',
               'adimpression', 'adclick']
    for event in newList:
        receiveios.data[0]['device_info']['idfa'] = i
        receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
        receiveios.data[0]['device_info']['idfv'] = v
        receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
        receiveios.data[0]['device_info']['device_id'] = i
        receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
        receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
        receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
        receiveios.data[0]["event_info"]['event_name'] = event
        receiveios.data[0]["event_info"]['event_type'] = 'preset'
        receiveios.send_request()
    print(i)


# 归因到渠道的startup
def test_atb45():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    time.sleep(3)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]["event_info"]['event_name'] = 'startup'
    receiveios.data[0]["event_info"]['event_type'] = 'preset'
    receiveios.send_request()
    print(i)


# 归因到渠道的register
def test_atb32():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    time.sleep(3)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]["event_info"]['event_name'] = 'register'
    receiveios.data[0]["event_info"]['event_type'] = 'preset'
    receiveios.send_request()
    print(i)


# 归因到渠道的login
def test_atb33():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    time.sleep(3)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]["event_info"]['event_name'] = 'login'
    receiveios.data[0]["event_info"]['event_type'] = 'preset'
    receiveios.send_request()
    print(i)


# 归因到渠道的order
def test_atb34():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    time.sleep(3)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]["event_info"]['event_name'] = 'order'
    receiveios.data[0]["event_info"]['event_type'] = 'preset'
    receiveios.send_request()
    print(i)


# 归因到渠道的purchase
def test_atb35():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(5)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    time.sleep(3)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]["event_info"]['event_name'] = 'purchase'
    receiveios.data[0]["event_info"]['event_type'] = 'preset'
    receiveios.send_request()
    print(i)


# 归因到渠道的adimpression
def test_atb36():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    time.sleep(3)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]["event_info"]['event_name'] = 'adimpression'
    receiveios.data[0]["event_info"]['event_type'] = 'preset'
    receiveios.send_request()
    print(i)


# 归因到渠道的adclick
def test_atb37():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    time.sleep(3)
    # newList = ['startup', 'register', 'login', 'order', 'purchase',
    #            'adimpression', 'adclick']
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]["event_info"]['event_name'] = 'adclick'
    receiveios.data[0]["event_info"]['event_type'] = 'preset'
    receiveios.send_request()
    print(i)


# 未配置回调的apkkey
def test_atb38():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['application_info']['appkey'] = 'b3beb14b8de6cb5b64650ff8e5983c44'
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    time.sleep(3)
    newList = ['startup', 'register', 'login', 'order', 'purchase',
               'adimpression', 'adclick']
    for event in newList:
        receiveios.data[0]['application_info']['appkey'] = 'b3beb14b8de6cb5b64650ff8e5983c44'
        receiveios.data[0]['device_info']['idfa'] = i
        receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
        receiveios.data[0]['device_info']['idfv'] = v
        receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
        receiveios.data[0]['device_info']['device_id'] = i
        receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
        receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
        receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
        receiveios.data[0]["event_info"]['event_name'] = event
        receiveios.data[0]["event_info"]['event_type'] = 'preset'
        receiveios.send_request()
    print(i)


# 归因到渠道的startup，点击中的callback_url为空
def test_atb39():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['callback_url'] = ''
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    time.sleep(3)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]["event_info"]['event_name'] = 'startup'
    receiveios.data[0]["event_info"]['event_type'] = 'preset'
    receiveios.send_request()
    print(i)


# 归因到渠道的startup，点击中的callback_url为空
def test_atb40():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['callback_url'] = 'https%3A%2F%2Fwww.baidu.com%2F%3Ftn%3D98010089_dg%26ch%3D16%2F'
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    time.sleep(3)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]["event_info"]['event_name'] = 'startup'
    receiveios.data[0]["event_info"]['event_type'] = 'preset'
    receiveios.send_request()
    print(i)


# 归因到渠道的自定义事件
def test_atb42():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(8)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    time.sleep(3)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]["event_info"]['event_name'] = 'custom_event_1'
    receiveios.data[0]["event_info"]['event_type'] = 'custom'
    receiveios.send_request()
    print(i)


# 第一次点击的idfa与激活相同，第二次点击ip与激活相同，归因到第一次点击
def test_atb43():
    ip1 = socket.inet_ntoa(struct.pack('>I', random.randint(1, 0xffffffff)))
    ip2 = socket.inet_ntoa(struct.pack('>I', random.randint(1, 0xffffffff)))
    i2 = idfacode()
    i = idfacode()
    v = idfvcode()
    redirectios.parms['ipv4'] = ip1
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(100)
    redirectios.parms['ipv4'] = ip2
    redirectios.parms['idfa'] = i2
    redirectios.parms['idfa_md5'] = computeMD5(i2)
    redirectios.send_request3('')
    time.sleep(3)
    receiveios.data[0]['device_info']['ipv4'] = ip2
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    print(i)



#归因到渠道的激活
def test_atb44():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(5)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.send_request()
    print(i)




# -----------------------asa逻辑测试--------------------

#数据为测试数据，不是asa激活，走正常归因逻辑
def test_asa1():
    i = idfacode()
    v = idfvcode()
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['asa_info']['iad_info']['iad-attribution'] = 'true'
    receiveios.data[0]['asa_info']['iad_info']['iad-org-id'] = '1234567890'
    receiveios.data[0]['asa_info']['adservices_info']['token'] = ''
    receiveios.send_request()
    print(i)



#数据不为测试数据，走asa归因
def test_asa2():
    i = idfacode()
    # i = '83XGICNT-KNGI-L1EK-EC4N-DZTNFLKNO1ME'
    v = idfvcode()
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['asa_info']['iad_info']['iad-attribution'] = 'true'
    receiveios.data[0]['asa_info']['iad_info']['iad-org-id'] = '12345678901'
    receiveios.data[0]['asa_info']['adservices_info']['token'] = ''
    receiveios.send_request()
    print(i)



# iad归因为空且tkoen为空，走正常归因逻辑
def test_asa3():
    i = idfacode()
    v = idfvcode()
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['asa_info']['iad_info']['iad-attribution'] = ''
    receiveios.data[0]['asa_info']['iad_info']['iad-org-id'] = '12345678901'
    receiveios.data[0]['asa_info']['adservices_info']['token'] = ''
    receiveios.send_request()
    print(i)


#iad-org-id为空，iad-attribution为true
def test_asa4():
    i = idfacode()
    v = idfvcode()
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['asa_info']['iad_info']['iad-attribution'] = 'true'
    receiveios.data[0]['asa_info']['iad_info']['iad-org-id'] = ''
    receiveios.data[0]['asa_info']['adservices_info']['token'] = ''
    receiveios.send_request()
    print(i)




# iad归因为false且tkoen为空，走正常归因逻辑
def test_asa5():
    i = idfacode()
    v = idfvcode()
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['asa_info']['iad_info']['iad-attribution'] = 'false'
    receiveios.data[0]['asa_info']['iad_info']['iad-org-id'] = '12345678901'
    receiveios.data[0]['asa_info']['adservices_info']['token'] = ''
    receiveios.send_request()
    print(i)



# 不传iad-attribution和token字段，走正常归因逻辑
def test_asa6():
    i = idfacode()
    v = idfvcode()
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['asa_info']['iad_info']['iad-attribution'] = ''
    receiveios.data[0]['asa_info']['iad_info']['iad-org-id'] = '12345678901'
    receiveios.data[0]['asa_info']['adservices_info']['token'] = ''
    receiveios.send_request()
    print(i)




#iad-attribution为大写TRUE，iad-org-id非测试数据，走正常归因
def test_asa7():
    i = idfacode()
    v = idfvcode()
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['asa_info']['iad_info']['iad-attribution'] = 'TRUE'
    receiveios.data[0]['asa_info']['iad_info']['iad-org-id'] = '423323'
    receiveios.data[0]['asa_info']['adservices_info']['token'] = ''
    receiveios.send_request()
    print(i)

# iad归因为空，tkoen不为空但是token是错误的，走正常归因逻辑
def test_asa8():
    i = idfacode()
    v = idfvcode()
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['asa_info']['iad_info']['iad-attribution'] = 'true'
    receiveios.data[0]['asa_info']['iad_info']['iad-org-id'] = ''
    receiveios.data[0]['asa_info']['adservices_info']['token'] = 'kv1FiGQJnzzZdnQpDq4g3fnXT4z3Q7tBH/0j43lYIJoT25QzNbez/gIrU4fQ/EFrpw3xo7QNTKFjhRv9WqTYISBmOYVgM1Qf6QAAAVADAAAAwgAAAIAy/g+7t1Q14p7B88Q/IEQRPm3fRmGIEQYjqoyPcmXCbmfkWhFYlI7tGalXnOiaVTG+42C4rCPK4aGTVTGvVC51BpDbaYEmzirAUa7Zx1250iaO6rVqnR+70dQ/4rqUr9Y3xIeYFxZTzlO5balJR8p6tFH9JebQN5cnS6iYvW2HFwAAABtCe4TJZstJGHhzx1mZwoH/DshcQUzoEw3CWsQAAACfAQq+ciM0JRGNd8IRMms27Jv9NoGLAAAAhgIG6Ob8mQt05KAOunoU2GRA8WKLioF8Znqe2X5Wfy8sEzg4zM30ZKQIvcAXPZPcIAaWP4pbi2ud87ABIW4Z8Sa8QnGSqMYbZ99Z3mYFHP81vVEDEglXyL8/jvFf49mZKa9HE4bIKu7KzGQ9BiAMxFujG9LPMKEBVnS5vai3CqdjZ0e5SUfYAAAAAAABBEYNAgA='
    receiveios.send_request()
    print(i)


# iad归因为空，tkoen不为空且token正确-返回ads归因为false(非测试数据)
def test_asa9():
    i = idfacode()
    v = idfvcode()
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['asa_info']['iad_info']['iad-attribution'] = ''
    receiveios.data[0]['asa_info']['iad_info']['iad-org-id'] = '1234321'
    receiveios.data[0]['asa_info']['adservices_info']['token'] = '/uCODngkP2bfsOpiWj3Q4JWvx6dmJEiTR/FfpY0xMuouweoKUWwn+ALDeMZ2+5ihfKGoxyEXFVzn1ch1xu2kk7R4xIWng4SUIQAAAVADAAAAnwAAAIBIN+L3PPnC3mZ+jIeIf+hB/rhMn82ER6CJwIwYJxU0B2O4Q/1KXJQGzD+QJzL3J+LNAyACyT2aUWVhhbGKZfvCLJzr3vAMObtbIUC9H3dWnBfgVB8iYfnjo044dXj91mgleA1HYYZiIaolUKH0jnWx/oGnYB8u0kYihT40rUbZWwAAABzDaguAs337EhcpBDlig2UD+5cFxj6wU9gUPJ4/AAAAnwHxuacYGJWMa2ddMRsdWjhxq0uXmQAAAIYJBPMT42aNI8GHrOL3MMHllrlikCUNPxATYRC+isFRKcGP8lpJViUEAt1Mqf2ttO/z9rNHHs8eULJ7FddDAV8CiTD/yB42HjQaJz+t6pOpBGHKuvn6BIfanN7rC0+ZiANrBaRFVosBLwrLUiSsRqsX3YmEs/TWLbsiKeeoLU6kwAlJtNd7fwAAAAABBEYXAAA='
    receiveios.send_request()
    print(i)


#先正常自然量激活，然后在激活有效期内发送asa激活，归因结果覆盖为asa激活
def test_asa10():
    i = idfacode()
    v = idfvcode()
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['asa_info']['iad_info']['iad-attribution'] = 'false'
    receiveios.data[0]['asa_info']['iad_info']['iad-org-id'] = '1234567890'
    receiveios.data[0]['asa_info']['adservices_info']['token'] = ''
    receiveios.send_request()
    time.sleep(5)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['asa_info']['iad_info']['iad-attribution'] = 'true'
    receiveios.data[0]['asa_info']['iad_info']['iad-org-id'] = '12345678901'
    receiveios.data[0]['asa_info']['adservices_info']['token'] = ''
    receiveios.send_request()
    print(i)



##数据为测试数据，不是asa激活，走正常归因逻辑（归因到渠道）
def test_asa11():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(5)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['asa_info']['iad_info']['iad-attribution'] = 'true'
    receiveios.data[0]['asa_info']['iad_info']['iad-org-id'] = '1234567890'
    receiveios.data[0]['asa_info']['adservices_info']['token'] = ''
    receiveios.send_request()
    print(i)




#数据不为测试数据（有该设备的点击），走asa归因
def test_asa12():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(5)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['asa_info']['iad_info']['iad-attribution'] = 'true'
    receiveios.data[0]['asa_info']['iad_info']['iad-org-id'] = '12345678901'
    receiveios.data[0]['asa_info']['adservices_info']['token'] = ''
    receiveios.send_request()
    print(i)


# iad归因为空，tkoen不为空且token正确-返回ads归因为false(非测试数据)-走正常归因
# 该设备id存在巨量引擎渠道的点击,归因到了巨量引擎渠道
def test_asa13():
    i = idfacode()
    v = idfvcode()
    redirectios.parms['idfa'] = i
    redirectios.parms['idfa_md5'] = computeMD5(i)
    redirectios.send_request3('')
    time.sleep(5)
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['asa_info']['iad_info']['iad-attribution'] = ''
    receiveios.data[0]['asa_info']['iad_info']['iad-org-id'] = '1234321'
    receiveios.data[0]['asa_info']['adservices_info']['token'] = 'X8RCyiSWbRqrW4Dkgj1PTfAcONQm9pNtegs4Gieca0Mv1Re9V4DDewKoLcbS+Qob7jdZksxyzHkSMA/YW0s0Q96+Q0J73i2RYgAAAVADAAAA5gAAAIAc9XYhkA0EIyeqj7ZEsksLNiqaUTJN8YMn5Iy9EEBJROco1YJDXnxG2obH2awUBC3onAuDqJ/fRp+T8UkFR099mA76p6ZmZ4f0284XnP1ZeeZ5wjre5sawVJ88sG51VdPXeQKxclHn0viLv8U4jtKAbbaueaPx6NjTag1H3PJsvQAAABo7Bo75BPoGIxgOT0Bvp7e5H+qXhYnqHc8SAQAAAJ8Bc3bS2UKQeel68MTBrSJ+Rx7Zn6cAAACGAAIPO3te8WGQZzjpUj1nXRxDYorJNoqYJ6zSZobXAFhkbqKEYzjCOTfDXENyhvyaf0thWkcoyd3KdxuqIgdFmSEW44M9aLzWszyCpSDddyP7m1TIAVl0rrzz3jjSIyvw6VSgFmUN2zRRTLL7JiE+05pLm3wMA/SPZBQ11AkdnuhXHbTyx+QAAAAAAAABBEYXAAA='
    receiveios.send_request()
    print(i)



#数据不为测试数据，走asa归因；不传iad-click-date，归因结果的attribution_ttit为-1
def test_asa14():
    i = idfacode()
    v = idfvcode()
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['asa_info']['iad_info']['iad-attribution'] = 'true'
    receiveios.data[0]['asa_info']['iad_info']['iad-org-id'] = '12345678901'
    receiveios.data[0]['asa_info']['iad_info']['iad-click-date'] = ''
    receiveios.data[0]['asa_info']['adservices_info']['token'] = ''
    receiveios.send_request()
    print(i)


#数据不为测试数据，走asa归因；传iad-click-date且格式正确，归因结果的 attribution_ttit 为 install_time 减去 iad-click-date
def test_asa15():
    i = idfacode()
    v = idfvcode()
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['asa_info']['iad_info']['iad-attribution'] = 'true'
    receiveios.data[0]['asa_info']['iad_info']['iad-org-id'] = '12345678901'
    receiveios.data[0]['asa_info']['iad_info']['iad-click-date'] = '2022-5-30T18:25:00Z'
    receiveios.data[0]['asa_info']['adservices_info']['token'] = ''
    receiveios.send_request()
    print(i)




#数据不为测试数据，走asa归因；传iad-click-date但格式错误，归因结果的 attribution_ttit 为 install_time 减去 iad-click-date
def test_asa16():
    i = idfacode()
    v = idfvcode()
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['asa_info']['iad_info']['iad-attribution'] = 'true'
    receiveios.data[0]['asa_info']['iad_info']['iad-org-id'] = '12345678901'
    receiveios.data[0]['asa_info']['iad_info']['iad-click-date'] = '1653893249158'
    receiveios.data[0]['asa_info']['adservices_info']['token'] = ''
    receiveios.send_request()
    print(i)



#数据不为测试数据，走asa归因；传iad-click-date但格式错误，归因结果的 attribution_ttit 为 install_time 减去 iad-click-date
def test_asa17():
    i = idfacode()
    v = idfvcode()
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['asa_info']['iad_info']['iad-attribution'] = 'true'
    receiveios.data[0]['asa_info']['iad_info']['iad-org-id'] = '12345678901'
    receiveios.data[0]['asa_info']['iad_info']['iad-click-date'] = '2022-05-30 14:47:29'
    receiveios.data[0]['asa_info']['adservices_info']['token'] = ''
    receiveios.send_request()
    print(i)


# 1.iad-attribution=''
# 2.token为正常tkoen（ads归因为true）
# 3.苹果接口返回的orgId不为1234567890
# 归因结果为asa激活
def test_asa18():
    i = idfacode()
    v = idfvcode()
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['asa_info']['iad_info']['iad-attribution'] = ''
    receiveios.data[0]['asa_info']['iad_info']['iad-org-id'] = '756347876534'
    receiveios.data[0]['asa_info']['adservices_info']['token'] = 'j/th0yzvyrYAe5Il7bFin170v3jZw91+YdBx3zazPI8uPGQoyre/LQLYs5Opi8JyzcTG+ObMXdT3p/fTP0IXejwjAF21LpFEtAAAAVADAAAA7AAAAIAKPGDN9WBW3hOsgYWMQGGTvq95ypr3bd/1Hnb2iQajqLn/OxLDgNoNFJQ8EsR47Sh3ZWKaEbllNAd/H+LGeIdURRo6dP1diLjU+InPE2aQLbNi89KEqs3cucsftUtFtiRwEDurXTpm3fgfNVybUzfYCti5ym3AccuNOcYGSl2amQAAABqGOYksqrQzqzrcu4qfa+XA/rLksbu1gxtV8gAAAJ8BeKiMBfLYzFJ3qz7nwST5d9JIiZ4AAACGCQjiP9YpMcnDlOZJso/3K3R3Yo8qJArYSqS+c8fjbsSMYbQPSwDfTWjORqw2fdsAu6I+CFFI8s7ASo0x3xYpXH2lcqc4TcCIpyjd6uld1tQprqmAWTQO9tZPU/H6uvsnP3G+WsGgxTMsMbziFmfTmUeVxiXfuYC0f2iFmOZMu9fhUHEecXkAAAAAAAABBEULAAA='
    receiveios.send_request()
    print(i)



# 1.iad-attribution=''
# 2.token为正常tkoen（ads归因为true）
# 3.iad-org-id为1234567890
# 归因结果自然量激活
def test_asa19():
    i = idfacode()
    v = idfvcode()
    receiveios.data[0]['device_info']['idfa'] = i
    receiveios.data[0]['device_info']['idfa_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['idfv'] = v
    receiveios.data[0]['device_info']['idfv_md5'] = computeMD5(v)
    receiveios.data[0]['device_info']['device_id'] = i
    receiveios.data[0]['device_info']['device_id_md5'] = computeMD5(i)
    receiveios.data[0]['device_info']['device_id_type'] = 'idfa'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['device_info']['device_id_md5_type'] = 'idfa_md5'
    receiveios.data[0]['asa_info']['iad_info']['iad-attribution'] = ''
    receiveios.data[0]['asa_info']['iad_info']['iad-org-id'] = '1234567890'
    receiveios.data[0]['asa_info']['adservices_info']['token'] = 'dIfXgKK4xWpsSZso/fXBRHWgqGOWoxyPogHyfLAgrFoAI75QzuDJegKX7jEZJAwjTAhZOtyYZQZ7/Gc+18uQNebfjEePRThBygAAAVADAAAAiQAAAIBpXlw+eqV6tFOGOmCG/777IqdLFF4sf+58OQXLlKcCqrVUhT2t3fJOqOOApSpjDHWBwYPnFHRGQNY+Jnf75m0OCxRH7dvaN/Y1qcP7GCBo5/0UJFyTbw/I1E6InKCVU5sFWCzB48TPejHM8YNwYdrP9k43E2nIyNzkvyFLhY9LugAAABlyvfrbh9dLtdGGgvYj2AwaXTbFLxNgWVP3AAAAnwFtHDm1Hyztnnv+FTFXV/KUe8VGPwAAAIYFAkbPuDxDgEPtHqLeVUlyfQlilDzKxKWf+sqhTpNJd4+xaVVI6mEIql21tRqO6bpAraKkhga2gb09AOSWboketDBrbM7a5LSsc7LnAQD97XSIfjXQLDgOv0nFyXEHatlciHTpjAYJGzreNCFGAWfKZQUkQ6P134ygBcScmmu5KTQtDYqkDgAAAAAAAAABBEYXAAA='
    receiveios.send_request()
    print(i)