parms = {
    # 触点传参时间。is_s2s=1时必传，0时选传。不同渠道有可能传多种格式，详见需求。限制32位字符内。短链传参。
    'ts': '2122132121',
    # 集成方式。is_s2s=1为服务器上报触点，0为客户端上报触点。0或1时有不同的参数非空校验，详见需求。固定为0或1。都必传
    'is_s2s': '1',
    # 设备型号。限制64字符内。都选传。短链传参。
    'model': '小米',
    # 用户公网IP v4版本。限制15字符内。is_s2s=1时都必传，0时都选传，0时优先取传参IP，未传参或传参报错时，取http header中的ip作为ipv4的值
    'ipv4': '1.1.1.1',
    # 用户公网IP v6版本。限制128字符内。都选传
    'ipv6': '1.1.1.1',
    # 用户代理信息。限制512字符内。is_s2s=1时都必传，0时都选传，0时优先取传参UA，未传参或报错时，取http header中的user agent作为ua的值
    'ua': 'Mozilla/5.0 (Linux; U; Android 7.0; zh-cn; Nexus 5X Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko)Version/4.0 Chrome/37.0.0.0 MQQBrowser/7.3 Mobile Safari/537.36',
    # 监测短链id。固定7位。
    # 'turl_id': '3r5K1h9',
    # 全部url参数。
    # 'tkul_string': 'xxx',
    # 触点类型。固定为click。都必传
    'touchpoint_type': 'click',
    # 归因类型。固定为ua（user acquirement新客获取）
    'attribution_type': 'ua',
    # 广告账户id。限制64字符内。都选传
    'account_id': '',
    # 广告组id。限制64字符内。都选传
    'adgroup_id': '',
    # 广告组名称。限制256字符内。都选传
    'adgroup_name': '',
    # 广告计划id。限制64字符内。都选传
    'adplan_id': '',
    # 广告计划名称。限制256字符内。都选传
    'adplan_name': '',
    # 广告创意id。限制128字符内。都选传
    'adcreative_id': '',
    # 广告创意名称。限制256字符内。都选传
    'adcreative_name': '',
    # 创意类型（例如大图、小图、视频等）。限制16字符内。都选传
    'adcreative_type': '',
    # 流量媒体id（例如巨量的今日头条、穿山甲、抖音等）。限制32字符内。都选传
    'site_id': '',
    # 流量媒体名称（例如巨量的今日头条、穿山甲、抖音等）。限制128字符内。都选传
    'site_name': '',
    # 广告类型（例如开屏、信息流、搜索等）。限制32字符内。都选传。
    'ad_type': '',
    # 广告位id。限制64字符内。都选传
    'placement_id': '',
    # 转化id。限制64字符内。都选传
    'conversion_id': '',
    # 广告点击id。限制64字符内。都选传
    'click_id': '',
    # 广告展示id。限制64字符内。都选传
    'impression_id': '',
    # 广告请求id。限制64字符内。都选传
    'request_id': '',
    # 渠道回调id。限制256字符。都选传
    'callback_id': 'EJiw267wvfQCGKf2g74ZIPD89-vIATAMOAFCIjIwMTkxMTI3MTQxMTEzMDEwMDI2MDc3MjE1MTUwNTczNTBIAQ==',
    # 渠道回调地址。限制256字符。都选传
    'callback_url': 'http%3A%2F%2Ftracking.e.qq.com%2Fconv%3Fcb%3DMTIzYWJjNDU2ZGVm%26conv_id%3D12345678',
    # 自定触点参数集合。都选传。
    'custom_params_1': ''
}



parms_ios = {
    # 操作系统。限制16字符内。都选传。短链传参。暂不与app_platform互相做校验。
    'os': 'ios',
    # iOS IDFA原值。固定为36字符
    "idfa": "3DEA635F-B24F-434B-833F-4ED028FEAEEF",
    "idfa_md5": "8e488a40a17aed2f6752f51382a4eafc",
    "idfv": "3DEA635F-B24F-434B-833F-4ED028FEAEEF",
    "idfv_md5": "8e488a40a17aed2f6752f51382a4eafc",
}


parms_android = {
    'os': 'android',
    # Android OAID原值。限制512字符内。Android选传，app_platform=ios时报错
    'oaid': '3DEA635F-B24F-434B-833F-4ED028FEAEEF',
    # Android OAID原值MD5后转小写。固定为32字符。Android选传，app_platform=ios时报错
    'oaid_md5': '8e488a40a17aed2f6752f51382a4eafc',
    # Android主卡IMEI原值。限制32字符内。Android选传，app_platform=ios时报错
    'imei1': '8342732742383',
    # Android主卡IMEI原值MD5后转小写。固定为32字符。Android选传，app_platform=ios时报错
    'imei1_md5': '8e488a40a17aed2f6752f51382a4eafc',
    # Android副卡IMEI原值。限制32字符内。Android选传，app_platform=ios时报错
    'imei2': '8342732742383',
    # Android副卡IMEI原值MD5后转小写。固定为32字符。Android选传，app_platform=ios时报错
    'imei2_md5': '8e488a40a17aed2f6752f51382a4eafc',
    # Google Advertising ID原值。固定36字符。Android选传，app_platform=ios时报错
    'gaid': 'B21C5EC5-9921-42FD-AAC5-07A0EB6CF1A0',
    # Google Advertising ID原值MD5后转小写。固定为32字符。Android选传，app_platform=ios时报错
    'gaid_md5': '8e488a40a17aed2f6752f51382a4eafc',
    # //MAC原值。固定17字符。Android选传，app_platform=ios时报错
    'mac': '',
    # MAC原值MD5后转小写。固定为32字符。Android选传，app_platform=ios时报错
    'mac_md5': '',
    # Android ID原值。固定16字符。Android选传，app_platform=ios时报错
    'android_id': '',
    # Android ID原值MD5后转小写。固定为32字符。Android选传，app_platform=ios时报错
    'android_id_md5': '',
}