import random

import requests
import json
import pytest
import time
import random

# 生成数字组合
n = 10


def code_nums(n=6):
    ret = ''
    for i in range(n):
        num = random.randint(0, 9)
        # letter = chr(random.randint(97, 122))
        s = str(random.choice([num]))
        ret += s
    return ret


# 生成小写字母加数字组合
n = 10


def code_nums2(n=6):
    ret = ''
    for i in range(n):
        num = random.randint(0, 9)
        letter = chr(random.randint(97, 122))
        s = str(random.choice([num, letter]))
        ret += s
    return ret


# 153字符
chaochang = '543214223221321321312131313133132131232131232132132543214223221321321312131313133132131232131232132132543214223221321321312131313133132131232131232132132'
cc612 = '543214223221321321312131313133132131232131232132132543214223221321321312131313133132131232131232132132543214223221321321312131313133132131232131232132132543214223221321321312131313133132131232131235432142232213213213121313131331321312321312321321325432142232213213213121313131331321312321312321321325432142232213213213121313131331321312321312321321325432142232213213213121313131331321312321312321321325432142232213213213121313131331321312321312321321325432142232213213213121313131331321312321312321321322132132543214223221321321312131313133132131232131232132132543214223221321321312131313133132131232131232132132'
current_time_13 = int(round(time.time() * 1000))

headers = {
    'Content-Type': 'application/json'
}
global data
data = [
    {
        "application_info": {
            # 线上-a8ed96ae9051499fd98bc46ab9c9495c
            # 测试-decbeb4d840b4bcd1a068ca7233e6ac2
            "appkey": "ea5f9f976bc7e58adcb39effc5a405e3",
            "bundleid": "3423232",
            "app_version": "1.9.0",
            "channel_name": "HUAWEI"
        },
        "timestamp_info": {
            "country": "chi",
            "time_zone": "GMT+08",
            "install_time": int(round(time.time() * 1000)),
            "current_event_time": int(round(time.time() * 1000)),
            "report_time": int(round(time.time() * 1000))
        },
        "collector_info": {
            "integration_type": "sdk",
            "collector_version": "1.8.4",
            "retried_times": ""
        },
        "device_info": {
            "ryid": "8e4888e488a40a17aed2f6752f51382a4eafc",
            "device_id": "3DEA635F-B24F-434B-833F-4ED028FEAEEF",
            "device_id_type": "oaid",
            "device_id_md5": "8e488a40a17aed2f6752f51382a4eafc",
            "device_id_md5_type": "oaid_md5",
            "os": "1",
            "os_version": "19",
            "manufacturer": "HUAWEI",
            "model": "Mate 40",
            "ipv4": "1.1.1.1",
            "ipv6": "1.1.1",
            "ua": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.54 Safari/537.36",
            "att_status": "unknown",
            "lat_status": "disable",
            "oaid": "3DEA635F-B24F-434B-833F-4ED028FEAEEF",
            "oaid_md5": "8e488a40a17aed2f6752f51382a4eafc",
            "imei1": "8342732742383",
            "imei1_md5": "8e488a40a17aed2f6752f51382a4eafc",
            "imei2": "8342732742383",
            "imei2_md5": "8e488a40a17aed2f6752f51382a4eafc",
            "gaid": "B21C5EC5-9921-42FD-AAC5-07A0EB6CF1A0",
            "gaid_md5": "8e488a40a17aed2f6752f51382a4eafc",
            "mac": "23456787898767898",
            "mac_md5": "24953067e92f5bdebc9fd56411fd38f3",
            "android_id": "1a34fc556a43c453",
            "android_id_md5": "8e488a40a17aed2f6752f51382a4eafc"
        },
        "event_info": {
            "event_name": "install",
            "event_type": "preset",
            "event_data": {
                "user_id": "guest123",
                "register_type": "WeChat",
                "login_type": "Wechat",
                "order_id": "2341242342676398724",
                "order_amount": "30",
                "currency_type": "CNY",
                "purchase_type": "Alipay",
                "ad_platform": "csj",
                "placement_type": "interstitial",
                "placement_id": "23425334",
                "ad_ecpm": "4.34",
                # "ad_price_currency_type": "CNY",
                "is_rendered": "1",
                "ad_id": '',
                "ad_appid": '',
                "product_name": '',
                "product_id": '',
                "product_num": '',
                "bid_type": ''
            },
            "custom_params": {
                # "add_cart": "234234",
                # "sku": "234234",
                # "level_up": "234234",
                # "refund": "234234",
                # "refund_amount": "234234"
            }
        }
    }

]

# 如果运行多个测试用例，因为data是全局的，前一个测试用例对data的操作会影响第二个测试用例获取的data
# 涉及到对象引用赋值问题（修改一个对象，另一个对象也会改变，所以需要把data转成json赋值给data_temp）
data_temp = json.dumps(data)


def send_request():
    global data
    # 对接se地址
    # url = 'http://tmtest-se.trackingio.com/receive/tkiov2/sdk'
    # 测试
    url = "http://tmtest.trackingio.com/receive/tkiov2/sdk"
    # 线上
    # url = "http://tkio-receive.solar-engine.com/receive/tkiov2/sdk"
    data[0]['timestamp_info']['install_time'] = int(round(time.time() * 1000))
    print(data)
    response = requests.request("POST", url, headers=headers, data=json.dumps(data))

    print(response.text)
    # 全局data
    data = json.loads(data_temp)
    response = json.loads(response.text)
    s = str(response["status"])
    response["status"] = s
    return response


def send_request2():
    global data
    url = "http://tkio-receive.solar-engine.com/receive/tkiov2/sdk"

    # url = "http://tkiomicro-receive-788931749.cn-north-1.elb.amazonaws.com.cn/receive/tkiov2/sdk"
    data[0]['timestamp_info']['install_time'] = int(round(time.time() * 1000))
    print(data)
    response = requests.request("POST", url, headers=headers, data=json.dumps(data))
    print(response.text)
    # 全局data
    data = json.loads(data_temp)
    response = json.loads(response.text)
    s = str(response["status"])
    response["status"] = s
    return response


def send_requests2s():
    global data
    # 对接se地址
    # url = 'http://tmtest-se.trackingio.com/receive/tkiov2/s2s'
    url = "http://tmtest.trackingio.com/receive/tkiov2/s2s"
    # url = "http://tkio-receive.solar-engine.com/receive/tkiov2/s2s"

    response = requests.request("POST", url, headers=headers, data=json.dumps(data))
    print(response.text)
    # 全局data
    data = json.loads(data_temp)
    response = json.loads(response.text)
    s = str(response["status"])
    response["status"] = s
    return response


# 批量上报的数据中存在异常数据
def test_piliang():
    # data.append(data[0])
    # data[1]['event_info'] = '1'
    # data.append(data[0])
    # data[2]['event_info'] = '2'
    # data.append(data[0])
    # data[3]['event_info'] = '3'
    # 取data的第一个元素
    first = data[0]
    for num in range(3):
        # 修改data的第一个元素的event_info
        first['event_info'] = str(num)
        # 将元素添加到数组
        data.append(first)
    response = send_request()
    assert response["status"] == "406"


#
#
# 批量上报的数据超过100条
def test_piliang2():
    for _ in range(100):
        data.append(data[0])

    response = send_request()
    assert response["status"] == "407"


# -------------------------应用信息-------------------------
# application_info为空
def test_appinfo_empty():
    data[0]["application_info"] = ""
    response = send_request()
    # 这里可以针对返回结果做断言，需要根据实际情况修改
    assert response["status"] == "100"


# appkey为空
def test_app_empty():
    data[0]["application_info"]["appkey"] = ""
    response = send_request()
    # 这里可以针对返回结果做断言，需要根据实际情况修改
    assert response["status"] == "101"


# appkey长度非法
def test_app_illegal_length():
    data[0]["application_info"]["appkey"] = "74b81be2432c029040e0b2bc375ce7fb3"
    response = send_request()
    assert response["status"] == "101"


# bundleid为空
def test_bundleid_empty():
    data[0]["application_info"]["bundleid"] = ""
    response = send_request()
    assert response["status"] == "102"


# bundleid超过128字符
def test_bundleid_illegal_length():
    data[0]["application_info"]["bundleid"] = chaochang
    response = send_request()
    assert response["status"] == "102"


# bundleid包含特殊字符
def test_bundleid1():
    data[0]["application_info"]["bundleid"] = "23232sfds$%%-"
    response = send_request()
    assert response["status"] == "0"


# app_version 为空
def test_app_version_empty():
    data[0]["application_info"]["app_version"] = ""
    response = send_request()
    assert response["status"] == "0"


# app_version 超长
def test_app_version_illegal_length():
    data[0]["application_info"]["app_version"] = chaochang
    response = send_request()
    assert response["status"] == "103"


# app_version 特殊字符
def test_app_version3():
    data[0]["application_info"]["app_version"] = "#¥%"
    response = send_request()
    assert response["status"] == "0"


# channel_name传HUAWEI，os为iOS
def test_channel_name_error():
    data[0]["application_info"]["channel_name"] = "HUAWEI"
    data[0]["device_info"]["os"] = "2"
    response = send_request()
    assert response["status"] == "104"


def test_channel_name():
    data[0]["application_info"]["channel_name"] = "HUAWEI"
    data[0]["device_info"]["os"] = "1"
    response = send_request()
    assert response["status"] == "0"


# channel_name为空
def test_channel_name_empty():
    data[0]["application_info"]["channel_name"] = ""
    response = send_request()
    assert response["status"] == "104"


# channel_name超长
def test_channel_name3():
    data[0]["application_info"]["channel_name"] = chaochang
    response = send_request()
    assert response["status"] == "104"

    # -------------------------时间戳信息-------------------------


# timestamp_info为空
def test_timestamp_info_empty():
    data[0]["timestamp_info"] = ""
    response = send_request()
    assert response["status"] == "105"


# time_zone为空
def test_time_zone_empty():
    data[0]["timestamp_info"]["time_zone"] = ""
    response = send_request()
    assert response["status"] == "106"


# ------------------receive接口迭代-----------
# time_zone不等于6个字符
def test_time_zone__illegal_length():
    data[0]["timestamp_info"]["time_zone"] = chaochang
    response = send_request()
    assert response["status"] == "106"


# time_zone等于6个字符
def test_time_zone1():
    data[0]["timestamp_info"]["time_zone"] = "qwertr"
    response = send_request()
    assert response["status"] == "0"


# time_zone为正常时区
def test_time_zone2():
    data[0]["timestamp_info"]["time_zone"] = "GMT+08"
    response = send_request()
    assert response["status"] == "0"


# time_zone包含特殊字符
def test_time_zone3():
    data[0]["timestamp_info"]["time_zone"] = "G*%+08"
    response = send_request()
    assert response["status"] == "0"


# time_zone为特殊字符
def test_time_zone4():
    data[0]["timestamp_info"]["time_zone"] = "%¥"
    response = send_request()
    assert response["status"] == "0"


# time_zone为17字符,返回106
def test_time_zone5():
    data[0]["timestamp_info"]["time_zone"] = code_nums(17)
    response = send_request()
    assert response["status"] == "106"


# time_zone为16字符，返回0
def test_time_zone5():
    data[0]["timestamp_info"]["time_zone"] = code_nums(16)
    response = send_request()
    assert response["status"] == "0"


# -----------------------receive接口迭代-------------
# install_time为空,event_name为install，返回107
def test_install_time_empty():
    data[0]["timestamp_info"]["install_time"] = ""
    data[0]["event_info"]["event_name"] = "install"
    response = send_request()
    assert response["status"] == "107"


# install_time为空,event_name为非install，返回0
def test_install_time_empty1():
    newList = ['startup', 'register', 'login', 'order', 'purchase',
               'adimpression', 'adclick']
    for event in newList:
        data[0]["timestamp_info"]["install_time"] = ""
        data[0]["event_info"]['event_name'] = event
        data[0]["event_info"]['event_type'] = 'preset'
        response = send_request()
    assert response["status"] == "0"


# install_time不等于13个字符
def test_install_time_illegal_length():
    data[0]["timestamp_info"]["install_time"] = chaochang
    response = send_request()
    assert response["status"] == "107"


# install_time不等于13个字符
def test_install_time13():
    data[0]["timestamp_info"]["install_time"] = "2334567877765"
    response = send_request()
    assert response["status"] == "0"


# install_time为特殊字符
def test_install_time4():
    data[0]["timestamp_info"]["install_time"] = "@#¥##¥%#@@#"
    response = send_request()
    assert response["status"] == "107"


# install_time包含特殊字符
def test_install_time4():
    data[0]["timestamp_info"]["install_time"] = "143343#242334"
    response = send_request()
    assert response["status"] == "0"


# current_event_time为空
def test_current_event_time_empty():
    data[0]["timestamp_info"]["current_event_time"] = ""
    response = send_request()
    assert response["status"] == "108"


# current_event_time不等于13个字符
def test_current_event_time_illegal_length():
    data[0]["timestamp_info"]["current_event_time"] = chaochang
    response = send_request()
    assert response["status"] == "108"


# current_event_time为特殊字符
def test_current_event_time3():
    data[0]["timestamp_info"]["current_event_time"] = "@#¥##¥%#@@#"
    response = send_request()
    assert response["status"] == "108"


# current_event_time包含特殊字符
def test_current_event_time4():
    data[0]["timestamp_info"]["current_event_time"] = "143343#242334"
    response = send_request()
    assert response["status"] == "0"


# report_time为空
def test_report_time_empty():
    data[0]["timestamp_info"]["report_time"] = ""
    response = send_request()
    assert response["status"] == "109"


# report_time不等于13个字符
def test_report_time_illegal_length():
    data[0]["timestamp_info"]["report_time"] = chaochang
    response = send_request()
    assert response["status"] == "109"


# sdk上报，report_time为空
def test_report_time_sdk1():
    data[0]["timestamp_info"]["report_time"] = ""
    data[0]["collector_info"]["integration_type"] = "sdk"
    response = send_request()
    assert response["status"] == "109"


# sdk上报，report_time不为空
def test_report_time_sdk2():
    data[0]["timestamp_info"]["report_time"] = "1637823377000"
    data[0]["collector_info"]["integration_type"] = "sdk"
    response = send_request()
    assert response["status"] == "0"


# s2s上报，report_time不为空
def test_report_time_s2s1():
    data[0]["timestamp_info"]["report_time"] = "1637823377000"
    data[0]["collector_info"]["integration_type"] = "s2s"
    response = send_requests2s()
    assert response["status"] == "0"


# s2s上报，report_time为空
def test_report_time_s2s2():
    data[0]["timestamp_info"]["report_time"] = ""
    data[0]["collector_info"]["integration_type"] = "s2s"
    response = send_requests2s()
    assert response["status"] == "0"


# sdk上报，report_time为特殊字符
def test_report_time_sdk3():
    data[0]["timestamp_info"]["report_time"] = "@#¥##¥%#@@#"
    data[0]["collector_info"]["integration_type"] = "sdk"
    response = send_request()
    assert response["status"] == "109"


# sdk上报，report_time包含特殊字符
def test_report_time_sdk3():
    data[0]["timestamp_info"]["report_time"] = "22657¥%6756"
    data[0]["collector_info"]["integration_type"] = "sdk"
    response = send_request()
    assert response["status"] == "109"


# -------------------------收集器信息-------------------------
def test_collector_info_empty():
    data[0]["collector_info"] = ''
    response = send_request()
    assert response["status"] == "110"


# integration_type为空
def test_integration_type_empty():
    data[0]["collector_info"]["integration_type"] = ''
    response = send_request()
    assert response["status"] == "111"


# integration_type为s2s，接口为sdk
def test_integration_types2s_empty():
    data[0]["collector_info"]["integration_type"] = 's2s'
    response = send_request()
    assert response["status"] == "111"


# integration_type为sdk，接口为s2s
def test_integration_types2s3():
    data[0]["collector_info"]["integration_type"] = 'sdk'
    response = send_requests2s()
    assert response["status"] == "111"



# integration_type为大写SDK
def test_integration_type4():
    data[0]["collector_info"]["integration_type"] = 'SDK'
    response = send_request()
    assert response["status"] == "111"


# integration_type为大写s2s
def test_integration_type5():
    data[0]["collector_info"]["integration_type"] = 'S2S'
    response = send_requests2s()
    assert response["status"] == "111"


# integration_type为其他字符
def test_integration_type6():
    data[0]["collector_info"]["integration_type"] = 'qqq'
    response = send_requests2s()
    assert response["status"] == "111"




# collector_version为空
def test_collector_version_empty():
    data[0]["collector_info"]["collector_version"] = ''
    response = send_request()
    assert response["status"] == "112"


# collector_version不等于5个字符
def test_collector_version_illegal_length():
    data[0]["collector_info"]["collector_version"] = chaochang
    response = send_request()
    assert response["status"] == "112"


# collector_version等于5个字符，但不是规范版本
def test_collector_version2():
    data[0]["collector_info"]["collector_version"] = '11111'
    response = send_request()
    assert response["status"] == "0"


# collector_version等于5个字符，规范版本
def test_collector_version3():
    data[0]["collector_info"]["collector_version"] = '1.8.0'
    response = send_request()
    assert response["status"] == "0"


# retried_times为空
def test_retried_times_empty():
    data[0]["collector_info"]["retried_times"] = ""
    response = send_request()
    assert response["status"] == "0"


# retried_times超过2个字符
def test_retried_times_illegal_length():
    data[0]["collector_info"]["retried_times"] = "123"
    response = send_request()
    assert response["status"] == "113"


# -------------------------终端设备信息-------------------------


# device_info为空
def test_device_info_empty():
    data[0]["device_info"] = ''
    response = send_request()
    assert response["status"] == "114"


# os为android
def test_os_android1():
    data[0]["device_info"]["os"] = 'android'
    response = send_request()
    assert response["status"] == "115"


# os为大写ANDROID
def test_os_android():
    data[0]["device_info"]["os"] = 'ANDROID'
    response = send_request()
    assert response["status"] == "115"


# os为ios,channel_name等于default,没有传idfa等iOS相关参数
def test_os_ios2():
    data[0]["device_info"]["os"] = '2'
    data[0]['application_info']['channel_name'] = 'default'
    response = send_request()
    assert response["status"] == "124"


# os为空
def test_os_empty():
    data[0]["device_info"]["os"] = ''
    response = send_request()
    assert response["status"] == "115"


# os为Windows
def test_os_web():
    data[0]["device_info"]["os"] = '3'
    response = send_request()
    assert response["status"] == "0"


# os_version为空
def test_os_versionempty():
    data[0]["device_info"]["os_version"] = ''
    response = send_request()
    assert response["status"] == "116"


# os_version超长
def test_os_version_illegal_length():
    data[0]["device_info"]["os_version"] = chaochang
    response = send_request()
    assert response["status"] == "116"


# os_version为特殊字符
def test_os_version3():
    data[0]["device_info"]["os_version"] = "#¥@@@"
    response = send_request()
    assert response["status"] == "0"


# os_version包含特殊字符
def test_os_version4():
    data[0]["device_info"]["os_version"] = "12&*"
    response = send_request()
    assert response["status"] == "0"




# manufacturer为空
def test_manufacturerempty():
    data[0]["device_info"]["manufacturer"] = ""
    response = send_request()
    assert response["status"] == "0"


# manufacturer为空
def test_manufacturer_illegal_length():
    data[0]["device_info"]["manufacturer"] = chaochang
    response = send_request()
    assert response["status"] == "117"


# manufacturer为特殊字符
def test_manufacturer3():
    data[0]["device_info"]["manufacturer"] = "@#@#@#！@#@#"
    response = send_request()
    assert response["status"] == "0"


# model为空
def test_model_empty():
    data[0]["device_info"]["model"] = ""
    response = send_request()
    assert response["status"] == "0"


# model超长
def test_model_illegal_length():
    data[0]["device_info"]["model"] = chaochang
    response = send_request()
    assert response["status"] == "118"


# model为特殊字符
def test_model_illegal_length():
    data[0]["device_info"]["model"] = "#¥"
    response = send_request()
    assert response["status"] == "0"


# ipv4 格式非*.*.*.*
def test_ipv4():
    data[0]["device_info"]["ipv4"] = "12.2"
    response = send_request()
    assert response["status"] == "119"


# ipv4 超长
def test_ipv4_illegal_length():
    data[0]["device_info"]["ipv4"] = "12.2323423.32432421321421.32423424"
    response = send_request()
    assert response["status"] == "119"


# 集成方式为s2s，ipv4不传
def test_ipv4_s2s():
    data[0]["device_info"]["ipv4"] = ""
    data[0]["collector_info"]["integration_type"] = 's2s'
    response = send_requests2s()
    assert response["status"] == "119"


# 集成方式为s2s，传ipv4
def test_ipv4_s2s2():
    data[0]["device_info"]["ipv4"] = "1.1.1.1"
    data[0]["collector_info"]["integration_type"] = 's2s'
    response = send_requests2s()
    assert response["status"] == "0"


# 集成方式为s2s，ipv6不传
def test_ipv6_s2s():
    data[0]["device_info"]["ipv6"] = ""
    data[0]["collector_info"]["integration_type"] = 's2s'
    response = send_requests2s()
    assert response["status"] == "0"


# 集成方式为sdk，ipv6不传
def test_ipv6_sdk():
    data[0]["device_info"]["ipv6"] = ""
    data[0]["collector_info"]["integration_type"] = 'sdk'
    response = send_request()
    assert response["status"] == "0"


# ipv6超长
def test_ipv6_illegal_length():
    data[0]["device_info"]["ipv6"] = chaochang
    data[0]["collector_info"]["integration_type"] = 'sdk'
    response = send_request()
    assert response["status"] == "120"


# ua为空,os为android
def test_ua_androidempty():
    data[0]["device_info"]["ua"] = ""
    data[0]["device_info"]["os"] = 'android'
    response = send_request()
    assert response["status"] == "0"


# ua为空,os为web
def test_ua_androidempty():
    data[0]["device_info"]["ua"] = ""
    data[0]["device_info"]["os"] = 'web'
    response = send_request()
    assert response["status"] == "121"


# ua为空,os为iOS
def test_ua_iosempty():
    data[0]["device_info"]["ua"] = ""
    data[0]["device_info"]["os"] = '2'
    data[0]["application_info"]["channel_name"] = 'default'
    response = send_request()
    assert response["status"] == "121"


# ua不为空，但是是无法解析的ua
def test_ua_androidempty():
    data[0]["device_info"]["ua"] = "11111"
    data[0]["device_info"]["os"] = '4'
    response = send_request()
    assert response["status"] == "0"


# os为android，att_status为空
def test_uatt_statusempty():
    data[0]["device_info"]["att_status"] = ""
    response = send_request()
    assert response["status"] == "0"


# os为android，lat_status为空
def test_lat_statusempt():
    data[0]["device_info"]["att_status"] = ""
    response = send_request()
    assert response["status"] == "0"


# oaid为空
def test_oaidempty():
    data[0]["device_info"]["oaid"] = ""
    data[0]["device_info"]["device_id"] = "1a34fc556a43c453"
    data[0]["device_info"]["device_id_type"] = "android_id"
    data[0]["device_info"]["android_id"] = "1a34fc556a43c453"
    response = send_request()
    assert response["status"] == "0"


# oaid长度超长
def test_oaid_illegal_length():
    data[0]["device_info"]["oaid"] = cc612
    data[0]["device_info"]["device_id"] = "1a34fc556a43c453"
    data[0]["device_info"]["device_id_type"] = "android_id"
    data[0]["device_info"]["android_id"] = "1a34fc556a43c453"
    response = send_request()
    assert response["status"] == "126"


# oaid_md5为空
def test_oaid_md5_empty():
    data[0]["device_info"]["oaid_md5"] = ''
    # data[0]["device_info"]["device_id"] = "1a34fc556a43c453"
    # data[0]["device_info"]["device_id_type"] = "android_id"
    # data[0]["device_info"]["android_id"] = "1a34fc556a43c453"
    # data[0]["device_info"]["device_id_md5"] = "30f54d5d0e9f70ef59a212bad02cee8c"
    # data[0]["device_info"]["device_id_md5_type"] = "android_id_md5"
    response = send_request()
    assert response["status"] == "0"


# ios系统，上报oaid，oaid_md5，imei1，imei1_md5，imei2，imei2_md5，gaid，gaid_md5，mac，mac_md5，android_id，android_id_md5，在"3237receiveios"脚本里


# oaid_md5长度超长
def test_oaid_md5_illegal_length():
    data[0]["device_info"]["oaid_md5"] = cc612
    data[0]["device_info"]["device_id"] = "1a34fc556a43c453"
    data[0]["device_info"]["device_id_type"] = "android_id"
    data[0]["device_info"]["android_id"] = "1a34fc556a43c453"
    response = send_request()
    assert response["status"] == "127"


# 安卓系统，上报idfa
def test_idfa():
    data[0]["device_info"]["idfa"] = "3DEA635F-B24F-434B-833F-4ED028FEAEEF"
    response = send_request()
    assert response["status"] == "115"


# 安卓系统，上报idfa_md5
def test_idfa_md5():
    data[0]["device_info"]["idfa_md5"] = "8e488a40a17aed2f6752f51382a4eafc"
    response = send_request()
    assert response["status"] == "115"


# 安卓系统，上报idfv
def test_idfv():
    data[0]["device_info"]["idfv"] = "3DEA635F-B24F-434B-833F-4ED028FEAEEF"
    response = send_request()
    assert response["status"] == "115"


# 安卓系统，上报idfv_md5
def test_idfv_md5():
    data[0]["device_info"]["idfv_md5"] = "8e488a40a17aed2f6752f51382a4eafc"
    response = send_request()
    assert response["status"] == "115"


# imei1为空
def test_imei1_empty():
    data[0]["device_info"]["imei1"] = ""
    data[0]["device_info"]["device_id"] = "1a34fc556a43c453"
    data[0]["device_info"]["device_id_type"] = "android_id"
    data[0]["device_info"]["android_id"] = "1a34fc556a43c453"
    response = send_request()
    assert response["status"] == "0"


# imei1长度超长
def test_imei1__illegal_length():
    data[0]["device_info"]["imei1"] = chaochang
    data[0]["device_info"]["device_id"] = "1a34fc556a43c453"
    data[0]["device_info"]["device_id_type"] = "android_id"
    data[0]["device_info"]["android_id"] = "1a34fc556a43c453"
    response = send_request()
    assert response["status"] == "128"


# imei1_md5为空
def test_imei1_md5_empty():
    data[0]["device_info"]["imei1_md5"] = ""
    data[0]["device_info"]["device_id"] = "1a34fc556a43c453"
    data[0]["device_info"]["device_id_type"] = "android_id"
    data[0]["device_info"]["android_id"] = "1a34fc556a43c453"
    response = send_request()
    assert response["status"] == "0"


# imei1_md5长度超长
def test_imei1_md5_illegal_length():
    data[0]["device_info"]["imei1_md5"] = cc612
    data[0]["device_info"]["device_id"] = "1a34fc556a43c453"
    data[0]["device_info"]["device_id_type"] = "android_id"
    data[0]["device_info"]["android_id"] = "1a34fc556a43c453"
    response = send_request()
    assert response["status"] == "129"


# imei2为空
def test_imei2_empty():
    data[0]["device_info"]["imei2"] = ""
    data[0]["device_info"]["device_id"] = "1a34fc556a43c453"
    data[0]["device_info"]["device_id_type"] = "android_id"
    data[0]["device_info"]["android_id"] = "1a34fc556a43c453"
    response = send_request()
    assert response["status"] == "0"


# imei2长度超长
def test_imei2_illegal_length():
    data[0]["device_info"]["imei2"] = chaochang
    data[0]["device_info"]["device_id"] = "1a34fc556a43c453"
    data[0]["device_info"]["device_id_type"] = "android_id"
    data[0]["device_info"]["android_id"] = "1a34fc556a43c453"
    response = send_request()
    assert response["status"] == "130"


# imei2_md5为空
def test_imei2_md5_empty():
    data[0]["device_info"]["imei2_md5"] = ""
    data[0]["device_info"]["device_id"] = "1a34fc556a43c453"
    data[0]["device_info"]["device_id_type"] = "android_id"
    data[0]["device_info"]["android_id"] = "1a34fc556a43c453"
    response = send_request()
    assert response["status"] == "0"


# imei2_md5长度超长
def test_imei2_md5_illegal_length():
    data[0]["device_info"]["imei2_md5"] = cc612
    data[0]["device_info"]["device_id"] = "1a34fc556a43c453"
    data[0]["device_info"]["device_id_type"] = "android_id"
    data[0]["device_info"]["android_id"] = "1a34fc556a43c453"
    response = send_request()
    assert response["status"] == "131"


# gaid为空
def test_gaid_empty():
    data[0]["device_info"]["gaid"] = ""
    data[0]["device_info"]["device_id"] = "1a34fc556a43c453"
    data[0]["device_info"]["device_id_type"] = "android_id"
    data[0]["device_info"]["android_id"] = "1a34fc556a43c453"
    response = send_request()
    assert response["status"] == "0"


# gaid长度超长
def test_imei2__illegal_length():
    data[0]["device_info"]["gaid"] = chaochang
    data[0]["device_info"]["device_id"] = "1a34fc556a43c453"
    data[0]["device_info"]["device_id_type"] = "android_id"
    data[0]["device_info"]["android_id"] = "1a34fc556a43c453"
    response = send_request()
    assert response["status"] == "132"


# gaid_md5为空
def test_gaid_md5_empty():
    data[0]["device_info"]["gaid_md5"] = ""
    data[0]["device_info"]["device_id"] = "1a34fc556a43c453"
    data[0]["device_info"]["device_id_type"] = "android_id"
    data[0]["device_info"]["android_id"] = "1a34fc556a43c453"
    response = send_request()
    assert response["status"] == "0"


# gaid_md5长度超长
def test_imei2_md5_illegal_length():
    data[0]["device_info"]["gaid_md5"] = cc612
    data[0]["device_info"]["device_id"] = "1a34fc556a43c453"
    data[0]["device_info"]["device_id_type"] = "android_id"
    data[0]["device_info"]["android_id"] = "1a34fc556a43c453"
    response = send_request()
    assert response["status"] == "133"


# mac为空
def test_mac_empty():
    data[0]["device_info"]["mac"] = ""
    data[0]["device_info"]["device_id"] = "1a34fc556a43c453"
    data[0]["device_info"]["device_id_type"] = "android_id"
    data[0]["device_info"]["android_id"] = "1a34fc556a43c453"
    response = send_request()
    assert response["status"] == "0"


# mac长度超长
def test_mac__illegal_length():
    data[0]["device_info"]["mac"] = chaochang
    data[0]["device_info"]["device_id"] = "1a34fc556a43c453"
    data[0]["device_info"]["device_id_type"] = "android_id"
    data[0]["device_info"]["android_id"] = "1a34fc556a43c453"
    response = send_request()
    assert response["status"] == "134"


# mac_md5为空
def test_mac_md5_empty():
    data[0]["device_info"]["mac_md5"] = ""
    data[0]["device_info"]["device_id"] = "1a34fc556a43c453"
    data[0]["device_info"]["device_id_type"] = "android_id"
    data[0]["device_info"]["android_id"] = "1a34fc556a43c453"
    response = send_request()
    assert response["status"] == "0"


# mac_md5长度超长
def test_mac_md5_illegal_length():
    data[0]["device_info"]["mac_md5"] = cc612
    data[0]["device_info"]["device_id"] = "1a34fc556a43c453"
    data[0]["device_info"]["device_id_type"] = "android_id"
    data[0]["device_info"]["android_id"] = "1a34fc556a43c453"
    response = send_request()
    assert response["status"] == "135"


# android_id为空,android_id_md5不为空
def test_android_id_empty():
    data[0]["device_info"]["android_id"] = ""
    data[0]["device_info"]["android_id_md5"] = "9120163167c05aed85f30bf88495bd89"
    data[0]["device_info"]["device_id"] = "3DEA678F-B24F-434B-833F-4ED028FEAEEF"
    data[0]["device_info"]["device_id_type"] = "oaid"
    data[0]["device_info"]["oaid"] = "3DEA678F-B24F-434B-833F-4ED028FEAEEF"
    response = send_request()
    assert response["status"] == "0"


# android_id长度超长
def test_android_id__illegal_length():
    data[0]["device_info"]["android_id"] = chaochang
    data[0]["device_info"]["android_id_md5"] = "9120163167c05aed85f30bf88495bd89"
    data[0]["device_info"]["device_id"] = "3DEA678F-B24F-434B-833F-4ED028FEAEEF"
    data[0]["device_info"]["device_id_type"] = "oaid"
    data[0]["device_info"]["oaid"] = "3DEA678F-B24F-434B-833F-4ED028FEAEEF"
    response = send_request()
    assert response["status"] == "136"


# android_id为空,android_id_md5为空
def test_android_id_md5__empty():
    data[0]["device_info"]["android_id"] = ''
    data[0]["device_info"]["android_id_md5"] = ""
    data[0]["device_info"]["device_id"] = "3DEA678F-B24F-434B-833F-4ED028FEAEEF"
    data[0]["device_info"]["device_id_type"] = "oaid"
    data[0]["device_info"]["oaid"] = "3DEA678F-B24F-434B-833F-4ED028FEAEEF"
    response = send_request()
    assert response["status"] == "136"


# android_id_md5长度超长
def test_android_id_illegal_length():
    data[0]["device_info"]["android_id"] = "7564324234234322"
    data[0]["device_info"]["android_id_md5"] = chaochang
    data[0]["device_info"]["device_id"] = "3DEA678F-B24F-434B-833F-4ED028FEAEEF"
    data[0]["device_info"]["device_id_type"] = "oaid"
    data[0]["device_info"]["oaid"] = "3DEA678F-B24F-434B-833F-4ED028FEAEEF"
    response = send_request()
    assert response["status"] == "136"


# *******************************修改了需求，修改为：移除device_id与设备id的一致性校验。例如device_id_type=oaid时，不校验device_id与oaid是否一致***************************
# device_id与device_id_type不一致
def test_device_id1():
    data[0]["device_info"]["android_id"] = "7564324234234322"
    data[0]["device_info"]["android_id_md5"] = "66bfc3658fc8766d826114bf4c2320b7"
    data[0]["device_info"]["device_id"] = "3DEA678F-B24F-434B-833F-4ED028FEAEEF"
    data[0]["device_info"]["device_id_type"] = "android_id"
    data[0]["device_info"]["oaid"] = "3DEA678F-B24F-434B-833F-4ED028FEAEEF"
    response = send_request()
    assert response["status"] == "0"


# device_id超长
def test_device_id_illegal_length():
    data[0]["device_info"]["android_id"] = "7564324234234322"
    data[0]["device_info"]["android_id_md5"] = "66bfc3658fc8766d826114bf4c2320b7"
    data[0]["device_info"]["device_id"] = cc612
    data[0]["device_info"]["device_id_type"] = "android_id"
    data[0]["device_info"]["oaid"] = "3DEA678F-B24F-434B-833F-4ED028FEAEEF"
    response = send_request()
    assert response["status"] == "137"


# device_id为空,device_id_md5也为空
def test_device_id_empty1():
    data[0]["device_info"]["device_id"] = ''
    data[0]["device_info"]["device_id_md5"] = ''
    response = send_request()
    assert response["status"] == "137"


# device_id_type为空
def test_device_id_type_empty2():
    data[0]["device_info"]["device_id_type"] = ''
    response = send_request()
    assert response["status"] == "138"


# device_id_type为one_id
def test_device_id_type_empty3():
    data[0]["device_info"]["device_id_type"] = 'one_id'
    response = send_request()
    assert response["status"] == "0"


# device_id为空,device_id_md5不为空
def test_device_idmd5_empty():
    data[0]["device_info"]["device_id"] = ''
    data[0]["device_info"]["device_id_md5"] = '4f71f3a43123b1538e93e8c0b9773d06'
    data[0]["device_info"]["device_id_md5_type"] = 'oaid_md5'
    data[0]["device_info"]['oaid_md5'] = '4f71f3a43123b1538e93e8c0b9773d06'
    response = send_request()
    assert response["status"] == "0"


# device_id_type是文档中不存在的值
def test_device_id3():
    data[0]["device_info"]["android_id"] = "7564324234234322"
    data[0]["device_info"]["android_id_md5"] = "66bfc3658fc8766d826114bf4c2320b7"
    data[0]["device_info"]["device_id"] = "3DEA678F-B24F-434B-833F-4ED028FEAEEF"
    data[0]["device_info"]["device_id_type"] = "qqq"
    data[0]["device_info"]["oaid"] = "3DEA678F-B24F-434B-833F-4ED028FEAEEF"
    response = send_request()
    assert response["status"] == "0"


# device_id_type长度超长
def test_device_id_type_illegal_length():
    data[0]["device_info"]["device_id_type"] = chaochang
    response = send_request()
    assert response["status"] == "138"


# device_id_md5_type为空，device_id_md5有值
def test_device_id_md5_type_empty():
    data[0]["device_info"]["device_id"] = ''
    data[0]["device_info"]["device_id_md5"] = '4f71f3a43123b1538e93e8c0b9773d06'
    data[0]["device_info"]["device_id_md5_type"] = ''
    data[0]["device_info"]['oaid_md5'] = '4f71f3a43123b1538e93e8c0b9773d06'
    response = send_request()
    assert response["status"] == "139"


# device_id_md5_type为任意字符，device_id_md5有值
def test_device_id_md5_type2():
    data[0]["device_info"]["device_id"] = ''
    data[0]["device_info"]["device_id_md5"] = '4f71f3a43123b1538e93e8c0b9773d06'
    data[0]["device_info"]["device_id_md5_type"] = 'aaa'
    data[0]["device_info"]['oaid_md5'] = '4f71f3a43123b1538e93e8c0b9773d06'
    response = send_request()
    assert response["status"] == "0"


# device_id_md5与device_id_md5_type不一致
def test_device_id_md5_type3():
    data[0]["device_info"]["device_id"] = ''
    data[0]["device_info"]["device_id_md5"] = '4f71f3a43123b1538e93e8c0b9773d06'
    data[0]["device_info"]["device_id_md5_type"] = 'android_id'
    data[0]["device_info"]['oaid_md5'] = '4f71f3a43123b1538e93e8c0b9773d06'
    response = send_request()
    assert response["status"] == "0"


# ------------------------------事件信息----------------------

# event_info为空
def test_event_info():
    data[0]["event_info"] = ''
    response = send_request()
    assert response["status"] == "142"


# eevent_name为空
def test_event_info():
    data[0]["event_info"]['event_name'] = ''
    response = send_request()
    assert response["status"] == "143"


# event_type为preset
def test_event_name1():
    newList = ['install', 'startup', 'register', 'login', 'order', 'purchase',
               'adimpression', 'adclick', '222', 'wwqeWEW', 'We2_32e']
    for event in newList:
        data[0]["event_info"]['event_name'] = event
        data[0]["event_info"]['event_type'] = 'preset'
        response = send_request()
    assert response["status"] == "143"


# event_type为custom
def test_event_name2():
    # lst = []
    newList = ['222', 'wwqeWEW', 'We2_32e']
    for event in newList:
        data[0]["event_info"]['event_name'] = event
        data[0]["event_info"]['event_type'] = "custom"

        response = send_request()
    assert response["status"] == "0"


# event_type为preset，event为自定义事件
def test_event_name3():
    # lst = []
    newList = ['222', 'wwqeWEW', 'We2_32e']
    for event in newList:
        data[0]["event_info"]['event_name'] = event
        data[0]["event_info"]['event_type'] = "preset"
        response = send_request()
    assert response["status"] == "143"


# 自定义事件，包含特殊字符（非名称限制数字、大小写字符、下划线）
def test_event_name4():
    # lst = []
    newList = ['@¥@@#¥#@¥', '2321==--=', 'We*&*(&']
    for event in newList:
        data[0]["event_info"]['event_name'] = event
        data[0]["event_info"]['event_type'] = "custom"
        response = send_request()
    assert response["status"] == "143"


# event_name超长
def test_event_name5():
    data[0]["event_info"]['event_name'] = chaochang
    response = send_request()
    assert response["status"] == "143"


# event_type为custom，event_name为大写install
def test_event_name7():
    data[0]["event_info"]['event_name'] = "INSTALL"
    data[0]["event_info"]['event_type'] = "custom"
    response = send_request()
    assert response["status"] == "0"


# event_type为custom，event_name为preset中的固定参数
def test_event_name8():
    newList = ['install', 'startup', 'register', 'login', 'order', 'purchase',
               'adimpression', 'adclick']
    for event in newList:
        data[0]["event_info"]['event_name'] = event
        data[0]["event_info"]['event_type'] = "custom"

        response = send_request()
    assert response["status"] == "143"


# event_type为非固定的值
def test_event_type():
    data[0]["event_info"]['event_type'] = '123'
    response = send_request()
    assert response["status"] == "144"


# event_type为空
def test_event_type():
    data[0]["event_info"]['event_type'] = ''
    response = send_request()
    assert response["status"] == "144"


# event_data为空
def test_event_data():
    data[0]["event_info"]["event_data"] = ""
    response = send_request()
    assert response["status"] == "0"


# user_id为空
def test_user_id1():
    data[0]["event_info"]["event_data"]['user_id'] = ""
    response = send_request()
    assert response["status"] == "0"


# user_id超长
def test_user_id2():
    data[0]["event_info"]["event_data"]['user_id'] = chaochang
    response = send_request()
    assert response["status"] == "0"


# 事件为install时，user_id为-1
def test_user_id3():
    data[0]["event_info"]["event_data"]['user_id'] = "-1"
    data[0]['event_info']['event_name'] = 'install'
    response = send_request()
    assert response["status"] == "0"


# 事件为startup时，user_id为-1
def test_user_id4():
    data[0]["event_info"]["event_data"]['user_id'] = "-1"
    data[0]['event_info']['event_name'] = 'startup'
    response = send_request()
    assert response["status"] == "0"


# register_type超长
def test_register_type1():
    data[0]["event_info"]["event_data"]['register_type'] = chaochang
    response = send_request()
    assert response["status"] == "0"


# event_name为register，register_type为空
def test_register_type2():
    data[0]["event_info"]["event_data"]['register_type'] = ""
    data[0]['event_info']['event_name'] = 'register'
    response = send_request()
    assert response["status"] == "0"


# event_name为register，register_type不为空
def test_register_type3():
    data[0]["event_info"]["event_data"]['register_type'] = "WeChat"
    data[0]['event_info']['event_name'] = 'register'
    response = send_request()
    assert response["status"] == "0"


# event_name为非register，register_type为空
def test_register_type4():
    newList = ['install', 'startup', 'login', 'order', 'purchase',
               'adimpression', 'adclick']
    for event in newList:
        data[0]["event_info"]["event_data"]['register_type'] = ""
        data[0]['event_info']['event_name'] = event
        response = send_request()
    assert response["status"] == "0"


# event_name为非register，register_type不为空
def test_register_type5():
    newList = ['install', 'startup', 'login', 'order', 'purchase',
               'adimpression', 'adclick']
    for event in newList:
        data[0]["event_info"]["event_data"]['register_type'] = "WeChat"
        data[0]['event_info']['event_name'] = event

        response = send_request()
    assert response["status"] == "0"


# login_type超长
def test_login_type1():
    data[0]["event_info"]["event_data"]['login_type'] = chaochang
    response = send_request()
    assert response["status"] == "0"


# event_name为login，login_type为空
def test_login_type2():
    data[0]["event_info"]["event_data"]['login_type'] = ""
    data[0]['event_info']['event_name'] = 'login'
    response = send_request()
    assert response["status"] == "0"


# event_name为login，login_type不为空
def test_login_type3():
    data[0]["event_info"]["event_data"]['login_type'] = "WeChat"
    data[0]['event_info']['event_name'] = 'login'
    response = send_request()
    assert response["status"] == "0"


# event_name为非login，login_type为空
def test_login_type4():
    newList = ['install', 'startup' 'order', 'purchase',
               'adimpression', 'adclick']
    for event in newList:
        data[0]["event_info"]["event_data"]['login_type'] = ""
        data[0]['event_info']['event_name'] = event

        response = send_request()
    assert response["status"] == "0"


# event_name为非login，login_type不为空
def test_login_type5():
    newList = ['install', 'startup', 'order', 'purchase',
               'adimpression', 'adclick']
    for event in newList:
        data[0]["event_info"]["event_data"]['login_type'] = "WeChat"
        data[0]['event_info']['event_name'] = event

        response = send_request()
    assert response["status"] == "0"


# order_id超长
def test_order_id1():
    data[0]["event_info"]["event_data"]['order_id'] = chaochang
    response = send_request()
    assert response["status"] == "0"


# event_name为order，order_id为空
def test_order_id2():
    data[0]["event_info"]["event_data"]['order_id'] = ""
    data[0]['event_info']['event_name'] = 'order'
    response = send_request()
    assert response["status"] == "0"


# event_name为order，order_id不为空
def test_order_id3():
    data[0]["event_info"]["event_data"]['order_id'] = "2341242342676398724"
    data[0]['event_info']['event_name'] = 'order'
    response = send_request()
    assert response["status"] == "0"


# event_name为非order和purchase，order_id为空
def test_order_id4():
    newList = ['install', 'startup', 'register', 'login', 'adimpression', 'adclick']
    for event in newList:
        data[0]["event_info"]["event_data"]['order_id'] = ""
        data[0]['event_info']['event_name'] = event

        response = send_request()
    assert response["status"] == "0"


# event_name为非order和purchase，order_id不为空
def test_order_id5():
    newList = ['install', 'startup', 'register', 'login', 'adimpression', 'adclick']
    for event in newList:
        data[0]["event_info"]["event_data"]['order_id'] = "2341242342676398724"
        data[0]['event_info']['event_name'] = event

        response = send_request()
    assert response["status"] == "0"


# event_name为purchase，order_id为空
def test_order_id6():
    data[0]["event_info"]["event_data"]['order_id'] = ""
    data[0]['event_info']['event_name'] = 'purchase'
    response = send_request()
    assert response["status"] == "0"


# order_amount非0以及正整数
def test_order_amount1():
    data[0]["event_info"]["event_data"]['order_amount'] = "23.232131"
    response = send_request()
    assert response["status"] == "0"


# event_name为order，order_amount为空
def test_order_amount2():
    data[0]["event_info"]["event_data"]['order_amount'] = ""
    data[0]['event_info']['event_name'] = 'order'
    response = send_request()
    assert response["status"] == "0"


# event_name为order，order_amount不为空
def test_order_amount3():
    data[0]["event_info"]["event_data"]['order_amount'] = "0"
    data[0]['event_info']['event_name'] = 'order'
    response = send_request()
    assert response["status"] == "0"


# event_name为非order和purchase，order_amount为空
def test_order_amount4():
    newList = ['install', 'startup', 'register', 'login', 'adimpression', 'adclick']
    for event in newList:
        data[0]["event_info"]["event_data"]['order_amount'] = ""
        data[0]['event_info']['event_name'] = event

        response = send_request()
    assert response["status"] == "0"


# event_name为非order和purchase，order_amount不为空
def test_order_amount5():
    newList = ['install', 'startup', 'register', 'login', 'adimpression', 'adclick']
    for event in newList:
        data[0]["event_info"]["event_data"]['order_amount'] = "2341242342676398724"
        data[0]['event_info']['event_name'] = event

        response = send_request()
    assert response["status"] == "0"


# event_name为purchase，order_amount为空
def test_order_amount6():
    data[0]["event_info"]["event_data"]['order_amount'] = ""
    data[0]['event_info']['event_name'] = 'purchase'
    response = send_request()
    assert response["status"] == "0"


# event_name为purchase，order_amount不为空
def test_order_amount7():
    data[0]["event_info"]["event_data"]['order_amount'] = "0"
    data[0]['event_info']['event_name'] = 'purchase'
    response = send_request()
    assert response["status"] == "0"


# event_name为purchase,currency_type为空
def test_currency_type1():
    data[0]['event_info']['event_data']['currency_type'] = ''
    data[0]['event_info']['event_name'] = 'purchase'
    response = send_request()
    assert response["status"] == "0"


# event_name为purchase,currency_type不为空
def test_currency_type2():
    data[0]['event_info']['event_data']['currency_type'] = 'CNY'
    data[0]['event_info']['event_name'] = 'purchase'
    response = send_request()
    assert response["status"] == "0"


# event_name为purchase,currency_type为2个字符
def test_currency_type3():
    data[0]['event_info']['event_data']['currency_type'] = 'aa'
    data[0]['event_info']['event_name'] = 'purchase'
    response = send_request()
    assert response["status"] == "0"


# event_name为非purchase，currency_type为空
def test__currency_type4():
    newList = ['install', 'startup', 'register', 'login', 'adimpression', 'adclick']
    for event in newList:
        data[0]["event_info"]["event_data"]['currency_type'] = ""
        data[0]['event_info']['event_name'] = event
        response = send_request()
    assert response["status"] == "0"


# event_name为purchase,purchase_type为空
def test_purchase_type1():
    data[0]['event_info']['event_data']['purchase_type'] = ''
    data[0]['event_info']['event_name'] = 'purchase'
    response = send_request()
    assert response["status"] == "0"


# event_name为purchase,purchase_type不为空
def test_purchase_type2():
    data[0]['event_info']['event_data']['purchase_type'] = 'Alipay'
    data[0]['event_info']['event_name'] = 'purchase'
    response = send_request()
    assert response["status"] == "0"


# event_name为非purchase，purchase_type为空
def test_purchase_type3():
    newList = ['install', 'startup', 'register', 'login', 'adimpression', 'adclick']
    for event in newList:
        data[0]["event_info"]["event_data"]['purchase_type'] = ""
        data[0]['event_info']['event_name'] = event
        response = send_request()
    assert response["status"] == "0"


# purchase_type超长
def test_purchase_type4():
    data[0]['event_info']['event_data']['purchase_type'] = chaochang
    data[0]['event_info']['event_name'] = 'purchase'
    response = send_request()
    assert response["status"] == "0"


# event_name为adimpression和adclick，ad_platform为空
def test_ad_platform1():
    newlist = ["adimpression", "adclick"]
    for event in newlist:
        data[0]["event_info"]['event_data']['ad_platform'] = ''
        data[0]['event_info']['event_name'] = event
        response = send_request()
    assert response["status"] == "0"


# event_name为adimpression和adclick，ad_platform不为空
def test_ad_platform2():
    newlist = ["adimpression", "adclick"]
    for event in newlist:
        data[0]["event_info"]['event_data']['ad_platform'] = 'csj'
        data[0]['event_info']['event_name'] = event
        response = send_request()
    assert response["status"] == "0"


# # event_name非adimpression和adclick，ad_platform为空
def test_ad_platform3():
    newlist = ['install', 'startup', 'register', 'login', 'order', 'purchase']
    for event in newlist:
        data[0]["event_info"]['event_data']['ad_platform'] = ''
        data[0]['event_info']['event_name'] = event
        response = send_request()
    assert response["status"] == "0"


# # event_name非adimpression和adclick，ad_platform不为空
def test_ad_platform4():
    newlist = ['install', 'startup', 'register', 'login', 'order', 'purchase']
    for event in newlist:
        data[0]["event_info"]['event_data']['ad_platform'] = 'ylh'
        data[0]['event_info']['event_name'] = event
        response = send_request()
    assert response["status"] == "0"


# ad_platform超长
def test_ad_platform5():
    data[0]["event_info"]['event_data']['ad_platform'] = chaochang
    data[0]['event_info']['event_name'] = "adclick"
    response = send_request()
    assert response["status"] == "0"


# # event_name为adimpression和adclick，placement_type为空
def test_placement_type1():
    newlist = ["adimpression", "adclick"]
    for event in newlist:
        data[0]["event_info"]['event_data']['placement_type'] = ''
        data[0]['event_info']['event_name'] = event
        response = send_request()
    assert response["status"] == "0"


# # event_name为adimpression和adclick，placement_type不为空
def test_placement_type2():
    newlist = ["adimpression", "adclick"]
    for event in newlist:
        data[0]["event_info"]['event_data']['placement_type'] = 'interstitial'
        data[0]['event_info']['event_name'] = event
        response = send_request()
    assert response["status"] == "0"


# # event_name非adimpression和adclick，placement_type为空
def test_placement_type3():
    newlist = ['install', 'startup', 'register', 'login', 'order', 'purchase']
    for event in newlist:
        data[0]["event_info"]['event_data']['placement_type'] = ''
        data[0]['event_info']['event_name'] = event
        response = send_request()
    assert response["status"] == "0"


# # event_name非adimpression和adclick，placement_type不为空
def test_placement_type4():
    newlist = ['install', 'startup', 'register', 'login', 'order', 'purchase']
    for event in newlist:
        data[0]["event_info"]['event_data']['placement_type'] = 'interstitial'
        data[0]['event_info']['event_name'] = event
        response = send_request()
    assert response["status"] == "0"


# # placement_type超长
def test_placement_type5():
    data[0]["event_info"]['event_data']['placement_type'] = chaochang
    data[0]['event_info']['event_name'] = "adclick"
    response = send_request()
    assert response["status"] == "154"


# # event_name为adimpression和adclick，placement_id为空
def test_placement_id1():
    newlist = ["adimpression", "adclick"]
    for event in newlist:
        data[0]["event_info"]['event_data']['placement_id'] = ''
        data[0]['event_info']['event_name'] = event
        response = send_request()
    assert response["status"] == "0"


# # event_name为adimpression和adclick，placement_id不为空
def test_placement_id2():
    newlist = ["adimpression", "adclick"]
    for event in newlist:
        data[0]["event_info"]['event_data']['placement_id'] = '765453434'
        data[0]['event_info']['event_name'] = event
        response = send_request()
    assert response["status"] == "0"


# # event_name非adimpression和adclick，placement_id为空
def test_placement_id3():
    newlist = ['install', 'startup', 'register', 'login', 'order', 'purchase']
    for event in newlist:
        data[0]["event_info"]['event_data']['placement_id'] = ''
        data[0]['event_info']['event_name'] = event
        response = send_request()
    assert response["status"] == "0"


# # event_name非adimpression和adclick，placement_id不为空
def test_placement_id4():
    newlist = ['install', 'startup', 'register', 'login', 'order', 'purchase']
    for event in newlist:
        data[0]["event_info"]['event_data']['placement_id'] = '98765434567654'
        data[0]['event_info']['event_name'] = event
        response = send_request()
    assert response["status"] == "0"


# # placement_id超长
def test_placement_type5():
    data[0]["event_info"]['event_data']['placement_id'] = chaochang
    data[0]['event_info']['event_name'] = "adclick"
    response = send_request()
    assert response["status"] == "0"


# event_name为adimpression，ad_ecpm为空,返回0
def test_ad_price1():
    data[0]["event_info"]['event_data']['ad_ecpm'] = ''
    data[0]['event_info']['event_name'] = 'adimpression'
    response = send_request()
    assert response["status"] == "0"


# event_name为adimpression，ad_ecpm不为空
def test_ad_price2():
    data[0]["event_info"]['event_data']['ad_ecpm'] = '765453434'
    data[0]['event_info']['event_name'] = 'adimpression'
    response = send_request()
    assert response["status"] == "0"


# event_name非adimpression，ad_ecpm为空
def test_ad_price3():
    newlist = ['install', 'startup', 'register', 'login', 'order', 'purchase', 'adclick']
    for event in newlist:
        data[0]["event_info"]['event_data']['ad_ecpm'] = ''
        data[0]['event_info']['event_name'] = event
        response = send_request()
    assert response["status"] == "0"


# event_name非adimpression，ad_ecpm不为空
def test_ad_price4():
    newlist = ['install', 'startup', 'register', 'login', 'order', 'purchase', 'adclick']
    for event in newlist:
        data[0]["event_info"]['event_data']['ad_ecpm'] = '98765434567654'
        data[0]['event_info']['event_name'] = event
        response = send_request()
    assert response["status"] == "0"


# ad_ecpm超长，返回0
def test_ad_price5():
    data[0]["event_info"]['event_data']['ad_ecpm'] = chaochang
    data[0]['event_info']['event_name'] = "adimpression"
    response = send_request()
    assert response["status"] == "0"


# -------------------receive接口迭代-------------
# # event_name为adimpression，ad_price_currency_type为空
# def test_ad_price_currency_type1():
#     data[0]["event_info"]['event_data']['ad_price_currency_type'] = ''
#     data[0]['event_info']['event_name'] = 'adimpression'
#     response = send_request()
#     assert response["status"] == "157"
#
#
# # event_name为adimpression，ad_price_currency_type不为空
# def test_ad_price_currency_type2():
#     data[0]["event_info"]['event_data']['ad_price_currency_type'] = 'CNY'
#     data[0]['event_info']['event_name'] = 'adimpression'
#     response = send_request()
#     assert response["status"] == "0"
#
#
# # event_name非adimpression，ad_price_currency_type为空
# def test_ad_price_currency_type3():
#     newlist = ['install', 'startup', 'register', 'login', 'order', 'purchase', 'adclick']
#     for event in newlist:
#         data[0]["event_info"]['event_data']['ad_price_currency_type'] = ''
#         data[0]['event_info']['event_name'] = event
#         response = send_request()
#     assert response["status"] == "0"
#
#
# # event_name非adimpression，ad_price_currency_type不为空
# def test_ad_price_currency_type4():
#     newlist = ['install', 'startup', 'register', 'login', 'order', 'purchase', 'adclick']
#     for event in newlist:
#         data[0]["event_info"]['event_data']['ad_price_currency_type'] = 'CNY'
#         data[0]['event_info']['event_name'] = event
#         response = send_request()
#     assert response["status"] == "0"
#
#
# # ad_price_currency_type非三个字符
# def test_ad_price_currency_type5():
#     data[0]["event_info"]['event_data']['ad_price_currency_type'] = "0"
#     data[0]['event_info']['event_name'] = "adimpression"
#     response = send_request()
#     assert response["status"] == "157"


# is_rendered为空
def test_is_rendered1():
    data[0]['event_info']['event_data']['is_rendered'] = ''
    response = send_request()
    assert response["status"] == "0"


# is_rendered为1
def test_is_rendered2():
    data[0]['event_info']['event_data']['is_rendered'] = '1'
    response = send_request()
    assert response["status"] == "0"


# is_rendered为0
def test_is_rendered3():
    data[0]['event_info']['event_data']['is_rendered'] = '0'
    response = send_request()
    assert response["status"] == "0"


# is_rendered为其他字符
def test_is_rendered3():
    data[0]['event_info']['event_data']['is_rendered'] = 'qqq'
    response = send_request()
    assert response["status"] == "0"


# custom_params为空，已在postman执行
# def test_custom_params():
#     data[0]['event_info']['custom_params'] = ""
#     response = send_request()
#     assert response["status"] == "0"


# custom_params下有特殊字符（key限制数字、大小写字符、下划线）
def test_custom_params2():
    data[0]['event_info']['custom_params']["@#¥@#¥#@"] = '@#2321321@#¥#@'
    response = send_request()
    assert response["status"] == "160"


# key超过32位
def test_custom_params3():
    data[0]['event_info']['custom_params'][
        "3287327823728372837821378123dwdgyugggyygdwyuyuygdgyudddddydgdde"] = 'key超过32位'
    response = send_request()
    assert response["status"] == "160"


# value超过64位
def test_custom_params3():
    data[0]['event_info']['custom_params']["key"] = chaochang
    response = send_request()
    assert response["status"] == "161"


# 事件自定义参数嵌套，内含参数超过10项
def test_custom_params3():
    data[0]['event_info']['custom_params']["key1"] = "111"
    data[0]['event_info']['custom_params']["key2"] = "222"
    data[0]['event_info']['custom_params']["key3"] = "333"
    data[0]['event_info']['custom_params']["key4"] = "444"
    data[0]['event_info']['custom_params']["key5"] = "555"
    data[0]['event_info']['custom_params']["key6"] = "222"
    data[0]['event_info']['custom_params']["key7"] = "222"
    data[0]['event_info']['custom_params']["key8"] = "222"
    data[0]['event_info']['custom_params']["key9"] = "222"
    data[0]['event_info']['custom_params']["key10"] = "222"
    data[0]['event_info']['custom_params']["key11"] = "222"
    response = send_request()
    assert response["status"] == "162"


# 事件自定义参数嵌套，内含参数等于10项
def test_custom_params3():
    data[0]['event_info']['custom_params']["key1"] = "111"
    data[0]['event_info']['custom_params']["key2"] = "222"
    data[0]['event_info']['custom_params']["key3"] = "333"
    data[0]['event_info']['custom_params']["key4"] = "444"
    data[0]['event_info']['custom_params']["key5"] = "555"
    data[0]['event_info']['custom_params']["key6"] = "222"
    data[0]['event_info']['custom_params']["key7"] = "222"
    data[0]['event_info']['custom_params']["key8"] = "222"
    data[0]['event_info']['custom_params']["key9"] = "222"
    data[0]['event_info']['custom_params']["key10"] = "222"
    response = send_request()
    assert response["status"] == "0"


# def test_pl():
#     for index in range(1000):
#         newlist = ['install', 'startup', 'register', 'login', 'order', 'purchase', 'adclick']
#         for event in newlist:
#             data[0]["event_info"]['event_data']['ad_price_currency_type'] = 'CNY'
#             data[0]['event_info']['event_name'] = event
#             response = send_request()
#         assert response["status"] == "0"

# country为空
def test_country1():
    data[0]['timestamp_info']['country'] = ''
    response = send_request()
    assert response["status"] == "216"


# country为16个字符
def test_country2():
    data[0]['timestamp_info']['country'] = code_nums(16)
    response = send_request()
    assert response["status"] == "0"


# country为17个字符
def test_country3():
    data[0]['timestamp_info']['country'] = code_nums(17)
    response = send_request()
    assert response["status"] == "216"


# country包含特殊字符
def test_country4():
    data[0]['timestamp_info']['country'] = '312@！#@！三大程'
    response = send_request()
    assert response["status"] == "0"


# language为空
def test_language1():
    data[0]['device_info']['language'] = ''
    response = send_request()
    assert response["status"] == "0"


# language为32字符
def test_language2():
    data[0]['device_info']['language'] = code_nums2(32)
    response = send_request()
    assert response["status"] == "0"


# language为33字符
def test_language3():
    data[0]['device_info']['language'] = code_nums2(33)
    response = send_request()
    assert response["status"] == "217"


# language包含中文
def test_language4():
    data[0]['device_info']['language'] = '测试测试语言'
    response = send_request()
    assert response["status"] == "0"


# language包含特殊字符
def test_language5():
    data[0]['device_info']['language'] = '测试测试语@#¥言'
    response = send_request()
    assert response["status"] == "0"


# device_type为空
def test_device_type1():
    data[0]['device_info']['device_type'] = ''
    response = send_request()
    assert response["status"] == "0"


# device_type为16字符
def test_device_type2():
    data[0]['device_info']['device_type'] = code_nums2(16)
    response = send_request()
    assert response["status"] == "0"


# device_type为17字符
def test_device_type3():
    data[0]['device_info']['device_type'] = code_nums2(17)
    response = send_request()
    assert response["status"] == "218"


# device_type包含中文
def test_device_type4():
    data[0]['device_info']['device_type'] = '测试测试语言'
    response = send_request()
    assert response["status"] == "0"


# device_type包含特殊字符
def test_device_type5():
    data[0]['device_info']['device_type'] = '测试测试语@#¥言'
    response = send_request()
    assert response["status"] == "0"


# device_type为15字符
def test_device_type6():
    data[0]['device_info']['device_type'] = code_nums2(15)
    response = send_request()
    assert response["status"] == "0"


# device_type为15字符
def test_device_type6():
    data[0]['device_info']['device_type'] = code_nums2(15)
    response = send_request()
    assert response["status"] == "0"


# ad_id为空
def test_ad_id1():
    data[0]['event_info']['event_data']['ad_id'] = ''
    response = send_request()
    assert response["status"] == "0"


# ad_id为100字符
def test_ad_id2():
    data[0]['event_info']['event_data']['ad_id'] = code_nums2(100)
    response = send_request()
    assert response["status"] == "0"


# ad_id包含特殊字符和汉字
def test_ad_id3():
    data[0]['event_info']['event_data']['ad_id'] = '测试#@#'
    response = send_request()
    assert response["status"] == "0"


# ad_appid为空
def test_ad_appid1():
    data[0]['event_info']['event_data']['ad_appid'] = ''
    response = send_request()
    assert response["status"] == "0"


# ad_appid为100字符
def test_ad_appid2():
    data[0]['event_info']['event_data']['ad_appid'] = code_nums2(100)
    response = send_request()
    assert response["status"] == "0"


# ad_appid包含特殊字符和汉字
def test_ad_appid3():
    data[0]['event_info']['event_data']['ad_appid'] = '测试#@#'
    response = send_request()
    assert response["status"] == "0"



# product_name为空
def test_product_name1():
    data[0]['event_info']['event_data']['product_name'] = ''
    response = send_request()
    assert response["status"] == "0"


# product_name为100字符
def test_product_name2():
    data[0]['event_info']['event_data']['product_name'] = code_nums2(100)
    response = send_request()
    assert response["status"] == "0"


# product_name包含特殊字符和汉字
def test_product_name3():
    data[0]['event_info']['event_data']['product_name'] = '测试#@_+#'
    response = send_request()
    assert response["status"] == "0"





# product_id为空
def test_product_id1():
    data[0]['event_info']['event_data']['product_id'] = ''
    response = send_request()
    assert response["status"] == "0"


# product_id为100字符
def test_product_id2():
    data[0]['event_info']['event_data']['product_id'] = code_nums2(100)
    response = send_request()
    assert response["status"] == "0"


# product_id包含特殊字符和汉字
def test_product_id3():
    data[0]['event_info']['event_data']['product_id'] = '测试#@_+#'
    response = send_request()
    assert response["status"] == "0"


# product_num为空
def test_product_num1():
    data[0]['event_info']['event_data']['product_num'] = ''
    response = send_request()
    assert response["status"] == "0"


# product_num为100字符
def test_product_num2():
    data[0]['event_info']['event_data']['product_num'] = code_nums2(100)
    response = send_request()
    assert response["status"] == "0"


# product_num包含特殊字符和汉字
def test_product_num3():
    data[0]['event_info']['event_data']['product_num'] = '测试#@_+#'
    response = send_request()
    assert response["status"] == "0"

# product_num为number类型
def test_product_num4():
    data[0]['event_info']['event_data']['product_num'] = 232
    response = send_request()
    assert response["status"] == "0"




# bid_type为空
def test_bid_type1():
    data[0]['event_info']['event_data']['bid_type'] = ''
    response = send_request()
    assert response["status"] == "0"


# bid_type为100字符
def test_bid_type2():
    data[0]['event_info']['event_data']['bid_type'] = code_nums2(100)
    response = send_request()
    assert response["status"] == "0"


# bid_type包含特殊字符和汉字
def test_bid_type3():
    data[0]['event_info']['event_data']['bid_type'] = '测试#@_+#'
    data[0]["collector_info"]["integration_type"] = "s2s"
    # response = send_request()
    response = send_requests2s()
    assert response["status"] == "0"




if __name__ == '__main__':
    pytest.main()
