import requests
import json
import pytest
import time
import random

# url = "http://tkiomicro-receive-788931749.cn-north-1.elb.amazonaws.com.cn/receive/tkiov2/sdk"

chaochang = '543214223221321321312131313133132131232131232132132543214223221321321312131313133132131232131232132132543214223221321321312131313133132131232131232132132'

headers = {
    'Content-Type': 'application/json'
}
# 生成小写字母加数字组合
n = 10
def code_nums1(n=6):
    ret = ''
    for i in range(n):
        num = random.randint(0, 9)
        letter = chr(random.randint(97, 122))
        s = str(random.choice([num, letter]))
        ret += s
    return ret


# 生成数字组合
n = 10
def code_nums2(n=6):
    ret = ''
    for i in range(n):
        num = random.randint(0, 9)
        s = str(random.choice([num]))
        ret += s
    return ret

global data
data = [
    {
        "application_info": {
            "appkey": "2a33891fd3ea53f8edb0fca391a2432e",
            "bundleid": "3423232",
            "app_version": "1.9.0",
            "channel_name": "default"
        },
        "timestamp_info": {
            "country": "chi",
            "time_zone": "GMT+08",
            "install_time": int(round(time.time() * 1000)),
            "current_event_time": int(round(time.time() * 1000)),
            "report_time": int(round(time.time() * 1000)),
        },
        "collector_info": {
            "integration_type": "sdk",
            "collector_version": "1.8.4",
            "retried_times": ""
        },
        "device_info": {
            "ryid": "8e4888e488a40a17aed2f6752f51382a4eafc",
            "device_id": "c3381276ae145b3663c8e0f6dd9f628a",
            "device_id_type": "idfa_md5",
            "device_id_md5": "c3381276ae145b3663c8e0f6dd9f628a",
            "device_id_md5_type": "idfa_md5",
            "os": "2",
            "os_version": "19",
            "manufacturer": "HUAWEI",
            "model": "Mate 40",
            # "ipv4": "",
            "ipv6": "1.1.1",
            "ua": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.54 Safari/537.36",
            "att_status": "unknown",
            "lat_status": "disable",
            "idfa": "3DEA635F-B24F-434B-833F-4ED028FEAEEF",
            "idfa_md5": "c3381276ae145b3663c8e0f6dd9f628a",
            "idfv": "3DEA635F-B24F-434B-833F-4ED028FEAEEF",
            "idfv_md5": "c3381276ae145b3663c8e0f6dd9f628a",

        },
        "event_info": {
            "event_name": "install",
            "event_type": "preset",
            "event_data": {
                "user_id": "guest123",
                "register_type": "WeChat",
                "login_type": "Wechat",
                "order_id": "2341242342676398724",
                "order_amount": "343432",
                "currency_type": "CNY",
                "purchase_type": "Alipay",
                "ad_platform": "csj",
                "placement_type": "interstitial",
                "placement_id": "23425334",
                "ad_price": "4.34",
                "ad_price_currency_type": "CNY",
                "is_rendered": "1"
            },
            "custom_params": {
                # "add_cart": "234234",
                # "sku": "234234",
                # "level_up": "234234",
                # "refund": "234234",
                # "refund_amount": "234234"
            }
        },
        "asa_info": {
            "iad_info": {
                # //iad归因结果。选传，限制16字符内。
                "iad-attribution": "",
                # //iad 活动组名称。选传，限制128字符内。
                "iad-org-name": "org name",
                # //iad 活动组id，选传。限制32字符内。
                "iad-org-id": "",
                # //iad 活动id，选传。限制32字符内。
                "iad-campaign-id": "542370539",
                # // iad 活动名称。选传，限制128字符内。
                "iad-campaign-name": "campaign name",
                # //iad 该Apple账号首次购买（下载）该App的时间。选传，限制32字符内。
                "iad-purchase-date": "2020-08-04T17:18:07Z",
                # //iad 该Apple账号本次转化（下载）该App的时间。选传，限制32字符内。
                "iad-conversion-date": "2020-08-04T17:18:07Z",
                # //iad 转化配型。选传，限制32字符内。
                "iad-conversion-type": "newdownload",
                # //iad 本次转化匹配到广告点击的时间。选传，限制32字符内。
                "iad-click-date": "2020-08-04T17:17:00Z",
                # // iad 广告组id。选传，限制32字符内。
                "iad-adgroup-id": "542317095",
                # //iad 广告组名称。选传，限制128字符内。
                "iad-adgroup-name": "adgroup name",
                # //iad Apple账号的国家或地区。选传，限制16字符内。
                "iad-country-or-region": "US",
                # //iad 关键词名称。选传，限制128字符内。
                "iad-keyword": "keyword",
                # //iad 关键词id。选传，限制32字符内。
                "iad-keyword-id": "87675432",
                # //iad 关键词匹配类型。选传，限制32字符内。
                "iad-keyword-matchtype": "Broad",
                # //iad 广告素材id。选传，限制32字符内。
                "iad-ad-id": "542317136",
                # //iad lineitem id。选传，限制32字符内。
                "iad-lineitem-id": "587848614",
                # //iad lineitem名称。选传，限制128字符内。
                "iad-lineitem-name": "Brand-Exact_All-All_Test02",
                # //通过iad框架获取归因信息时的重试次数。选传，限制2字符内。
                "iad_retry_times": 3,
                # //任何能够描述未能获取到归因结果的错误提示。选传，无字符限制。
                "iad_error_info": "xxx"
            },
            "adservices_info": {
                "token": "",
                "adservices_retry_times": 3,
                "adservices_error_info": "xxx"
            }
        }
    }
]
data_temp = json.dumps(data)


def send_request():
    global data
    # 对接se地址
    # url = 'http://tmtest-se.trackingio.com/receive/tkiov2/sdk'
    # 测试
    url = "http://tmtest.trackingio.com/receive/tkiov2/sdk"
    # 线上
    # url = "http://tkio-receive.solar-engine.com/receive/tkiov2/sdk"

    data[0]['timestamp_info']['install_time'] = int(round(time.time() * 1000))
    data[0]['timestamp_info']['current_event_time'] = int(round(time.time() * 1000))
    print(data)
    response = requests.request("POST", url, headers=headers, data=json.dumps(data))
    print(response.text)
    # 全局data
    data = json.loads(data_temp)
    response = json.loads(response.text)
    s = str(response["status"])
    response["status"] = s
    return response


def send_request2():
    global data
    url = "http://tkiomicro-receive-788931749.cn-north-1.elb.amazonaws.com.cn/receive/tkiov2/s2s"
    # 线上
    url = "http://tkio-receive.solar-engine.com/receive/tkiov2/s2s"
    data[0]['timestamp_info']['install_time'] = int(round(time.time() * 1000))
    data[0]['timestamp_info']['current_event_time'] = int(round(time.time() * 1000))
    # print(data)
    response = requests.request("POST", url, headers=headers, data=json.dumps(data))
    print(response.text)
    # 全局data
    data = json.loads(data_temp)
    response = json.loads(response.text)
    s = str(response["status"])
    response["status"] = s
    return response




# iad_retry_times为num型，应该返回214，但是实时接收时接收到的是string类型，无法判断number
def test_se1():
    data[0]["asa_info"]["iad_info"]['iad_retry_times'] = 3
    response = send_request()
    assert response["status"] == "0"


# iad_retry_times为num型，同上test_se1
def test_se2():
    data[0]["asa_info"]["adservices_info"]['adservices_retry_times'] = 3
    response = send_request()
    assert response["status"] == "0"


# os为ios,channel_name不等于default
def test_os_ios():
    data[0]["device_info"]["os"] = 'ios'
    data[0]['application_info']['channel_name'] = 'xiaomi'
    response = send_request()
    assert response["status"] == "104"


# os为大写iOS
def test_os_ios():
    data[0]["device_info"]["os"] = 'iOS'
    response = send_request()
    assert response["status"] == "115"


# ATT框架启用状态,为固定值
def test_att_status1():
    lis = ['denied', 'restricted', 'authorized', 'unknown']
    for astatus in lis:
        data[0]['device_info']['att_status'] = astatus
        response = send_request()
        assert response["status"] == "0"


# ATT框架启用状态,为其他值
def test_att_status2():
    data[0]['device_info']['att_status'] = "aaa"
    response = send_request()
    assert response["status"] == "122"


# ATT框架启用状态,为空
def test_att_status3():
    data[0]['device_info']['att_status'] = ""
    response = send_request()
    assert response["status"] == "0"


# LAT启用状态，固定值
def test_lat_status1():
    lis = ['enable', 'disable', 'unknown']
    for astatus in lis:
        data[0]['device_info']['lat_status'] = astatus
        response = send_request()
        assert response["status"] == "0"


# LAT启用状态，其他值
def test_lat_status2():
    data[0]['device_info']['lat_status'] = "aaa"
    response = send_request()
    assert response["status"] == "123"


# LAT启用状态，空
def test_lat_status3():
    data[0]['device_info']['lat_status'] = ""
    response = send_request()
    assert response["status"] == "0"


# idfa为空，idfa_md5不为空
def test_idfa1():
    data[0]['device_info']['idfa'] = ''
    response = send_request()
    assert response["status"] == "0"


# idfa超长
def test_idfa2():
    data[0]['device_info']['idfa'] = chaochang
    response = send_request()
    assert response["status"] == "124"


# idfa为空，idfa_md5也为空
def test_idfa3():
    data[0]['device_info']['idfa'] = ''
    data[0]['device_info']['idfa_md5'] = ''
    response = send_request()
    assert response["status"] == "124"


# idfa不为空，idfa_md5为空
def test_idfa_md51():
    data[0]['device_info']['idfa_md5'] = ''
    response = send_request()
    assert response["status"] == "0"


# idfa_md5超长
def test_idfa_md52():
    data[0]['device_info']['idfa_md5'] = chaochang
    response = send_request()
    assert response["status"] == "124"


# device_id与device_id_type不一致
def test_device_id():
    data[0]['device_info']['device_id_type'] = "idfa"
    data[0]['device_info']['device_id'] = "c3381276ae145b3663c8e0f6dd9f628a"
    data[0]['device_info']['idfa_md5'] = "c3381276ae145b3663c8e0f6dd9f628a"
    response = send_request()
    assert response["status"] == "0"


# idfv为空，idfv_md5不为空
def test_idfv1():
    data[0]['device_info']['idfv'] = ''
    response = send_request()
    assert response["status"] == "0"


# idfv超长
def test_idfv2():
    data[0]['device_info']['idfv'] = chaochang
    response = send_request()
    assert response["status"] == "125"


# idfv为空，idfv_md5也为空
def test_idfv3():
    data[0]['device_info']['idfv'] = ''
    data[0]['device_info']['idfv_md5'] = ''
    response = send_request()
    assert response["status"] == "125"


# idfv不为空，idfv_md5为空
def test_idfv_md51():
    data[0]['device_info']['idfv_md5'] = ''
    response = send_request()
    assert response["status"] == "0"


# idfv_md5超长
def test_idfv_md52():
    data[0]['device_info']['idfv_md5'] = chaochang
    response = send_request()
    assert response["status"] == "125"


# asa_info为空
def test_asa_info1():
    data[0]['asa_info'] = ''
    response = send_request()
    assert response["status"] == "0"


# iad-attribution为空
def test_iad_attribution1():
    data[0]['asa_info']['iad_info']['iad-attribution'] = ''
    response = send_request()
    assert response["status"] == "0"


# iad-attribution为16字符
def test_iad_attribution2():
    data[0]['asa_info']['iad_info']['iad-attribution'] = code_nums1(16)
    response = send_request()
    assert response["status"] == "0"


# iad-attribution为17个字符
def test_iad_attribution3():
    data[0]['asa_info']['iad_info']['iad-attribution'] = code_nums1(17)
    response = send_request()
    assert response["status"] == "196"


# iad-attribution为1个字符
def test_iad_attribution4():
    data[0]['asa_info']['iad_info']['iad-attribution'] = code_nums1(1)
    response = send_request()
    assert response["status"] == "0"


# iad-attribution为特殊字符和中文组合
def test_iad_attribution5():
    data[0]['asa_info']['iad_info']['iad-attribution'] = "@# ¥%测试一下"
    response = send_request()
    assert response["status"] == "0"









# iad-org-name为空
def test_iad_org_name1():
    data[0]['asa_info']['iad_info']['iad-org-name'] = ''
    response = send_request()
    assert response["status"] == "0"


# iad-org-name为128字符
def test_iad_org_name2():
    data[0]['asa_info']['iad_info']['ad-org-name'] = code_nums1(128)
    response = send_request()
    assert response["status"] == "0"


# iad-org-name为129个字符
def test_iad_org_name3():
    data[0]['asa_info']['iad_info']['iad-org-name'] = code_nums1(129)
    response = send_request()
    assert response["status"] == "197"




# iad-org-name为特殊字符和中文组合
def test_iad_org_name4():
    data[0]['asa_info']['iad_info']['iad-org-name'] = "@# ¥%测试一下"
    response = send_request()
    assert response["status"] == "0"













# iad-org-id为空
def test_iad_org_id1():
    data[0]['asa_info']['iad_info']['iad-org-id'] = ''
    response = send_request()
    assert response["status"] == "0"


# iad-org-id为32字符
def test_iad_org_id2():
    data[0]['asa_info']['iad_info']['ad-org-id'] = code_nums1(32)
    response = send_request()
    assert response["status"] == "0"


# iad-org-id为33个字符
def test_iad_org_id3():
    data[0]['asa_info']['iad_info']['iad-org-id'] = code_nums1(33)
    response = send_request()
    assert response["status"] == "198"




# iad-org-id为特殊字符和中文组合
def test_iad_org_id4():
    data[0]['asa_info']['iad_info']['iad-org-id'] = "@# ¥%测试一下"
    response = send_request()
    assert response["status"] == "0"















# iad-campaign-id为空
def test_iad_campaign_id1():
    data[0]['asa_info']['iad_info']['iad-campaign-id'] = ''
    response = send_request()
    assert response["status"] == "0"


# iad-campaign-id为32字符
def test_iad_campaign_id2():
    data[0]['asa_info']['iad_info']['iad-campaign-id'] = code_nums1(32)
    response = send_request()
    assert response["status"] == "0"


# iad-campaign-id为33个字符
def test_iad_campaign_id3():
    data[0]['asa_info']['iad_info']['iad-campaign-id'] = code_nums1(33)
    response = send_request()
    assert response["status"] == "199"




# iad-campaign-id为特殊字符和中文组合
def test_iad_campaign_id4():
    data[0]['asa_info']['iad_info']['iad-campaign-id'] = "@# ¥%测试一下"
    response = send_request()
    assert response["status"] == "0"








# iad_campaign_name为空
def test_iad_campaign_name1():
    data[0]['asa_info']['iad_info']['iad-campaign-name'] = ''
    response = send_request()
    assert response["status"] == "0"


# iad_campaign_name为128字符
def test_iad_campaign_name2():
    data[0]['asa_info']['iad_info']['iad-campaign-name'] = code_nums1(128)
    response = send_request()
    assert response["status"] == "0"


# iad_campaign_name为129个字符
def test_iad_campaign_name3():
    data[0]['asa_info']['iad_info']['iad-campaign-name'] = code_nums1(129)
    response = send_request()
    assert response["status"] == "200"




# iad_campaign_name为特殊字符和中文组合
def test_iad_campaign_name4():
    data[0]['asa_info']['iad_info']['iad-campaign-name'] = "@# ¥%测试一下"
    response = send_request()
    assert response["status"] == "0"


















# iad_purchase-date为空
def test_iad_purchase_date1():
    data[0]['asa_info']['iad_info']['iad-purchase-date'] = ''
    response = send_request()
    assert response["status"] == "0"


# iad_purchase-date为32字符
def test_iad_purchase_date2():
    data[0]['asa_info']['iad_info']['iad-purchase-date'] = code_nums1(32)
    response = send_request()
    assert response["status"] == "0"


# iad_purchase-date为33个字符
def test_iad_purchase_date3():
    data[0]['asa_info']['iad_info']['iad-purchase-date'] = code_nums1(33)
    response = send_request()
    assert response["status"] == "201"




# iad_purchase-date为特殊字符和中文组合
def test_iad_purchase_date4():
    data[0]['asa_info']['iad_info']['iad-purchase-date'] = "@# ¥%测试一下"
    response = send_request()
    assert response["status"] == "0"


# iad_purchase-date为标准格式
def test_iad_purchase_date5():
    data[0]['asa_info']['iad_info']['iad-purchase-date'] = "2020-08-04T17:18:07Z"
    response = send_request()
    assert response["status"] == "0"















# iad_conversion-date为空
def test_iad_conversion_date1():
    data[0]['asa_info']['iad_info']['iad-conversion-date'] = ''
    response = send_request()
    assert response["status"] == "0"


# iad_conversion-date为32字符
def test_iad_conversion_date2():
    data[0]['asa_info']['iad_info']['iad-conversion-date'] = code_nums1(32)
    response = send_request()
    assert response["status"] == "0"


# iad_conversion-date为33个字符
def test_iad_conversion_date3():
    data[0]['asa_info']['iad_info']['iad-conversion-date'] = code_nums1(33)
    response = send_request()
    assert response["status"] == "202"




# iad_conversion-date为特殊字符和中文组合
def test_iad_conversion_date4():
    data[0]['asa_info']['iad_info']['iad-conversion-date'] = "@# ¥%测试一下"
    response = send_request()
    assert response["status"] == "0"


# iad_conversion-date为标准格式
def test_iad_conversion_date5():
    data[0]['asa_info']['iad_info']['iad-conversion-date'] = "2020-08-04T17:18:07Z"
    response = send_request()
    assert response["status"] == "0"




# iad_conversion-type为空
def test_iad_conversion_type1():
    data[0]['asa_info']['iad_info']['iad-conversion-type'] = ''
    response = send_request()
    assert response["status"] == "0"


# iad_conversion-type为32字符
def test_iad_conversion_type2():
    data[0]['asa_info']['iad_info']['iad-conversion-type'] = code_nums1(32)
    response = send_request()
    assert response["status"] == "0"


# iad_conversion-type为33个字符
def test_iad_conversion_type3():
    data[0]['asa_info']['iad_info']['iad-conversion-type'] = code_nums1(33)
    response = send_request()
    assert response["status"] == "203"




# iad_conversion-type为特殊字符和中文组合
def test_iad_conversion_type4():
    data[0]['asa_info']['iad_info']['iad-conversion-type'] = "@# ¥%测试一下"
    response = send_request()
    assert response["status"] == "0"


# iad_conversion-type为标准格式
def test_iad_conversion_type5():
    data[0]['asa_info']['iad_info']['iad-conversion-type'] = "2020-08-04T17:18:07Z"
    response = send_request()
    assert response["status"] == "0"



# iad_click-date为空
def test_iad_click_date1():
    data[0]['asa_info']['iad_info']['iad-click-date'] = ''
    response = send_request()
    assert response["status"] == "0"


# iad_click-date为32字符
def test_iad_click_date2():
    data[0]['asa_info']['iad_info']['iad-click-date'] = code_nums1(32)
    response = send_request()
    assert response["status"] == "0"


# iad_click-date为33个字符
def test_iad_click_date3():
    data[0]['asa_info']['iad_info']['iad-click-date'] = code_nums1(33)
    response = send_request()
    assert response["status"] == "204"




# iad_click-date为特殊字符和中文组合
def test_iad_click_date4():
    data[0]['asa_info']['iad_info']['iad-click-date'] = "@# ¥%测试一下"
    response = send_request()
    assert response["status"] == "0"


# iad_click-date为标准格式
def test_iad_click_date5():
    data[0]['asa_info']['iad_info']['iad-click-date'] = "2020-08-04T17:18:07Z"
    response = send_request()
    assert response["status"] == "0"




# iad_adgroup-id为空
def test_iad_adgroup_id1():
    data[0]['asa_info']['iad_info']['iad-adgroup-id'] = ''
    response = send_request()
    assert response["status"] == "0"


# iad_adgroup-id为32字符
def test_iad_adgroup_id2():
    data[0]['asa_info']['iad_info']['iad-adgroup-id'] = code_nums1(32)
    response = send_request()
    assert response["status"] == "0"


# iad_adgroup-id为33个字符
def test_iad_adgroup_id3():
    data[0]['asa_info']['iad_info']['iad-adgroup-id'] = code_nums1(33)
    response = send_request()
    assert response["status"] == "205"




# iad_adgroup-id为特殊字符和中文组合
def test_iad_adgroup_id4():
    data[0]['asa_info']['iad_info']['iad-adgroup-id'] = "@# ¥%测试一下"
    response = send_request()
    assert response["status"] == "0"



# iad_adgroup-name为空
def test_iad_adgroup_name1():
    data[0]['asa_info']['iad_info']['iad-adgroup-name'] = ''
    response = send_request()
    assert response["status"] == "0"


# iad_adgroup-name为128字符
def test_iad_adgroup_name2():
    data[0]['asa_info']['iad_info']['iad-adgroup-name'] = code_nums1(128)
    response = send_request()
    assert response["status"] == "0"


# iad_adgroup-name为129个字符
def test_iad_adgroup_name3():
    data[0]['asa_info']['iad_info']['iad-adgroup-name'] = code_nums1(129)
    response = send_request()
    assert response["status"] == "206"




# iad_adgroup-name为特殊字符和中文组合
def test_iad_adgroup_name4():
    data[0]['asa_info']['iad_info']['iad-adgroup-name'] = "@# ¥%测试一下"
    response = send_request()
    assert response["status"] == "0"





# iad-country-or-region为空
def test_iad_country_or_region1():
    data[0]['asa_info']['iad_info']['iad-country-or-region'] = ''
    response = send_request()
    assert response["status"] == "0"


# iad-country-or-region为16字符
def test_iad_country_or_region2():
    data[0]['asa_info']['iad_info']['iad-country-or-region'] = code_nums1(16)
    response = send_request()
    assert response["status"] == "0"


# iad-country-or-region为17个字符
def test_iad_country_or_region3():
    data[0]['asa_info']['iad_info']['iad-country-or-region'] = code_nums1(17)
    response = send_request()
    assert response["status"] == "207"




# iad-country-or-region为特殊字符和中文组合
def test_iad_country_or_region4():
    data[0]['asa_info']['iad_info']['iad-country-or-region'] = "@# ¥%测试一下"
    response = send_request()
    assert response["status"] == "0"



# iad-keyword为空
def test_iad_keyword1():
    data[0]['asa_info']['iad_info']['iad-keyword'] = ''
    response = send_request()
    assert response["status"] == "0"


# iad-keyword为128字符
def test_iad_keyword2():
    data[0]['asa_info']['iad_info']['iad-keyword'] = code_nums1(128)
    response = send_request()
    assert response["status"] == "0"


# iad-keyword为129个字符
def test_iad_keyword3():
    data[0]['asa_info']['iad_info']['iad-keyword'] = code_nums1(129)
    response = send_request()
    assert response["status"] == "208"




# iad-keyword为特殊字符和中文组合
def test_iad_keyword4():
    data[0]['asa_info']['iad_info']['iad-keyword'] = "@# ¥%测试一下"
    response = send_request()
    assert response["status"] == "0"




# iad-keyword-id为空
def test_iad_keyword_id1():
    data[0]['asa_info']['iad_info']['iad-keyword-id'] = ''
    response = send_request()
    assert response["status"] == "0"


# iad-keyword-id为32字符
def test_iad_keyword_id2():
    data[0]['asa_info']['iad_info']['iad-keyword-id'] = code_nums1(32)
    response = send_request()
    assert response["status"] == "0"


# iad-keyword-id为33个字符
def test_iad_keyword_id3():
    data[0]['asa_info']['iad_info']['iad-keyword-id'] = code_nums1(33)
    response = send_request()
    assert response["status"] == "209"




# iad-keyword-id为特殊字符和中文组合
def test_iad_keyword_id4():
    data[0]['asa_info']['iad_info']['iad-keyword-id'] = "@# ¥%测试一下"
    response = send_request()
    assert response["status"] == "0"



# iad-keyword-matchtype为空
def test_iad_keyword_matchtype1():
    data[0]['asa_info']['iad_info']['iad-keyword-matchtype'] = ''
    response = send_request()
    assert response["status"] == "0"


# iad-keyword-matchtype为32字符
def test_iad_keyword_matchtype2():
    data[0]['asa_info']['iad_info']['iad-keyword-matchtype'] = code_nums1(32)
    response = send_request()
    assert response["status"] == "0"


# iad-keyword-matchtype为33个字符
def test_iad_keyword_matchtype3():
    data[0]['asa_info']['iad_info']['iad-keyword-matchtype'] = code_nums1(33)
    response = send_request()
    assert response["status"] == "210"




# iad-keyword-matchtype为特殊字符和中文组合
def test_iad_keyword_matchtype4():
    data[0]['asa_info']['iad_info']['iad-keyword-matchtype'] = "@# ¥%测试一下"
    response = send_request()
    assert response["status"] == "0"



# iad-ad-id为空
def test_iad_ad_id1():
    data[0]['asa_info']['iad_info']['iad-ad-id'] = ''
    response = send_request()
    assert response["status"] == "0"


# iad-ad-id为32字符
def test_iad_ad_id2():
    data[0]['asa_info']['iad_info']['iad-ad-id'] = code_nums1(32)
    response = send_request()
    assert response["status"] == "0"


# iad-ad-id为33个字符
def test_iad_ad_id3():
    data[0]['asa_info']['iad_info']['iad-ad-id'] = code_nums1(33)
    response = send_request()
    assert response["status"] == "211"




# iad-ad-id为特殊字符和中文组合
def test_iad_ad_id4():
    data[0]['asa_info']['iad_info']['iad-ad-id'] = "@# ¥%测试一下"
    response = send_request()
    assert response["status"] == "0"


# iad-lineitem-id为空
def test_iad_lineitem_id1():
    data[0]['asa_info']['iad_info']['iad-lineitem-id'] = ''
    response = send_request()
    assert response["status"] == "0"


# iad-lineitem-id为32字符
def test_iad_lineitem_id2():
    data[0]['asa_info']['iad_info']['iad-lineitem-id'] = code_nums1(32)
    response = send_request()
    assert response["status"] == "0"


# iad-lineitem-id为33个字符
def test_iad_lineitem_id3():
    data[0]['asa_info']['iad_info']['iad-lineitem-id'] = code_nums1(33)
    response = send_request()
    assert response["status"] == "212"




# iad-lineitem-id为特殊字符和中文组合
def test_iad_lineitem_id4():
    data[0]['asa_info']['iad_info']['iad-lineitem-id'] = "@# ¥%测-试一下"
    response = send_request()
    assert response["status"] == "0"



# iad-lineitem-name为空
def test_iad_lineitem_name1():
    data[0]['asa_info']['iad_info']['iad-lineitem-name'] = ''
    response = send_request()
    assert response["status"] == "0"


# iad-lineitem-name为128字符
def test_iad_lineitem_name2():
    data[0]['asa_info']['iad_info']['iad-lineitem-name'] = code_nums1(128)
    response = send_request()
    assert response["status"] == "0"


# iad-lineitem-name为129个字符
def test_iad_lineitem_name3():
    data[0]['asa_info']['iad_info']['iad-lineitem-name'] = code_nums1(129)
    response = send_request()
    assert response["status"] == "213"




# iad-lineitem-name为特殊字符和中文组合
def test_iad_lineitem_name4():
    data[0]['asa_info']['iad_info']['iad-lineitem-name'] = "@# ¥%测试一下"
    response = send_request()
    assert response["status"] == "0"



# iad_retry_times为空
def test_iad_retry_times1():
    data[0]['asa_info']['iad_info']['iad_retry_times'] = ''
    response = send_request()
    assert response["status"] == "0"


# iad_retry_times为2字符
def test_iad_retry_times2():
    data[0]['asa_info']['iad_info']['iad_retry_times'] = code_nums2(2)
    response = send_request()
    assert response["status"] == "0"


# iad_retry_times为3个字符
def test_iad_retry_times3():
    data[0]['asa_info']['iad_info']['iad_retry_times'] = code_nums2(3)
    response = send_request()
    assert response["status"] == "214"




# iad_retry_times为特殊字符
def test_iad_retry_times4():
    data[0]['asa_info']['iad_info']['iad_retry_times'] = "@"
    response = send_request()
    assert response["status"] == "0"



# iad_retry_times为中文
def test_iad_retry_times5():
    data[0]['asa_info']['iad_info']['iad_retry_times'] = "测"
    response = send_request()
    assert response["status"] == "0"




# iad_error_info为空
def test_iad_error_info1():
    data[0]['asa_info']['iad_info']['iad_error_info'] = ''
    response = send_request()
    assert response["status"] == "0"


# iad_error_info为1000字符
def test_iad_error_info2():
    data[0]['asa_info']['iad_info']['iad_error_info'] = code_nums1(1000)
    response = send_request()
    assert response["status"] == "0"




# iad_error_info为特殊字符和中文组合
def test_iad_error_info4():
    data[0]['asa_info']['iad_info']['iad_error_info'] = "@# ¥%测试一下"
    response = send_request()
    assert response["status"] == "0"



# token为空
def test_token1():
    data[0]['asa_info']['adservices_info']['token'] = ""
    response = send_request()
    assert response["status"] == "0"


# token为正常值
def test_token2():
    data[0]['asa_info']['adservices_info']['token'] = "k+q1PtvKksjrtMbqONmlPeOztkXqSJ1xqux9EFXvZUAhY5R8szPkUwKOf0nc4d84FvRKY9LZ+3ncRBXuDeFmrtq+WbkEWxgTXwAAAVADAAAA9gAAAIBv7KMoc3AHIi4QyzGWI67z4cAqk9IocPPaAQXHcyM9OVtdMCcg6b0m8EI+27BKknAWOUA9ZoUiQ0vuERiCWWW7tzOZ5pgcnuoYzn18jnlTTTtisEHhw/JLBHg6c8aR/I/mBk11+iMdEAZvQZ68aKwzI3rmmI3Kz/5h9zcZHTphIQAAABV3tAsFnsbMHeC7RT7ymgRtJ+1KiWgAAACfAfzmGF1G6TvapSaorph2MlE1rj/2AAAAhgUFMRHeByS1h0HmhTUPcsgZFWKLpvkZJBORRTKgdLTblWSAdj9yeJ0J/vgK15qBW4eOJELfVGrSBCclb5aqqCNUlhf9a35XXX21822C+FznX7zSfbcB/eOfeyAykz61bLPLjbsw0ZADMUgh+HvAOB6BTypPqinj8+kEYGQsu3tnqC4ZmIudAAAAAAAAAAAAAAABBEUNAAA="
    response = send_request()
    assert response["status"] == "0"


# adservices_retry_times为空
def test_adservices_retry_times1():
    data[0]['asa_info']['adservices_info']['adservices_retry_times'] = ""
    response = send_request()
    assert response["status"] == "0"


# adservices_retry_times为正number类型
def test_adservices_retry_times2():
    data[0]['asa_info']['adservices_info']['adservices_retry_times'] = 2
    response = send_request()
    assert response["status"] == "0"


# adservices_retry_times为string类型
def test_adservices_retry_times3():
    data[0]['asa_info']['adservices_info']['adservices_retry_times'] = "3"
    response = send_request()
    assert response["status"] == "0"


# adservices_retry_times为3个字符
def test_adservices_retry_times4():
    data[0]['asa_info']['adservices_info']['adservices_retry_times'] = code_nums2(3)
    response = send_request()
    assert response["status"] == "215"


# adservices_retry_times为中文和字符
def test_adservices_retry_times5():
    data[0]['asa_info']['adservices_info']['adservices_retry_times'] = '测#'
    response = send_request()
    assert response["status"] == "0"




# adservices_error_info为空
def test_adservices_error_info1():
    data[0]['asa_info']['adservices_info']['adservices_error_info'] = ''
    response = send_request()
    assert response["status"] == "0"




# adservices_error_info为1000字符
def test_adservices_error_info2():
    data[0]['asa_info']['adservices_info']['adservices_error_info'] = code_nums1(1000)
    response = send_request()
    assert response["status"] == "0"


if __name__ == '__main__':
    pytest.main()
