import requests
import json
import time
import pytest
url1 = 'http://tmtest.trackingio.com/receive/turl/3r5K1h9'
current_time_13 = int(round(time.time() * 1000))
zf35 = '54321422322132132131213133322323233'
zf130 = 'xiaomi小米小米xiaomi小米小米xiaomi小米小米xiaomi小米小米xiaomi小米小米小米xiaomi小米xiaomi小米xiaomi小米xiaomi小米xiaomi小米xiaomi'
zf128 = 'xiaomi小米小米xiaomi小米小米xiaomi小米小米xiaomi小米小米xiaomi小米小米小米xiaomi小米xiaomi小米xiaomi小米xiaomi小米xiaomi小米xiao'
zf64 = 'xiaomi小米小米xiaomi小米小米xiaomi小米小米xiaomi小米小米xiaomi小'
zf468 = '1.2.23.3.4.4232.213123.13.23.213.123.123.213.21.321.3.213.12.321.3.21.321.3.121.2.23.3.4.4232.213123.13.23.213.123.123.2131.2.23.3.4.4232.213123.13.23.213.123.123.213.21.321.3.213.12.321.3.21.321.3.121.2.23.3.4.4232.213123.13.23.213.123.123.213.21.321.3.213.12.321.3.21.321.3.121.2.23.3.4.4232.213123.13.23.213.123.123.213.21.321.3.213.12.321.3.21.321.3.12.21.321.3.213.12.321.3.21.321.3.121.2.23.3.4.4232.213123.13.23.213.123.123.213.21.321.3.213.12.321.3.21.321.3.12'
zf668 = 'Mozilla/5.0 (Linux; U; Android 7.0; zh-cn; Nexus 5X Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko)Version/4.0 Chrome/37.0.0.0 MQQBrowser/7.3 Mobile Safari/537.36Mozilla/5.0 (Linux; U; Android 7.0; zh-cn; Nexus 5X Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko)Version/4.0 Chrome/37.0.0.0 MQQBrowser/7.3 Mobile Safari/537.36Mozilla/5.0 (Linux; U; Android 7.0; zh-cn; Nexus 5X Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko)Version/4.0 Chrome/37.0.0.0 MQQBrowser/7.3 Mobile Safari/537.36Mozilla/5.0 (Linux; U; Android 7.0; zh-cn; Nexus 5X Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko)Version/4.0 Chrome/37.0.0.0 MQQBrowser/7.3 Mobile Safari/537.36'
zf256 = '测试广告组名称，广告计划名称，广告创意名称，渠道回调id，渠道回调地址等于256字符广告组名称，广告计划名称，广告创意名称，渠道回调id，渠道回调地址等于256字符广告组名称，广告计划名称，广告创意名称，渠道回调id，渠道回调地址等于256字符广告组名称，广告计划名称fff'
global parms

parms = {
    'ry_touchpoint_ts': int(round(time.time() * 1000)),
    # 触点传参时间。is_s2s=1时必传，0时选传。不同渠道有可能传多种格式，详见需求。限制32位字符内。短链传参。
    'ts': int(round(time.time() * 1000)),
    # 集成方式。is_s2s=1为服务器上报触点，0为客户端上报触点。0或1时有不同的参数非空校验，详见需求。固定为0或1。都必传
    'is_s2s': '1',
    # 操作系统。限制16字符内。都选传。短链传参。暂不与app_platform互相做校验。
    'os': 'android',
    # 设备型号。限制64字符内。都选传。短链传参。
    'model': '小米',
    # 用户公网IP v4版本。限制15字符内。is_s2s=1时都必传，0时都选传，0时优先取传参IP，未传参或传参报错时，取http header中的ip作为ipv4的值
    'ipv4': '1.1.1.1',
    # 用户公网IP v6版本。限制128字符内。都选传
    'ipv6': '1.1.1.1',
    # 用户代理信息。限制512字符内。is_s2s=1时都必传，0时都选传，0时优先取传参UA，未传参或报错时，取http header中的user agent作为ua的值
    'ua': 'Mozilla/5.0 (Linux; U; Android 7.0; zh-cn; Nexus 5X Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko)Version/4.0 Chrome/37.0.0.0 MQQBrowser/7.3 Mobile Safari/537.36',
    # Android OAID原值。限制512字符内。Android选传，app_platform=ios时报错
    'oaid': '',
    # Android OAID原值MD5后转小写。固定为32字符。Android选传，app_platform=ios时报错
    'oaid_md5': '',
    # Android主卡IMEI原值。限制32字符内。Android选传，app_platform=ios时报错
    'imei1': '',
    # Android主卡IMEI原值MD5后转小写。固定为32字符。Android选传，app_platform=ios时报错
    'imei1_md5': '',
    # Android副卡IMEI原值。限制32字符内。Android选传，app_platform=ios时报错
    'imei2': '',
    # Android副卡IMEI原值MD5后转小写。固定为32字符。Android选传，app_platform=ios时报错
    'imei2_md5': '',
    # Google Advertising ID原值。固定36字符。Android选传，app_platform=ios时报错
    'gaid': '',
    # Google Advertising ID原值MD5后转小写。固定为32字符。Android选传，app_platform=ios时报错
    'gaid_md5': '',
    # //MAC原值。固定17字符。Android选传，app_platform=ios时报错
    'mac': '',
    # MAC原值MD5后转小写。固定为32字符。Android选传，app_platform=ios时报错
    'mac_md5': '',
    # Android ID原值。固定16字符。Android选传，app_platform=ios时报错
    'android_id': '',
    # Android ID原值MD5后转小写。固定为32字符。Android选传，app_platform=ios时报错
    'android_id_md5': '',
    # 监测短链id。固定7位。
    # 'turl_id': '3r5K1h9',
    # 全部url参数。
    # 'tkul_string': 'xxx',
    # 触点类型。固定为click。都必传
    'touchpoint_type': 'click',
    # 归因类型。固定为ua（user acquirement新客获取）
    'attribution_type': 'ua',

    # 广告账户id。限制64字符内。都选传
    'account_id': '',
    # 广告组id。限制64字符内。都选传
    'adgroup_id': '',
    # 广告组名称。限制256字符内。都选传
    'adgroup_name': '',
    # 广告计划id。限制64字符内。都选传
    'adplan_id': '',
    # 广告计划名称。限制256字符内。都选传
    'adplan_name': '',
    # 广告创意id。限制128字符内。都选传
    'adcreative_id': '',
    # 广告创意名称。限制256字符内。都选传
    'adcreative_name': '',
    # 创意类型（例如大图、小图、视频等）。限制16字符内。都选传
    'adcreative_type': '',
    # 流量媒体id（例如巨量的今日头条、穿山甲、抖音等）。限制32字符内。都选传
    'site_id': '',
    # 流量媒体名称（例如巨量的今日头条、穿山甲、抖音等）。限制128字符内。都选传
    'site_name': '',
    # 广告类型（例如开屏、信息流、搜索等）。限制32字符内。都选传。
    'ad_type': '',
    # 广告位id。限制64字符内。都选传
    'placement_id': '',
    # 转化id。限制64字符内。都选传
    'conversion_id': '',
    # 广告点击id。限制64字符内。都选传
    'click_id': '',
    # 广告展示id。限制64字符内。都选传
    'impression_id': '',
    # 广告请求id。限制64字符内。都选传
    'request_id': '',
    # 渠道回调id。限制256字符。都选传
    'callback_id': 'EJiw267wvfQCGKf2g74ZIPD89-vIATAMOAFCIjIwMTkxMTI3MTQxMTEzMDEwMDI2MDc3MjE1MTUwNTczNTBIAQ==',
    # 渠道回调地址。限制256字符。都选传
    'callback_url': 'http%3A%2F%2Ftracking.e.qq.com%2Fconv%3Fcb%3DMTIzYWJjNDU2ZGVm%26conv_id%3D12345678',

    # 自定触点参数集合。都选传。
    'custom_params_1': 'null'
}
data_temp = json.dumps(parms)

# 有短链及参数要求的用该方法
def send_request(dl, cs):
    global parms
    url1 = 'http://tmtest.trackingio.com/receive/turl/' + dl + cs
    response = requests.get(url=url1, params=parms, timeout=10, verify=False)
    print(response.url)
    print(response.text)
    parms = json.loads(data_temp)
    response = json.loads(response.text)
    return response

# 302跳转时用该方法
def send_request2():
    url1 = 'http://tmtest.trackingio.com/receive/turl/QN3eQba'
    # parms['ts'] = int(round(time.time() * 1000))
    response = requests.get(url=url1, params=parms, timeout=10, verify=False)
    print(response.url)
    # response = json.loads(response.text)
    return response

# 测试归因用的方法，与其他方法区别在于ts为当前时间
def send_request3(cs):
    global parms
    # 测试
    url1 = 'http://tmtest.trackingio.com/receive/turl/QN3eQba' + cs
    # 线上
    # url1 = 'http://tkio-redirect.solar-engine.com/receive/turl/MFBfqqa' + cs
    parms['ts'] = int(round(time.time() * 1000))
    response = requests.get(url=url1, params=parms, timeout=10, verify=False)
    print(response.url)
    print(response.text)
    parms = json.loads(data_temp)
    response = json.loads(response.text)
    return response



def send_request4():
    global parms
    url1 = 'http://tmtest.trackingio.com/receive/turl/QN3eQba'
    # url1 = 'http://tkio-redirect.solar-engine.com/receive/turl/vMvqE3a'

    response = requests.get(url=url1, params=parms, timeout=10, verify=False)
    print(response.url)
    print(response.text)
    parms = json.loads(data_temp)
    response = json.loads(response.text)
    return response


# 短链错误
def test_dl():
    re = send_request('33322', '')
    assert re["status"] == 166


# 触点传参时间为正常
def test_ts9():
    parms['ts'] = current_time_13
    re = send_request4()
    assert re["status"] == 0


# 触点传参时间超过13字符
def test_ts8():
    parms['ts'] = '16462909436611321'
    re = send_request4()
    assert re["status"] == 167


# 触点传参时间等于13字符，但是包含特殊字符
def test_ts7():
    parms['ts'] = '1@46290943661'
    re = send_request4()
    assert re["status"] == 167


# 触点传参时间等于13字符，但是包含汉子
def test_ts0():
    parms['ts'] = '1测4690943661'
    re = send_request4()
    assert re["status"] == 167

# iss2s=1，ts为空
def test_ts6():
    parms['ts'] = ""
    parms['is_s2s'] = "1"
    re = send_request4()
    assert re["status"] == 167


# iss2s=0，ts为空,跳转至监测链接的landing_page_url地址
# 短链有地址时跳转至短链地址，短链无地址时，跳转至app地址
def test_ts5():
    parms['ts'] = ""
    parms['is_s2s'] = "0"
    send_request2()



# is_s2s为空，默认为0状态，跳转至监测链接的landing_page_url地址
def test_is_s2s1():
    parms['is_s2s'] = ""
    send_request2()



# is_s2s非0或者1
def test_is_s2s2():
    parms['is_s2s'] = "2"
    re = send_request4()
    assert re["status"] == 165


# 触点类型不为click
def test_touchpoint_type1():
    parms['touchpoint_type'] = 'aaa'
    re = send_request4()
    assert re["status"] == 163


# 触点类型为空
def test_touchpoint_type2():
    parms['touchpoint_type'] = ''
    re = send_request4()
    assert re["status"] == 163


# 归因类型为空
def test_attribution_type1():
    parms['attribution_type'] = ''
    re = send_request4()
    assert re["status"] == 164


# 归因类型为非ua
def test_attribution_type2():
    parms['attribution_type'] = 'test'
    re = send_request4()
    assert re["status"] == 164


# 操作系统为空
def test_os1():
    parms['os'] = ''
    re = send_request4()
    assert re["status"] == 0


# 操作系统超过16个字符
def test_os2():
    parms['os'] = zf35
    re = send_request4()
    assert re["status"] == 115



# 操作系统正常
def test_os3():
    parms['os'] = 'iOS'
    re = send_request4()
    assert re["status"] == 0


# 操作系统包含特殊字符
def test_os4():
    parms['os'] = 'iOS#¥'
    re = send_request4()
    assert re["status"] == 0

# 操作系统正常
def test_os5():
    parms['os'] = 'android'
    re = send_request4()
    assert re["status"] == 0


# 设备型号为空
def test_model1():
    parms['model'] = ''
    re = send_request4()
    assert re["status"] == 0


# 设备型号超过64字符
def test_model2():
    parms['model'] = zf130
    re = send_request4()
    assert re["status"] == 118


# 设备型号=64字符
def test_model3():
    parms['model'] = zf64
    re = send_request4()
    assert re["status"] == 0


# 用户公网IP v4版本,is_s2s为1
def test_ipv41():
    parms['model'] = zf64
    parms['is_s2s'] = '1'
    re = send_request4()
    assert re["status"] == 0


# 用户公网IP v4版本为空,is_s2s为1
def test_ipv42():
    parms['ipv4'] = ""
    parms['is_s2s'] = '1'
    re = send_request4()
    assert re["status"] == 119


# 用户公网IP v4版本超过15字符
def test_ipv43():
    parms['ipv4'] = zf35
    re = send_request4()
    assert re["status"] == 119


# 用户公网IP v4版本为空,is_s2s为0，取http header中的ip作为ipv4/ua的值
def test_ipv44():
    parms['ipv4'] = ""
    parms['is_s2s'] = '0'
    send_request2()



# 用户公网IP v4版本不为空,is_s2s为0，取传的ip值
def test_ipv45():
    parms['ipv4'] = "2.34.34.34"
    parms['is_s2s'] = '0'
    send_request2()


# 用户公网ipv6版本超过128字符
def test_ipv61():
    parms['ipv6'] = zf468
    re = send_request4()
    assert re["status"] == 120


# 用户公网ipv6版本为空
def test_ipv62():
    parms['ipv6'] = ""
    re = send_request4()
    assert re["status"] == 0


# 用户公网ipv6版本为空
def test_ipv63():
    parms['ipv6'] = ""
    re = send_request4()
    assert re["status"] == 0


# 用户代理信息为空，is_s2s=1
def test_ua1():
    parms['ua'] = ""
    parms['is_s2s'] = '1'
    re = send_request4()
    assert re["status"] == 121


# 用户代理信息超过512字符
def test_ua2():
    parms['ua'] = zf668
    parms['is_s2s'] = '1'
    re = send_request4()
    assert re["status"] == 121


# 用户代理信息为空，is_s2s=0
def test_ua3():
    parms['ua'] = ''
    parms['is_s2s'] = '0'
    send_request2()


# OAID超过512字符
def test_oaid1():
    parms['oaid'] = zf668
    re = send_request4()
    assert re["status"] == 126


# OAID为空
def test_oaid2():
    parms['oaid'] = ''
    re = send_request4()
    assert re["status"] == 0


# OAID小于512
def test_oaid3():
    parms['oaid'] = '3DEA635F-B24F-434B-833F-4ED028FEAEEF'
    re = send_request4()
    assert re["status"] == 0


# oaid_md5超过32字符
def test_oaid_md51():
    parms['oaid_md5'] = zf35
    re = send_request4()
    assert re["status"] == 127


# oaid_md5为空
def test_oaid_md52():
    parms['oaid_md5'] = ''
    re = send_request4()
    assert re["status"] == 0


# oaid_md5为32字符
def test_oaid_md53():
    parms['oaid_md5'] = '8e488a40a17aed2f6752f51382a4eafc'
    re = send_request4()
    assert re["status"] == 0


# 各个设备的md5为32字符，大写
def test_oaid_md54():
    newlist = ['oaid_md5', 'imei1_md5', 'imei2_md5', 'gaid_md5', 'mac_md5', 'android_id_md5']
    for shebei_md5 in newlist:
        parms[shebei_md5] = '8E488A40A17AED2F6752F51382A4EAFC'
        re = send_request4()
        assert re["status"] == 0


# imei1超过32字符
def test_imei11():
    parms['imei1'] = zf35
    re = send_request4()
    assert re["status"] == 128


# imei1为空
def test_imei12():
    parms['imei1'] = ''
    re = send_request4()
    assert re["status"] == 0


# imei1为正常
def test_imei13():
    parms['imei1'] = '8342732742383'
    re = send_request4()
    assert re["status"] == 0


# imei1_md5非32字符
def test_imei1_md51():
    parms['imei1_md5'] = zf35
    re = send_request4()
    assert re["status"] == 129


# imei1_md5为32字符
def test_imei1_md53():
    parms['imei1_md5'] = '8e488a40a17aed2f6752f51382a4eafc'
    re = send_request4()
    assert re["status"] == 0


# imei1_md5为空
def test_imei1_md52():
    parms['imei1_md5'] = ''
    re = send_request4()
    assert re["status"] == 0


# imei2超过32字符
def test_imei21():
    parms['imei2'] = zf35
    re = send_request4()
    assert re["status"] == 130


# imei2为空
def test_imei22():
    parms['imei2'] = ''
    re = send_request4()
    assert re["status"] == 0


# imei2为32字符内
def test_imei23():
    parms['imei2'] = '8342732742383'
    re = send_request4()
    assert re["status"] == 0


# imei2_md5非32字符
def test_imei2_md51():
    parms['imei2_md5'] = zf35
    re = send_request4()
    assert re["status"] == 131


# imei2_md5为空
def test_imei2_md52():
    parms['imei2_md5'] = ''
    re = send_request4()
    assert re["status"] == 0


# imei2_md5为32字符
def test_imei2_md53():
    parms['imei2_md5'] = '8e488a40a17aed2f6752f51382a4eafc'
    re = send_request4()
    assert re["status"] == 0


# gaid非36字符
def test_gaid1():
    parms['gaid'] = zf35
    re = send_request4()
    assert re["status"] == 132


# gaid为空
def test_gaid2():
    parms['gaid'] = ''
    re = send_request4()
    assert re["status"] == 0


# gaid为36字符
def test_gaid3():
    parms['gaid'] = 'B21C5EC5-9921-42FD-AAC5-07A0EB6CF1A0'
    re = send_request4()
    assert re["status"] == 0


# gaid_md5非32字符
def test_gaid_md51():
    parms['gaid_md5'] = zf35
    re = send_request4()
    assert re["status"] == 133


# gaid_md5为空
def test_gaid_md52():
    parms['gaid_md5'] = ''
    re = send_request4()
    assert re["status"] == 0


# gaid_md5为32 字符
def test_gaid_md53():
    parms['gaid_md5'] = '8e488a40a17aed2f6752f51382a4eafc'
    re = send_request4()
    assert re["status"] == 0


# mac非17个字符
def test_mac1():
    parms['mac'] = "111111"
    re = send_request4()
    assert re["status"] == 134


# mac为空
def test_mac2():
    parms['mac'] = ""
    re = send_request4()
    assert re["status"] == 0


# mac为17字符
def test_mac3():
    parms['mac'] = "08:00:20:0A:8C:6D"
    re = send_request4()
    assert re["status"] == 0


# mac_md5非32字符
def test_mac_md51():
    parms['mac_md5'] = zf35
    re = send_request4()
    assert re["status"] == 135


# mac_md5为空
def test_mac_md52():
    parms['gaid_md5'] = ''
    re = send_request4()
    assert re["status"] == 0


# mac_md5 32字符
def test_mac_md53():
    parms['gaid_md5'] = '8e488a40a17aed2f6752f51382a4eafc'
    re = send_request4()
    assert re["status"] == 0


# android_id非16字符
def test_android_id1():
    parms['android_id'] = zf35
    re = send_request4()
    assert re["status"] == 136


# android_id为空
def test_android_id2():
    parms['android_id'] = ''
    re = send_request4()
    assert re["status"] == 0


# android_id为16字符
def test_android_id3():
    parms['android_id'] = '1a34fc556a43c453'
    re = send_request4()
    assert re["status"] == 0


# android_id_md5非32字符
def test_android_id_md51():
    parms['android_id_md5'] = zf35
    re = send_request4()
    assert re["status"] == 189


# android_id_md5为空
def test_android_id_md52():
    parms['android_id_md5'] = ''
    re = send_request4()
    assert re["status"] == 0


# android_id_md5为32字符
def test_android_id_md53():
    parms['android_id_md5'] = '8e488a40a17aed2f6752f51382a4eafc'
    re = send_request4()
    assert re["status"] == 0


# 短链是安卓，传idfa
def test_idfa1():
    parms['idfa'] = '3DEA635F-B24F-434B-833F-4ED028FEAEEF'
    re = send_request4()
    assert re["status"] == 115


# 短链是安卓，传idfa_md5
def test_idfa_md51():
    parms['idfa_md5'] = '8e488a40a17aed2f6752f51382a4eafc'
    re = send_request4()
    assert re["status"] == 115


# 短链是安卓，传idfv
def test_idfv1():
    parms['idfv'] = '3DEA635F-B24F-434B-833F-4ED028FEAEEF'
    re = send_request4()
    assert re["status"] == 115


# 短链是安卓，传idfv_md5
def test_idfv_md51():
    parms['idfv_md5'] = '8e488a40a17aed2f6752f51382a4eafc'
    re = send_request4()
    assert re["status"] == 115


# oaid"，"oaid_md5"，"imei1"，"imei1_md5"，"imei2"，"imei2_md5"，"mac"，"mac_md5"，"mac1"，"mac1_md5"，"gaid"，"gaid_md5"全部为空
def test_empty():
    parms['oaid'] = ''
    parms['oaid_md5'] = ''
    parms['imei1'] = ''
    parms['imei1_md5'] = ''
    parms['imei2'] = ''
    parms['imei2_md5'] = ''
    parms['mac'] = ''
    parms['mac_md5'] = ''
    parms['mac1'] = ''
    parms['mac1_md5'] = ''
    parms['gaid_md5'] = ''
    parms['gaid'] = ''
    re = send_request4()
    assert re["status"] == 0


# 广告相关信息集合为空
def test_ads_data1():
    newlist = ['account_id', 'adgroup_id', 'adgroup_name', 'adplan_id', 'adplan_name', 'adcreative_id',
               'adcreative_name', 'adcreative_type', 'site_id', 'site_name', 'ad_type', 'placement_id', 'conversion_id',
               'click_id', 'impression_id', 'request_id', 'callback_id', 'callback_url']
    for ads_data in newlist:
        parms[ads_data] = ''
        re = send_request4()
        assert re["status"] == 0


# 广告账户id，广告组id，广告计划id，广告位id，转化id，广告点击id，广告展示id，广告请求id等于64字符
def test_ads_data2():
    newlist = ['account_id', 'adgroup_id', 'adplan_id',
               'placement_id', 'conversion_id',
               'click_id', 'impression_id', 'request_id']
    for ads_data in newlist:
        parms[ads_data] = zf64
        re = send_request4()
        assert re["status"] == 0


# 广告账户id，广告组id，广告计划id，广告位id，转化id，广告点击id，广告展示id，广告请求id超过64字符
def test_ads_data3():
    newlist = [{'name': 'account_id', 'status': 168},
               {'name': 'adgroup_id', 'status': 169},
               {'name': 'adplan_id', 'status': 171},
               {'name': 'placement_id', 'status': 179},
               {'name': 'conversion_id', 'status': 180},
               {'name': 'click_id', 'status': 181},
               {'name': 'impression_id', 'status': 182},
               {'name': 'request_id', 'status': 183},
               ]
    for ads_data in newlist:
        parms[ads_data['name']] = zf130
        re = send_request4()
        assert re["status"] == ads_data['status']


# 广告组名称，广告计划名称，广告创意名称，渠道回调id，渠道回调地址超过256字符
def test_ads_data4():
    newlist = [{'name': 'adgroup_name', 'status': 170},
               {'name': 'adplan_name', 'status': 172},
               {'name': 'adcreative_name', 'status': 174},
               {'name': 'callback_id', 'status': 184},
               {'name': 'callback_url', 'status': 185},
               ]
    for ads_data in newlist:
        parms[ads_data['name']] = zf468
        re = send_request4()
        assert re["status"] == ads_data['status']


# 广告组名称，广告计划名称，广告创意名称，渠道回调id，渠道回调地址等于256字符
def test_ads_data5():
    newlist = [{'name': 'adgroup_name', 'status': 0},
               {'name': 'adplan_name', 'status': 0},
               {'name': 'adcreative_name', 'status': 0},
               {'name': 'callback_id', 'status': 0},
               {'name': 'callback_url', 'status': 0},
               ]
    for ads_data in newlist:
        parms[ads_data['name']] = zf256
        re = send_request4()
        assert re["status"] == ads_data['status']


# 广告组名称，广告计划名称，广告创意名称，渠道回调id，渠道回调地址小于256字符且包含特殊字符
def test_ads_data6():
    newlist = [{'name': 'adgroup_name', 'status': 0},
               {'name': 'adplan_name', 'status': 0},
               {'name': 'adcreative_name', 'status': 0},
               {'name': 'callback_id', 'status': 0},
               {'name': 'callback_url', 'status': 0},
               ]
    for ads_data in newlist:
        parms[ads_data['name']] = '测试*test'
        re = send_request4()
        assert re["status"] == ads_data['status']


# 广告创意id，流量媒体名称超过128字符
def test_ads_data7():
    newlist = [{'name': 'adcreative_id', 'status': 0},
               {'name': 'site_name', 'status': 0},
               ]
    for ads_data in newlist:
        parms[ads_data['name']] = zf130
        re = send_request4()
        assert re["status"] == ads_data['status']


# 广告创意id，流量媒体名称等于128字符
def test_ads_data8():
    newlist = [{'name': 'adcreative_id', 'status': 0},
               {'name': 'site_name', 'status': 0},
               ]
    for ads_data in newlist:
        parms[ads_data['name']] = zf128
        re = send_request4()
        assert re["status"] == ads_data['status']


# 创意类型，广告类型，流量媒体id超过32字符
def test_ads_data9():
    newlist = [{'name': 'adcreative_type', 'status': 175},
               {'name': 'site_id', 'status': 176},
               {'name': 'ad_type', 'status': 178},
               ]
    for ads_data in newlist:
        parms[ads_data['name']] = zf35
        re = send_request4()
        assert re["status"] == ads_data['status']


# 创意类型为16字符
def test_ads_data10():
    parms['adcreative_type'] = '大图大图大图大图'
    re = send_request4()
    assert re["status"] == 0


# 流量媒体id为32字符字符
def test_ads_data11():
    parms['site_id'] = '巨量的今日头条、穿山甲、抖音抖音'
    re = send_request4()
    assert re["status"] == 0


# 广告类型为32字符字符
def test_ads_data12():
    parms['ad_type'] = '巨量的今日头条、穿山甲、抖音抖音'
    re = send_request4()
    assert re["status"] == 0


# 自定义触点参数1-10,为32字符内
def test_custom_params1():
    parms['custom_params_1'] = '自定义触点参数'
    parms['custom_params_2'] = '3333 带空格'
    parms['custom_params_3'] = '  '
    parms['custom_params_4'] = '32个字符32个字符32个字符32个字符'
    parms['custom_params_5'] = ''
    parms['custom_params_6'] = '……%¥#¥%……¥#'
    parms['custom_params_7'] = '34343244'
    parms['custom_params_8'] = 'tes rwe ew'
    parms['custom_params_9'] = '_自定义'
    parms['custom_params_10'] = 'test@#'

    re = send_request4()
    assert re["status"] == 0


# 自定义触点参数,超过32字符
def test_custom_params2():
    parms['custom_params_1'] = zf35
    re = send_request4()
    assert re["status"] == 186


if __name__ == '__main__':
    pytest.main()
