import requests
import json
import time
import pytest
url1 = 'http://tmtest.trackingio.com/receive/turl/3r5K1h9'
current_time_13 = int(round(time.time() * 1000))
zf35 = '54321422322132132131213133322323233'
zf130 = 'xiaomi小米小米xiaomi小米小米xiaomi小米小米xiaomi小米小米xiaomi小米小米小米xiaomi小米xiaomi小米xiaomi小米xiaomi小米xiaomi小米xiaomi'
zf64 = 'xiaomi小米小米xiaomi小米小米xiaomi小米小米xiaomi小米小米xiaomi小'
zf468 = '1.2.23.3.4.4232.213123.13.23.213.123.123.213.21.321.3.213.12.321.3.21.321.3.121.2.23.3.4.4232.213123.13.23.213.123.123.2131.2.23.3.4.4232.213123.13.23.213.123.123.213.21.321.3.213.12.321.3.21.321.3.121.2.23.3.4.4232.213123.13.23.213.123.123.213.21.321.3.213.12.321.3.21.321.3.121.2.23.3.4.4232.213123.13.23.213.123.123.213.21.321.3.213.12.321.3.21.321.3.12.21.321.3.213.12.321.3.21.321.3.121.2.23.3.4.4232.213123.13.23.213.123.123.213.21.321.3.213.12.321.3.21.321.3.12'
zf668 = 'Mozilla/5.0 (Linux; U; Android 7.0; zh-cn; Nexus 5X Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko)Version/4.0 Chrome/37.0.0.0 MQQBrowser/7.3 Mobile Safari/537.36Mozilla/5.0 (Linux; U; Android 7.0; zh-cn; Nexus 5X Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko)Version/4.0 Chrome/37.0.0.0 MQQBrowser/7.3 Mobile Safari/537.36Mozilla/5.0 (Linux; U; Android 7.0; zh-cn; Nexus 5X Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko)Version/4.0 Chrome/37.0.0.0 MQQBrowser/7.3 Mobile Safari/537.36Mozilla/5.0 (Linux; U; Android 7.0; zh-cn; Nexus 5X Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko)Version/4.0 Chrome/37.0.0.0 MQQBrowser/7.3 Mobile Safari/537.36'

global parms

parms = {
    # 触点传参时间。is_s2s=1时必传，0时选传。不同渠道有可能传多种格式，详见需求。限制32位字符内。短链传参。
    'ts': int(round(time.time() * 1000)),
    # 集成方式。is_s2s=1为服务器上报触点，0为客户端上报触点。0或1时有不同的参数非空校验，详见需求。固定为0或1。都必传
    'is_s2s': '1',
    # 操作系统。限制16字符内。都选传。短链传参。暂不与app_platform互相做校验。
    'os': 'ios',
    # 设备型号。限制64字符内。都选传。短链传参。
    'model': '小米',
    # 用户公网IP v4版本。限制15字符内。is_s2s=1时都必传，0时都选传，0时优先取传参IP，未传参或传参报错时，取http header中的ip作为ipv4的值
    'ipv4': '1.1.1.1',
    # 用户公网IP v6版本。限制128字符内。都选传
    'ipv6': '',
    # 用户代理信息。限制512字符内。is_s2s=1时都必传，0时都选传，0时优先取传参UA，未传参或报错时，取http header中的user agent作为ua的值
    'ua': 'Mozilla/5.0 (Linux; U; Android 7.0; zh-cn; Nexus 5X Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko)Version/4.0 Chrome/37.0.0.0 MQQBrowser/7.3 Mobile Safari/537.36',
    # iOS IDFA原值。固定为36字符
    "idfa": "",
    "idfa_md5": "",
    "idfv": "",
    "idfv_md5": "",
    # 触点类型。固定为click。都必传
    'touchpoint_type': 'click',
    # 归因类型。固定为ua（user acquirement新客获取）
    'attribution_type': 'ua',

    # 广告账户id。限制64字符内。都选传
    'account_id': '123',
    # # 广告组id。限制64字符内。都选传
    # 'adgroup_id': '',
    # # 广告组名称。限制256字符内。都选传
    # 'adgroup_name': '',
    # # 广告计划id。限制64字符内。都选传
    'adplan_id': '342312312',
    # # 广告计划名称。限制256字符内。都选传
    # 'adplan_name': '',
    # # 广告创意id。限制128字符内。都选传
    'adcreative_id': '1111',
    # # 广告创意名称。限制256字符内。都选传
    # 'adcreative_name': '',
    # # 创意类型（例如大图、小图、视频等）。限制16字符内。都选传
    'adcreative_type': '大图',
    # # 流量媒体id（例如巨量的今日头条、穿山甲、抖音等）。限制32字符内。都选传
    # 'site_id': '',
    # # 流量媒体名称（例如巨量的今日头条、穿山甲、抖音等）。限制128字符内。都选传
    # 'site_name': '',
    # # 广告类型（例如开屏、信息流、搜索等）。限制32字符内。都选传。
    # 'ad_type': '',
    # # 广告位id。限制64字符内。都选传
    'placement_id': '222',
    # # 转化id。限制64字符内。都选传
    'conversion_id': '333',
    # # 广告点击id。限制64字符内。都选传
    'click_id': '765432354634',
    # # 广告展示id。限制64字符内。都选传
    'impression_id': '444',
    # # 广告请求id。限制64字符内。都选传
    # 'request_id': '',
    # # 渠道回调id。限制256字符。都选传
    'callback_id': 'EJiw267wvfQCGKf2g74ZIPD89-vIATAMOAFCIjIwMTkxMTI3MTQxMTEzMDEwMDI2MDc3MjE1MTUwNTczNTBIAQ==',
    # 渠道回调地址。限制256字符。都选传
    'callback_url': 'https%3A%2F%2Furi6.com%2Ftkio%2Fa6ZVNba%3Fnoredirect%3Dtrue',

    # 自定触点参数集合。都选传。
    # 'custom_params_1': ''
}
data_temp = json.dumps(parms)


# p = requests.get(url=url1, params=parms, timeout=10, verify=False)
# print(p.url)
# print(p.status_code)
# print(p.content)
def send_request(cs):
    global parms
    # 测试
    url1 = 'http://tmtest.trackingio.com/receive/turl/I3eYvea' + cs
    # 线上
    # url1 = 'http://tkio-redirect.solar-engine.com/receive/turl/f6F7zia' + cs

    response = requests.get(url=url1, params=parms, timeout=10, verify=False)
    print(response.url)
    parms = json.loads(data_temp)
    response = json.loads(response.text)
    return response



def send_request3(cs):
    global parms
    # 测试
    url1 = 'http://tmtest.trackingio.com/receive/turl/I3eYvea' + cs
    # 线上
    # url1 = 'http://tkio-redirect.solar-engine.com/receive/turl/qY7fQza' + cs
    parms['ts'] = int(round(time.time() * 1000))
    response = requests.get(url=url1, params=parms, timeout=10, verify=False)
    print(response.url)
    print(response.text)
    parms = json.loads(data_temp)
    response = json.loads(response.text)
    return response



# idfa为空
def test_idfa1():
    parms['idfa'] = ''
    re = send_request('')
    assert re["status"] == 0

# idfa为全0
def test_idfa2():
    parms['idfa'] = '00000000-0000-0000-0000-000000000000'
    re = send_request('')
    assert re["status"] == 0


# idfa为32字符
def test_idfa3():
    parms['idfa'] = '3DEA635F-B24F-434B-833F-4ED028FEAEEF'
    re = send_request('')
    assert re["status"] == 0


# idfa非32字符
def test_idfa4():
    parms['idfa'] = zf35
    re = send_request('')
    assert re["status"] == 124


# idfa_md5为空
def test_idfa_md51():
    parms['idfa_md5'] = ''
    re = send_request('')
    assert re["status"] == 0


# idfa_md5为全0 md5加密
def test_idfa_md52():
    parms['idfa_md5'] = '9f89c84a559f573636a47ff8daed0d33'
    re = send_request('')
    assert re["status"] == 0


# idfa_md5为32字符
def test_idfa_md53():
    parms['idfa_md5'] = '8e488a40a17aed2f6752f51382a4eafc'
    re = send_request('')
    assert re["status"] == 0


# idfa_md5非32字符
def test_idfa_md54():
    parms['idfa_md5'] = zf35
    re = send_request('')
    assert re["status"] == 187


# idfv和idfv_md5同上

# idfv为空
def test_idfv1():
    parms['idfv'] = ''
    re = send_request('')
    assert re["status"] == 0

# idfv为全0
def test_idfv2():
    parms['idfv'] = '00000000-0000-0000-0000-000000000000'
    re = send_request('')
    assert re["status"] == 0


# idfv为32字符
def test_idfv3():
    parms['idfv'] = '3DEA635F-B24F-434B-833F-4ED028FEAEEF'
    re = send_request('')
    assert re["status"] == 0


# idfv非32字符
def test_idfv4():
    parms['idfv'] = zf35
    re = send_request('')
    assert re["status"] == 125



# idfv_md5为空
def test_idfv_md51():
    parms['idfv_md5'] = ''
    re = send_request('')
    assert re["status"] == 0


# idfv_md5为全0 md5加密
def test_idfv_md52():
    parms['idfv_md5'] = '9f89c84a559f573636a47ff8daed0d33'
    re = send_request('')
    assert re["status"] == 0


# idfv_md5为32字符
def test_idfv_md53():
    parms['idfa_md5'] = '8e488a40a17aed2f6752f51382a4eafc'
    re = send_request('')
    assert re["status"] == 0


# idfv_md5非32字符
def test_idfv_md54():
    parms['idfv_md5'] = zf35
    re = send_request('')
    assert re["status"] == 188



# 短链是ios，传oaid
def test_oaid():
    parms['oaid'] = '3DEA635F-B24F-434B-833F-4ED028FEAEE'
    re = send_request('')
    assert re["status"] == 115


# 短链是ios，传oaid_md5
def test_oaid_md5():
    parms['oaid_md5'] = '8e488a40a17aed2f6752f51382a4eafc'
    re = send_request('')
    assert re["status"] == 115


# 短链是ios，传imei1
def test_imei1():
    parms['imei1'] = '8342732742383'
    re = send_request('')
    assert re["status"] == 115



# 短链是ios，传imei1_md5
def test_imei1_md5():
    parms['imei1_md5'] = '8e488a40a17aed2f6752f51382a4eafc'
    re = send_request('')
    assert re["status"] == 115


# 短链是ios，传imei2
def test_imei2():
    parms['imei2'] = '8342732742383'
    re = send_request('')
    assert re["status"] == 115


# 短链是ios，传imei2_md5
def test_imei2_md5():
    parms['imei2_md5'] = '8e488a40a17aed2f6752f51382a4eafc'
    re = send_request('')
    assert re["status"] == 115


# 短链是ios，传gaid
def test_gaid():
    parms['gaid'] = 'B21C5EC5-9921-42FD-AAC5-07A0EB6CF1A0'
    re = send_request('')
    assert re["status"] == 115


# 短链是ios，传gaid_md5
def test_gaid_md5():
    parms['gaid_md5'] = '8e488a40a17aed2f6752f51382a4eafc'
    re = send_request('')
    assert re["status"] == 115



# 短链是ios，传mac
def test_mac():
    parms['mac'] = 'B21C5EC5-9921-42FD-AAC5-07A0EB6CF1A0'
    re = send_request('')
    assert re["status"] == 115



# 短链是ios，传mac_md5
def test_mac_md5():
    parms['mac_md5'] = '8e488a40a17aed2f6752f51382a4eafc'
    re = send_request('')
    assert re["status"] == 115


# 短链是ios，传android_id
def test_android_id():
    parms['android_id'] = '1a34fc556a43c453'
    re = send_request('')
    assert re["status"] == 115



# 短链是ios，传android_id_md5
def test_android_id_md5():
    parms['android_id'] = '8e488a40a17aed2f6752f51382a4eafc'
    re = send_request('')
    assert re["status"] == 115



if __name__ == '__main__':
    pytest.main()
