package common.repository;

import common.model.Account4Web;
import common.model.Auth;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;
import tkio.model.Account;

import java.util.List;

@Transactional
public interface Account4WebRepository extends JpaRepository<Account4Web, Long> {

    @Query(value = "SELECT * from account4web where email in ?1", nativeQuery = true)
    List<Account4Web> findByEmails(List<String> emails);

    @Query(value = "SELECT * from account4web where past_date = ?1", nativeQuery = true)
    List<Account4Web> findByPast(String yesterday);

    @Query(value = "SELECT * from account4web where status = '已过期' or status = '流量用尽'", nativeQuery = true)
    List<Account4Web> findPast();

    @Query(value = "SELECT * from account4web where email = ?1", nativeQuery = true)
    Account4Web findByEmail(String email);

}
