package common.repository;

import common.model.Contract;
import common.model.Role;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigInteger;
import java.util.List;

@Transactional
public interface ContractRepository extends JpaRepository<Contract, Long> {

    @Query(value="select count(*) from contract where ds = ?1",nativeQuery=true)
    BigInteger countNumByDs(String ds);

    @Query(value="select count(*) from contract where email = ?1",nativeQuery=true)
    BigInteger countNumByEmail(String email);

    @Query(value="select * from contract where ds >= ?1 and ds <= ?2 and platform = ?3 order by ds desc",nativeQuery=true)
    List<Contract> findByDs(String startDate, String endDate, String platfrom);

    @Query(value="select * from contract where contract_code = ?1",nativeQuery=true)
    Contract findByCode(String contract_code);

    @Query(value="SELECT * from contract where platform = ?1",nativeQuery=true)
    List<Contract> findByPlatform(String platform);

    @Query(value="SELECT * from contract where platform = ?1 and email = ?2",nativeQuery=true)
    List<Contract> findByPlatformAndEmail(String platform, String email);
}
