package common.repository;

import common.model.UserLog;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * Created by zxy on 2017/12/27.
 */
public interface UserLogRepository extends JpaRepository<UserLog, Long>
{
    @Query(value = "select * from user_log where substr(operate_time, 1, 10)>=?1 and substr(operate_time, 1, 10)<=?2", nativeQuery = true)
    List<UserLog> findByOperateTime(String startDate, String endDate);
}
