package common.repository;

import common.model.Menu;
import common.model.User;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Transactional
public interface UserRepository extends JpaRepository<User, Long> {

	@Query(value="select * from user where email = ?1 and password = ?2 and del_flag is not true",nativeQuery=true)
	User login(String email, String pwd);

	@Query(value="select * from user where role = ?1 and del_flag is not true",nativeQuery=true)
	List<User> findOneDepartment(Long role);

	@Query(value="select * from user where del_flag is not true",nativeQuery=true)
	List<User> findList();

	@Query(value="select * from user where email = ?1 and del_flag is not true",nativeQuery=true)
	User login(String email);

	@Query(value="select * from user where del_flag is not true and (role = 2 or role = 3)",nativeQuery=true)
	List<User> findSales();

	@Query(value="SELECT * from `user` where del_flag is not true and role = ?1 ORDER BY role_type",nativeQuery=true)
	List<User> findAllByRole(Long role);

	@Query(value="SELECT * from `user` where role = ?1 ORDER BY role_type",nativeQuery=true)
	List<User> findAllUserByRole(Long role);

	@Query(value="SELECT * from `user` where del_flag is not true and parent = ?1",nativeQuery=true)
	List<User> findAllByParent(Long id);

	@Query(value="SELECT * from `user` where parent = ?1",nativeQuery=true)
	List<User> findByParent(Long id);

	@Query(value="SELECT * from `user` where del_flag is not true and id in ?1",nativeQuery=true)
	List<User> findAllByIds(List<Long> ids);

	@Query(value="SELECT * from `user` where id in ?1",nativeQuery=true)
	List<User> findByIds(List<Long> ids);

	@Query(value="SELECT * from `user` where del_flag is not true and parent in ?1",nativeQuery=true)
	List<User> findAllByParents(List<Long> ids);

	@Query(value="SELECT * from `user` where parent in ?1",nativeQuery=true)
	List<User> findByParents(List<Long> ids);
}
