package common.service.impl;

import common.model.UserLog;
import common.repository.UserLogRepository;
import common.service.UserLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import util.StringUtil;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by zxy on 2017/12/27.
 */
@Service
public class UserLogServiceImpl implements UserLogService
{

    @Autowired UserLogRepository userLogRepository;

    @Override
    public List<UserLog> findUserLog(String startDate, String endDate)
    {
        return userLogRepository.findByOperateTime(startDate, endDate);
    }

}
