package tkio.controller;

import common.model.BackVisit;
import common.model.Payment;
import common.model.Reminder;
import common.model.User;
import common.service.UserService;
import dic.OperateObjectTypeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import security.annotation.CurrentAccount;
import tkio.service.TkioAccountService;
import util.ResultModel;
import util.UserLogThread;

import javax.servlet.http.HttpServletRequest;

/**
 * Created by mxq on 2017/12/21.
 */
@Controller
@RequestMapping("tkio/marketing/accountmng")
public class TkioAccountController {

    @Autowired
    TkioAccountService tkioAccountService;

    //客户列表
    @RequestMapping(value = "/findAll", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel find(@CurrentAccount User loginAccount) {
        return ResultModel.OK(tkioAccountService.findAll(loginAccount));
    }

    @RequestMapping(value = "/findone", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findOne(@CurrentAccount User loginAccount, @RequestParam String email) {
        return ResultModel.OK(tkioAccountService.findOne(email));
    }
    @RequestMapping(value = "/find/reminderlevel", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findReminderlevel() {
        return ResultModel.OK(tkioAccountService.findReminderlevel());
    }

    //关闭到期提醒
    @RequestMapping(value = "/forbiden", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel forbiden(@CurrentAccount User loginAccount, @RequestBody Reminder resource, HttpServletRequest request) {
        UserLogThread userlog = new UserLogThread(loginAccount.getEmail(), loginAccount.getName(), OperateObjectTypeEnum.CUSTOMER.getKey(), resource.getEmail(), "关闭异常状态跟进", request);
        userlog.start();
        return ResultModel.OK(tkioAccountService.forbiden(loginAccount, resource));
    }

    //开启到期提醒
    @RequestMapping(value = "/enable", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel enable(@CurrentAccount User loginAccount, @RequestBody Reminder resource, HttpServletRequest request) {
        UserLogThread userlog = new UserLogThread(loginAccount.getEmail(), loginAccount.getName(), OperateObjectTypeEnum.CUSTOMER.getKey(), resource.getEmail(), "开启异常状态跟进", request);
        userlog.start();
        return ResultModel.OK(tkioAccountService.enable(loginAccount, resource));
    }

    //缴费
    @RequestMapping(value = "/pay", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel pay(@CurrentAccount User loginAccount, @RequestBody Payment resource, HttpServletRequest request) {
        UserLogThread userlog = new UserLogThread(loginAccount.getEmail(), loginAccount.getName(), OperateObjectTypeEnum.CUSTOMER.getKey(), resource.getEmail(), "缴费", request);
        userlog.start();
        return ResultModel.OK(tkioAccountService.pay(loginAccount, resource));
    }

    //回访
    @RequestMapping(value = "/visit", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel visit(@CurrentAccount User loginAccount, @RequestBody BackVisit resource, HttpServletRequest request) {
        UserLogThread userlog = new UserLogThread(loginAccount.getEmail(), loginAccount.getName(), OperateObjectTypeEnum.CUSTOMER.getKey(), resource.getEmail(), "回访", request);
        userlog.start();
        return ResultModel.OK( tkioAccountService.visit(loginAccount, resource));
    }
    //功能使用查询
    @RequestMapping(value = "/find/function/{accountId}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel updateName(@CurrentAccount User loginAccount, @RequestParam String startDate,
                                  @RequestParam String endDate,  @PathVariable Long accountId) {

        return ResultModel.OK(tkioAccountService.findFunTimes(accountId,startDate,endDate));
    }

    //功能使用查询
    @RequestMapping(value = "/find/pv/{accountId}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel pv(@CurrentAccount User loginAccount, @RequestParam String startDate,
                                  @RequestParam String endDate,  @PathVariable Long accountId) {

        return ResultModel.OK(tkioAccountService.findPv(accountId,startDate,endDate));
    }

    //到期提醒查询
    @RequestMapping(value = "/find/reminder/{accountId}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findRed(@CurrentAccount User loginAccount, @RequestParam String startDate,
                          @RequestParam String endDate,  @PathVariable Long accountId) {

        return ResultModel.OK(tkioAccountService.findRed(accountId,startDate,endDate));
    }

    //回访查询
    @RequestMapping(value = "/find/visit/{accountId}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findVisit(@CurrentAccount User loginAccount, @RequestParam String startDate,
                               @RequestParam String endDate,  @PathVariable Long accountId) {

        return ResultModel.OK(tkioAccountService.findVisit(accountId,startDate,endDate));
    }

    //缴费查询
    @RequestMapping(value = "/find/pay/{accountId}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findPay(@CurrentAccount User loginAccount, @RequestParam String startDate,
                               @RequestParam String endDate,  @RequestParam String email,  @PathVariable Long accountId) {

        return ResultModel.OK(tkioAccountService.findPay(email,startDate,endDate));
    }

    //套餐变更查询
    @RequestMapping(value = "/find/contract/{accountId}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findChange(@CurrentAccount User loginAccount,  @RequestParam String email,  @PathVariable Long accountId) {

        return ResultModel.OK(tkioAccountService.findContract(email));
    }

    //合同查询
    @RequestMapping(value = "/find/change/{accountId}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findContract(@CurrentAccount User loginAccount, @RequestParam String startDate,
                                  @RequestParam String endDate,  @RequestParam String email,  @PathVariable Long accountId) {

        return ResultModel.OK(tkioAccountService.findContractChange(email,startDate,endDate));
    }
}
