package tkio.task;

import com.google.api.client.util.ArrayMap;
import common.model.Account4Web;
import common.model.Reminder;
import common.model.User;
import common.repository.Account4WebRepository;
import common.repository.ReminderRepository;
import common.repository.UserRepository;
import dic.RoleEnum;
import org.springframework.beans.factory.annotation.Autowired;
import tkio.model.Account;
import tkio.model.AccountRestrict4Web;
import tkio.model.PackageType;
import tkio.model.SalesManLeader;
import tkio.repository.AccountRepository;
import tkio.repository.PackageTypeRepository;
import tkio.repository.SalesManLeaderRepository;
import tkio.service.AccountFlowRestrictService;
import tkio.service.SendEmailService;
import util.DateUtil;
import util.ValidateUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by mxq on 2017/12/25.
 */
public class SendEmailTask {


    @Autowired
    Account4WebRepository account4WebRepository;

    @Autowired
    SalesManLeaderRepository salesManLeaderRepository;

    @Autowired
    UserRepository userRepository;
    @Autowired
    ReminderRepository reminderRepository;
    @Autowired
    SendEmailService sendEmailService;

    public void task(){
        //清空前一天数据
        List<Account4Web> account4WebList = account4WebRepository.findPast();
        if(ValidateUtil.isValid(account4WebList)){
            Map<Long, List<String>> map = new HashMap<>();
            for(Account4Web aw : account4WebList){
                if(map.containsKey(0L)){
                    List<String> list = map.get(0L);
                    list.add(aw.getEmail());
                    map.put(aw.getBussinessMan(), list);
                } else {
                    List<String> list = new ArrayList<>();
                    list.add(aw.getEmail());
                    map.put(0L, list);
                }
                if(null != aw.getBussinessMan()){
                    if(map.containsKey(aw.getBussinessMan())){
                        List<String> list = map.get(aw.getBussinessMan());
                        list.add(aw.getEmail());
                        map.put(aw.getBussinessMan(), list);
                    } else {
                        List<String> list = new ArrayList<>();
                        list.add(aw.getEmail());
                        map.put(aw.getBussinessMan(), list);
                    }
                }
            }

            List<SalesManLeader> salesManLeaders = salesManLeaderRepository.findAll();
            Map<String, List<Long>> saleMap = new HashMap<>();
            if(ValidateUtil.isValid(salesManLeaders)){
                for(SalesManLeader sml : salesManLeaders){
                    List<Long> idList = new ArrayList<>();
                    if(sml.getId() == 0 || sml.getId() == sml.getLeader()){//不是主管
                        Long id = (long)sml.getId();
                        idList.add(id);
                    }else{//是主管
                        for(SalesManLeader sml2 : salesManLeaders){
                            if(sml.getId() == sml2.getLeader()){
                                Long id = (long)sml.getId();
                                idList.add(id);
                            }
                        }
                    }
                    saleMap.put(sml.getEmail(), idList);
                }
            }
            List<Reminder> reminderList = reminderRepository.findAllDistinctFalse("tkio");
            Map<String, Boolean> reMap = new HashMap<>();
            if(ValidateUtil.isValid(reminderList)){
                for(Reminder re : reminderList){
                    reMap.put(re.getEmail(), re.getRemindStatus());
                }
            }
            List<User> userList = userRepository.findAll();
            for(User user : userList){
                if(user.getRole().equals(RoleEnum.MANAGER.getKey())){
                    List<String> list = map.get(0L);
                    List<String> newList = new ArrayList<>();
                    for(String em : list){
                        if (reMap.containsKey(em)){
                            if(reMap.get(em)){
                                newList.add(em);
                            }
                        }else{
                            newList.add(em);
                        }
                    }
                    //sendEmail
                    sendEmailService.send(user.getEmail(), newList);
                } else if(saleMap.containsKey(user.getId())){
                    List<Long> idlist = saleMap.get(user.getId());
                    List<String> newList = new ArrayList<>();
                    for(Long id : idlist){
                        if(map.containsKey(id)){
                            List<String> list = map.get(id);
                            for(String em : list){
                                if (reMap.containsKey(em)){
                                    if(reMap.get(em)){
                                        newList.add(em);
                                    }
                                }else{
                                    newList.add(em);
                                }
                            }
                        }
                    }
                    //sendEmail
                    sendEmailService.send(user.getEmail(), newList);
                }
            }
        }

    }
}
