package common.repository;

import common.model.Contract;
import common.model.ContractChange;
import common.model.ContractMoney;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Transactional
public interface ContractMoneyRepository extends JpaRepository<ContractMoney, Long> {

    @Query(value="select * from contract_money where ds >= ?1 and ds <= ?2 and contract_code = ?3  and del_flag is not true  order by ds desc",nativeQuery=true)
    List<ContractMoney> findByDs(String startDate, String endDate, String code);

    @Query(value="select * from contract_money where ds >= ?1 and ds <= ?2  and platform = ?3 order by ds desc",nativeQuery=true)
    List<ContractMoney> findByDsAll(String startDate, String endDate, String platform);

    @Query(value="select * from contract_money where ds >= ?1 and ds <= ?2 and email = ?3 and platform = ?4 order by ds desc",nativeQuery=true)
    List<ContractMoney> findByDs(String startDate, String endDate, String email, String platform);

    @Query(value="select * from contract_money where email = ?1 and platform = ?2 and type = 'pay' order by ds desc",nativeQuery=true)
    List<ContractMoney> findByEmail(String email, String platform);

//    @Query(value = "select a.id,b.customer_body company,a.contract_code,u.name create_name,a.create_account,a.create_time,a.ds,a.email,a.modify_account,a.modify_time,a.money,a.platform,a.type,a.user,a.del_flag,b.sale salse,b.price_level from contract_money a left join contract b on a.contract_code = b.contract_code left join user u on a.create_account = u.id where a.ds >= ?1 and a.ds <= ?2  and a.platform = ?3 order by a.ds desc",nativeQuery = true)
//    List<ContractMoney> findByDsAllContract(String startDate, String endDate, String platfrom);

//    @Query(value = "select a.id,b.customer_body company,a.contract_code,u.name create_name,a.create_account,a.create_time,a.ds,a.email,a.modify_account,a.modify_time,a.money,a.platform,a.type,a.user,a.del_flag,b.sale salse,b.price_level from contract_money a left join contract b on a.contract_code = b.contract_code left join user u on a.create_account = u.id where a.ds >= ?1 and a.ds <= ?2 and a.platform = ?3 and a.type = ?4 and b.price_level = ?5 order by a.ds desc",nativeQuery = true)
//    List<ContractMoney> findByDsAllContractAll(String startDate, String endDate, String platfrom, String moneyType, String packageTypeSearch);
//
//    @Query(value = "select a.id,b.customer_body company,a.contract_code,u.name create_name,a.create_account,a.create_time,a.ds,a.email,a.modify_account,a.modify_time,a.money,a.platform,a.type,a.user,a.del_flag,b.sale salse,b.price_level from contract_money a left join contract b on a.contract_code = b.contract_code left join user u on a.create_account = u.id where a.ds >= ?1 and a.ds <= ?2 and a.platform = ?3 and a.type = ?4  order by a.ds desc",nativeQuery = true)
//    List<ContractMoney> findByDsAllContractMoneyType(String startDate, String endDate, String platfrom, String moneyType);
//
//    @Query(value = "select a.id,b.customer_body company,a.contract_code,u.name create_name,a.create_account,a.create_time,a.ds,a.email,a.modify_account,a.modify_time,a.money,a.platform,a.type,a.user,a.del_flag,b.sale salse,b.price_level from contract_money a left join contract b on a.contract_code = b.contract_code left join user u on a.create_account = u.id where a.ds >= ?1 and a.ds <= ?2 and a.platform = ?3  and b.price_level = ?4 order by a.ds desc",nativeQuery = true)
//    List<ContractMoney> findByDsAllContractPkSearch(String startDate, String endDate, String platfrom, String pkType);

    @Query(value = "select a.id,a.company,a.contract_code,a.create_account,a.create_time,a.ds,a.email,a.modify_account,a.modify_time,a.money,a.platform,a.type,a.user,a.del_flag,a.salse,a.price_level,u.name create_name from contract_money a left join user u on a.create_account = u.id where a.ds >= ?1 and a.ds <= ?2 and a.platform = ?3  order by a.ds desc",nativeQuery = true)
    List<ContractMoney> findByDsAllContract(String startDate, String endDate, String platfrom);

    @Query(value = "select a.id,a.company,a.contract_code,a.create_account,a.create_time,a.ds,a.email,a.modify_account,a.modify_time,a.money,a.platform,a.type,a.user,a.del_flag,a.salse,a.price_level,u.name create_name from contract_money a left join user u on a.create_account = u.id where a.ds >= ?1 and a.ds <= ?2 and a.platform = ?3 and a.type = ?4 and a.price_level = ?5 order by a.ds desc",nativeQuery = true)
    List<ContractMoney> findByDsAllContractAll(String startDate, String endDate, String platfrom, String moneyType, String packageTypeSearch);

    @Query(value = "select a.id,a.company,a.contract_code,a.create_account,a.create_time,a.ds,a.email,a.modify_account,a.modify_time,a.money,a.platform,a.type,a.user,a.del_flag,a.salse,a.price_level,u.name create_name from contract_money a left join user u on a.create_account = u.id where a.ds >= ?1 and a.ds <= ?2 and a.platform = ?3 and a.type = ?4  order by a.ds desc",nativeQuery = true)
    List<ContractMoney> findByDsAllContractMoneyType(String startDate, String endDate, String platfrom, String moneyType);

    @Query(value = "select a.id,a.company,a.contract_code,a.create_account,a.create_time,a.ds,a.email,a.modify_account,a.modify_time,a.money,a.platform,a.type,a.user,a.del_flag,a.salse,a.price_level,u.name create_name from contract_money a left join user u on a.create_account = u.id where a.ds >= ?1 and a.ds <= ?2 and a.platform = ?3  and a.price_level = ?4 order by a.ds desc",nativeQuery = true)
    List<ContractMoney> findByDsAllContractPkSearch(String startDate, String endDate, String platfrom, String pkType);

    @Query(value = "select a.id,a.company,a.contract_code,a.create_account,a.create_time,a.ds,a.email,a.modify_account,a.modify_time,a.money,a.platform,a.type,a.user,a.del_flag,a.salse,a.price_level,u.name create_name from contract_money a left join user u on a.create_account = u.id where a.ds >= ?1 and a.ds <= ?2 and a.platform = ?3 and a.id in ?4  order by a.ds desc",nativeQuery = true)
    List<ContractMoney> findByDsAllContractMoneyIds(String startDate, String endDate, String platfrom,List moneyIds);
}
