package tkio.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import tkio.model.PackageType;

import java.util.List;

public interface PackageTypeRepository extends JpaRepository<PackageType, Long> {
    @Query(value = "select * from package_type where id=(select pricelevel from account  where id=?1)", nativeQuery = true)
    PackageType findPackageTypeByRootParent(Long rootParent);

    @Query(value = "select * from package_type where id=?1", nativeQuery = true)
    PackageType findPackageTypeByID(Long ID);

    @Query(value = " select * from package_type where is_new is true ", nativeQuery = true)
    List<PackageType> findIsNewAll();

    @Query(value = "select * from package_type where id = ?1 union all  select * from package_type where id = ?2",nativeQuery = true)
    List<PackageType> findByTwoId(Long priceLevel, Long priceLevel1);
}
