package common.controller;

import common.model.AppInfo;
import common.service.AppService;
import dic.OperateObjectTypeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import util.ResultModel;
import util.StringUtil;
import util.UserLogThread;

import javax.servlet.http.HttpServletRequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

/**
 * Created by zxy on 2017/12/27.
 */
@Controller
@RequestMapping("applist")
public class AppController
{
    @Autowired AppService appService;

    ///api/applist/find?reyun=&location=%E5%8C%97%E4%BA%AC&firstCate=&secondCate=&pageNum=0&pageSize=20&sortString=pkgName&isASC=1
    @RequestMapping(value = "find", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findAll(@RequestParam Integer reyun, @RequestParam String location, @RequestParam String firstCate, @RequestParam String secondCate,
    @RequestParam int pageNum, @RequestParam int pageSize, @RequestParam String sortString, @RequestParam Integer isASC, @RequestParam String searchString,
            @RequestParam String startDate, @RequestParam String endDate) {
        AppInfo app = new AppInfo();
        app.setLocation(location);
        app.setFirstCate(firstCate);
        app.setSecondCate(secondCate);
        app.setReyun(reyun);
        Map result = new HashMap();
        try {
            result = appService.findAppList(app, pageNum, pageSize, sortString, isASC, searchString, startDate, endDate);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return ResultModel.OK(result);
    }

    ///api/applist/category/1
    @RequestMapping(value="category/{level}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findCategory(@PathVariable int level) {
        return ResultModel.OK(appService.findAllCategoryByLevel(level));
    }

    ///api/applist/city
    @RequestMapping(value = "city", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findCity() {
        return ResultModel.OK(appService.findCity());
    }

    @RequestMapping(value = "data", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findDeviceData() {
        return ResultModel.OK(appService.findAppDataList("2017-12-22", "2017-12-22", null, 0, 0, 20));
    }
}
