package common.repository;

import common.model.ContractRelation;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.math.BigInteger;
import java.util.List;


/**
 * 合同 关联信息
 */
public interface ContractRelationRepository extends JpaRepository<ContractRelation, Long> {

    @Query(value = "select  relation_id id from contract_relation where main_contract  in ?1 union all select  main_contract id from contract_relation where  relation_id  in ?1",nativeQuery = true)
    List<BigInteger> findRelationIds(List contractId);

    @Query(value = "select * from contract_relation where main_contract = ?1 and relation_id = ?2 and platform = ?3",nativeQuery = true)
    ContractRelation findByRelationData(Long mainContract, Long relationId, String platform);

    @Query(value = "select  a.* from contract_relation a  left join contract b on a.relation_id = b.id  where main_contract  = ?1 and b.status <>'del'  ",nativeQuery = true)
    List<ContractRelation> findRelationIdsMain(String contractId);
}
