package common.repository;

import common.model.TkioFlow;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;

public interface TkioFlowRepository  extends JpaRepository<TkioFlow, Long> {

    @Query(value = "select sum(flow) from tkio_flow where email = ?1 and contract_code = ?2", nativeQuery = true)
    BigDecimal sumFlowByEmailAndContractCode(String email, String contractCode);

    @Transactional
    @Modifying
    @Query(value = "delete from tkio_flow where email = ?1", nativeQuery = true)
    void deleteByEmail(String email);

    @Query(value = "select sum(flow) from tkio_flow where contract_code = ?1 and ds >= ?2 and ds <= ?3", nativeQuery = true)
    BigDecimal sumFlowByContractCodeAndDs(String code, String startDate, String endDate);
}
