package common.service.impl;

import common.model.*;
import common.repository.*;
import common.service.ShareIncomeService;
import dic.ContractStatusEnum;
import dic.RoleEnum;
import net.sf.json.JSONArray;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.Days;
import org.joda.time.Months;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import tkio.model.Account;
import tkio.repository.AccountRepository;
import tkio.repository.AppRepository;
import tkio.service.AccountFlowRestrictService;
import util.ContractBranchUtil;
import util.DateUtil;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Service
public class ShareIncomeServiceImpl implements ShareIncomeService {

    private final Logger logger = LoggerFactory.getLogger(ShareIncomeServiceImpl.class);

    @Autowired
    private ContractRepository contractRepository;
    @Autowired
    private AuthRepository authRepository;
    @Autowired
    private ContractBodyRepository contractBodyRepository;
    @Autowired
    private ContractChangeRepository contractChangeRepository;
    @Autowired
    private BarrioCityRepository barrioCityRepository;
    @Autowired
    private AppRepository appRepository;
    @Autowired
    private AccountRepository accountRepository;
    @Autowired
    private AccountFlowRestrictService accountFlowRestrictService;
    @Autowired
    private PackageBaseRepository packageBaseRepository;
    @Autowired
    private TkioFlowRepository tkioFlowRepository;

    @Override
    public List<Contract> shareIncomeList(User loginAccount, String startDate, String endDate, String platform, String bodyCode, String serchName) {

        List<Contract> contracts = new ArrayList<>();

        if ("all".equals(bodyCode)) {
            bodyCode = null;
        }

        List<String> financeBodies = null;
        if (RoleEnum.FINANCE.getKey().equals(loginAccount.getRole())) {
            Auth auth = authRepository.findByUser(loginAccount.getId());
            financeBodies = JSONArray.fromObject(auth.getAuthExtend());
        }

        if (!StringUtils.isEmpty(bodyCode) && !StringUtils.isEmpty(serchName)) {

            if (financeBodies != null && !financeBodies.contains(bodyCode)) {
                //沒有权限查看
                return contracts;
            } else {
                contracts = contractRepository.findShareContranctByDate1(startDate, endDate, platform, bodyCode, serchName);
            }

        } else if (!StringUtils.isEmpty(bodyCode)) {
            if (financeBodies != null && !financeBodies.contains(bodyCode)) {
                //沒有权限查看
                return contracts;
            } else {
                contracts = contractRepository.findShareContranctByDate2(startDate, endDate, platform, bodyCode);
            }
        } else if (!StringUtils.isEmpty(serchName)) {
            if (financeBodies != null) {
                contracts = contractRepository.findShareContranctByDateSercheFinace(startDate, endDate, platform, serchName, financeBodies);
            } else {
                contracts = contractRepository.findShareContranctByDateSerche(startDate, endDate, platform, serchName);
            }
        } else {
            if (financeBodies != null) {
                contracts = contractRepository.findShareContranctByDateFinace(startDate, endDate, platform, financeBodies);
            } else {
                contracts = contractRepository.findShareContranctByDate3(startDate, endDate, platform);
            }
        }

        /*contracts = new ArrayList<>();
        contracts.add(contractRepository.findOne(4603L));*/

        List<ContractBody> bodies = contractBodyRepository.findAll();
        Map<String, String> bodiesNameMap = bodies.stream().collect(
                Collectors.toMap(ContractBody::getCode, ContractBody::getName, (v1, v2) -> v1));

        List<BarrioCity> barrioCities = barrioCityRepository.findAll();
        Map<Long, BarrioCity> barrioCitiesNameMap = barrioCities.stream().collect(Collectors.toMap(BarrioCity::getId, Function.identity(), (v1, v2) -> v1));

        List<PackageBase> packageBases = packageBaseRepository.findByPlatAndStatus(platform, 1);
        Map<Long, PackageBase> packageBaseMap = packageBases.stream().collect(Collectors.toMap(PackageBase::getId, Function.identity(), (v1, v2) -> v1));

        DateTime start = new DateTime(startDate);
        DateTime end = new DateTime(endDate);

        long start_ = System.currentTimeMillis();
//        for (Contract contract : contracts) {
//            this.shareIncome4Contract(contract, start, end);
//            contract.setMyBodyName(bodiesNameMap.get(contract.getMyBodyCode()));
//        }

        try (Stream<Contract> streamContract = contracts.parallelStream()) {
            streamContract.forEachOrdered(v -> {

                switch (ContractBranchUtil.getValue(platform)){
                    case "type_one":this.shareIncome4Contract(v, start, end);break;
                    case "type_two":
                        if(v.getPriceLevel()==20){
                            //TKIO不限量套餐
                            this.shareIncome4Contract(v, start, end);
                        }else{
                            //TKIO普通流量套餐
                            //this.shareIncome4ContractTwo(v, start, end);
                            this.shareIncome4ContractTKIO(v, start, end);
                        }
                        break;
                    default:this.shareIncome4Contract(v, start, end);break;
                }
                v.setMyBodyName(bodiesNameMap.get(v.getMyBodyCode()));
                if(v.getBarrioId()!=null)
                v.setBarrioName(barrioCitiesNameMap.get(barrioCitiesNameMap.get(v.getBarrioId()).getParentId()).getName());
                if(v.getPriceLevel()!=null)
                    v.setPriceLevelName(packageBaseMap.get(v.getPriceLevel()).getPackageName());
            });
        }
        logger.info("计算分摊收入耗时:{}", (System.currentTimeMillis() - start_));

        return contracts;
    }

    private void shareIncome4ContractTKIO(Contract contract, DateTime start, DateTime end) {
        DateTime[] selected = new DateTime[]{
                start,
                end};//用户筛选开始/结束日期
        DateTime[] contractPart = new DateTime[]{
                new DateTime(contract.getStartDate()),
                new DateTime(contract.getEndDate())};//合同开始结束 时间
        DateTime[] usePart = new DateTime[]{
                selected[0].compareTo(contractPart[0]) <= 0 ? contractPart[0] : selected[0],
                selected[1].compareTo(contractPart[1]) >= 0 ? contractPart[1] : selected[1]
        };
        usePart[0] = usePart[0].compareTo(usePart[1]) >= 0 ? usePart[1] : usePart[0];

        Long excludTax = new BigDecimal(contract.getMoney() / 1.06)
                .setScale(2, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100L)).longValue();//不含税收入*100
        contract.setIncomeExcludingTax(excludTax);

        //计算单价,精准保留16位数
        BigDecimal unitPriceAccurate = new BigDecimal(contract.getMoney()/1.06/contract.getTrackFlow())
                .setScale(16, BigDecimal.ROUND_HALF_UP);
        //四舍五入单价
        double unitPrice = unitPriceAccurate.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
        //不限量套餐会在方法里面重新赋值单价
        contract.setUnitPrice(unitPrice);
        //作废合同  累计收入= 0
        //中止合同  累计收入= 如果中止日期在选择日期之内，【合同开始日期-中止日期】，否则【合同开始日期-选择结束日期】，不需要考虑调整金
        //晚录合同  累计收入= 同下
        //正常合同  累计收入= 如果合同结束日期在选择日期之内，则直接取 [合同金额/1.06]得到总金额 ，否则 【合同开始日期-选择结束日期】
        //作废合同处理
        Contract cancleContract = this.cancledShareFlow(contract, unitPriceAccurate, usePart);
        if (cancleContract != null) {
            return;
        }
        //中止合同处理
        Contract suspendContract = this.suspendShareFlow(contract, unitPriceAccurate,contractPart, usePart, selected);
        if (suspendContract != null) {
            return;
        }
        //晚录合同处理//正常合同处理
        DateTime create = new DateTime(new DateTime(contract.getCreateTime()).toString("yyyy-MM-dd")); //录入时间点
        DateTime[] creatPoints = new DateTime[]{
                create, //录入日
                create.dayOfMonth().withMinimumValue() //录入月1日
        };
        this.afterContractFlow(contract,unitPriceAccurate, contractPart, usePart, selected, creatPoints);
    }

    private void afterContractFlow(Contract contract, BigDecimal unitPriceAccurate, DateTime[] contractPart, DateTime[] usePart, DateTime[] selected, DateTime[] creatPoints) {
        Long adjustmentFund = 0L;//调整金
        contract.setClickFlow(0.0);
        boolean isLateContract = false; // 是否为晚录合同（为了兼容历史数据 此处做冗余判断）
        if (ContractStatusEnum.LATE.getKey().equals(contract.getStatus())) {
            isLateContract = true;
        } else if (checkLateContract(contractPart[0], creatPoints[0])) {
            isLateContract = true;
            contract.setStatus(ContractStatusEnum.LATE.getKey());
        }

        boolean isLater = true;
        if (!isLateContract) {
            //非合同晚录
            BigDecimal clickNum = tkioFlowRepository.sumFlowByContractCodeAndDs(contract.getContractCode(),usePart[0].toString("yyyy-MM-dd"),usePart[1].toString("yyyy-MM-dd"));
            int clickFlow = clickNum==null?0:clickNum.intValue();
            BigDecimal clickTenThousand = new BigDecimal(0);

            if(clickFlow!=0){
                clickTenThousand = new BigDecimal(clickFlow / 10000.0 * 100);
                //区间点击数
                contract.setClickFlow(new BigDecimal(clickFlow / 10000.0).setScale(4,BigDecimal.ROUND_HALF_UP).doubleValue());
            }
            //区间分摊收入
            contract.setIntervaIncomeShare(unitPriceAccurate.multiply(clickTenThousand).setScale(0, BigDecimal.ROUND_HALF_UP).longValue());

            contract.setAdjustmentFund(0L);
            contract.setIncomeShareAll(contract.getIntervaIncomeShare());

            if(checkTwoTime(selected[0],contractPart[1]) && checkTwoTime(contractPart[1],selected[1])){
                contract.setIncomeGross(contract.getIncomeExcludingTax());
            }else{
                //累计总收入
                clickNum = tkioFlowRepository.sumFlowByContractCodeAndDs(contract.getContractCode(),contractPart[0].toString("yyyy-MM-dd"),selected[1].toString("yyyy-MM-dd"));
                clickFlow = clickNum==null?0:clickNum.intValue();
                contract.setIncomeGross(unitPriceAccurate.multiply(new BigDecimal(clickFlow / 10000.0 * 100)).setScale(0, BigDecimal.ROUND_HALF_UP).longValue());
            }

            isLater = false;
        } else if (selected[1].isBefore(creatPoints[1])) {
            //录入月1号之前 调整金为 0 分摊为 0
            contract.setIntervaIncomeShare(0L);
            contract.setAdjustmentFund(0L);
            contract.setIncomeShareAll(contract.getIntervaIncomeShare());
            BigDecimal clickNum = tkioFlowRepository.sumFlowByContractCodeAndDs(contract.getContractCode(),usePart[0].toString("yyyy-MM-dd"),usePart[1].toString("yyyy-MM-dd"));
            int clickFlow = clickNum==null?0:clickNum.intValue();
            contract.setClickFlow(new BigDecimal(clickFlow / 10000.0).setScale(4,BigDecimal.ROUND_HALF_UP).doubleValue());
            contract.setIncomeGross(0L);
            contract.setStatus(ContractStatusEnum.LATE.getKey());
        } else {
            contract.setStatus(ContractStatusEnum.LATE.getKey());
            //合同晚录
            //所选时间范围内的分摊收入(录入月1号 即creatPoints[1] 开始计算)
            DateTime useStart = creatPoints[1].compareTo(selected[0]) >= 0 ? creatPoints[1] : selected[0];

            BigDecimal clickNum = tkioFlowRepository.sumFlowByContractCodeAndDs(contract.getContractCode(),useStart.toString("yyyy-MM-dd"),usePart[1].toString("yyyy-MM-dd"));
            int clickFlow = clickNum==null?0:clickNum.intValue();
            BigDecimal clickTenThousand = new BigDecimal(0);

            if(clickFlow!=0){
                clickTenThousand = new BigDecimal(clickFlow / 10000.0 * 100);
                //区间点击数
                BigDecimal clickNumReal = tkioFlowRepository.sumFlowByContractCodeAndDs(contract.getContractCode(),selected[0].toString("yyyy-MM-dd"),usePart[1].toString("yyyy-MM-dd"));
                int clickNumRealFlow = clickNumReal==null?0:clickNumReal.intValue();
                contract.setClickFlow(new BigDecimal(clickNumRealFlow / 10000.0).setScale(4,BigDecimal.ROUND_HALF_UP).doubleValue());
            }
            //区间分摊收入
            contract.setIntervaIncomeShare(unitPriceAccurate.multiply(clickTenThousand).setScale(0, BigDecimal.ROUND_HALF_UP).longValue());


            if (checkTwoTime(selected[0], creatPoints[1]) && checkTwoTime(creatPoints[1], selected[1])) {
                //所选时间范围包含 录入月 1 号 显示统计的调整金
                //合同开始日期，合同录入日期的一号，-1就是上个月最后一天
                //contractPart[0], creatPoints[1].plusDays(-1)
                clickNum = tkioFlowRepository.sumFlowByContractCodeAndDs(contract.getContractCode(),contractPart[0].toString("yyyy-MM-dd"),creatPoints[1].plusDays(-1).toString("yyyy-MM-dd"));
                clickFlow = clickNum==null?0:clickNum.intValue();
                clickTenThousand = new BigDecimal(0);
                if(clickFlow!=0){
                    clickTenThousand = new BigDecimal(clickFlow / 10000.0 * 100);
                    //区间点击数
                }
                contract.setAdjustmentFund(unitPriceAccurate.multiply(clickTenThousand).setScale(0, BigDecimal.ROUND_HALF_UP).longValue());
            } else {
                contract.setAdjustmentFund(0L);
            }

            if(checkTwoTime(selected[0],contractPart[1]) && checkTwoTime(contractPart[1],selected[1])){
                contract.setIncomeGross(contract.getIncomeExcludingTax());
            }else{
                //累计总收入
                clickNum = tkioFlowRepository.sumFlowByContractCodeAndDs(contract.getContractCode(),contractPart[0].toString("yyyy-MM-dd"),selected[1].plusDays(-1).toString("yyyy-MM-dd"));
                clickFlow = clickNum==null?0:clickNum.intValue();
                contract.setIncomeGross(unitPriceAccurate.multiply(new BigDecimal(clickFlow / 10000.0 * 100)).setScale(0, BigDecimal.ROUND_HALF_UP).longValue());
            }
        }

        if (checkTwoTime(contractPart[1], selected[1])) {
            //最后一日分摊收入计算处理(合同的最后一天，不管流量剩余多少，都算作做最后一天的收入)
            Long lastDay;
            DateTime lastDate[];
            if (isLater) {
                lastDate = new  DateTime[]{creatPoints[1],contractPart[1].plusDays(-1)};
            } else {
                lastDate = new  DateTime[]{contractPart[0],contractPart[1].plusDays(-1)};
            }
            //合同除去最后一天的流量
            BigDecimal clickNum = tkioFlowRepository.sumFlowByContractCodeAndDs(contract.getContractCode(),lastDate[0].toString("yyyy-MM-dd"),lastDate[1].plusDays(-1).toString("yyyy-MM-dd"));
            int clickFlow = clickNum==null?0:clickNum.intValue();
            BigDecimal clickTenThousand = new BigDecimal(0);
            if(clickFlow!=0){
                clickTenThousand = new BigDecimal(clickFlow / 10000.0 * 100);
            }
            long beforeTheMoney = unitPriceAccurate.multiply(clickTenThousand).setScale(0, BigDecimal.ROUND_HALF_UP).longValue();

            //最后一天的流量
            clickNum = tkioFlowRepository.sumFlowByContractCodeAndDs(contract.getContractCode(),contractPart[1].toString("yyyy-MM-dd"),contractPart[1].plusDays(-1).toString("yyyy-MM-dd"));
            clickFlow = clickNum==null?0:clickNum.intValue();
            clickTenThousand = new BigDecimal(0);
            if(clickFlow!=0)clickTenThousand = new BigDecimal(clickFlow / 10000.0 * 100);
            long lastDayTheMoney = unitPriceAccurate.multiply(clickTenThousand).setScale(0, BigDecimal.ROUND_HALF_UP).longValue();
            //合同的税后总金额减去最后合同一日之前的钱和调整金
            lastDay = contract.getIncomeExcludingTax() - contract.getAdjustmentFund() - beforeTheMoney;
            //最后一日 或 包含最后一日 时
            contract.setIntervaIncomeShare(contract.getIntervaIncomeShare() - lastDayTheMoney + lastDay);
        }

        contract.setIncomeShareAll(contract.getIntervaIncomeShare() + contract.getAdjustmentFund());
    }

    private Contract suspendShareFlow(Contract contract, BigDecimal unitPriceAccurate, DateTime[] contractPart, DateTime[] usePart, DateTime[] selected) {
        if (!ContractStatusEnum.SUSPEND.getKey().equals(contract.getStatus())) {
            return null;
        }
        ContractChange contractChange = contractChangeRepository.findByContentCode(ContractStatusEnum.SUSPEND.getValue(),
                contract.getContractCode());

        if (contractChange == null) {
            contract.setAdjustmentFund(0L);
            contract.setIntervaIncomeShare(0L);
            contract.setIncomeShareAll(0L);
            contract.setClickFlow(0.0);
            return contract;
        }
        // 合同中止日
        DateTime cancelDate = new DateTime(contractChange.getDs());

        //中止操作入库时间
        DateTime suspendDate = new DateTime(new DateTime(contractChange.getCreateTime()).toString("yyyy-MM-dd"));
        contract.setClickFlow(0.0);
        //调整金
        Long adjustmentFund = 0L;
        if (checkTwoTime(suspendDate, cancelDate)) {
            adjustmentFund = 0L;
        } else {
            //查询调整金的点击，日期开始结束时间注意不能颠倒

            BigDecimal clickNum = tkioFlowRepository.sumFlowByContractCodeAndDs(contract.getContractCode(),cancelDate.toString("yyyy-MM-dd"),suspendDate.toString("yyyy-MM-dd"));
            int clickFlow = clickNum==null?0:clickNum.intValue();

            BigDecimal clickTenThousand = new BigDecimal(0);
            if(clickFlow!=0){
                clickTenThousand = new BigDecimal(clickFlow / 10000.0 * 100);
            }
            adjustmentFund = unitPriceAccurate.multiply(clickTenThousand.multiply(new BigDecimal(-1))).setScale(0, BigDecimal.ROUND_HALF_UP).longValue();
        }
        //调整金
        contract.setAdjustmentFund(adjustmentFund);
        DateTime usedEnd = usePart[1].compareTo(cancelDate) <= 0 ? usePart[1] : cancelDate;
        //查询开始->中止日期的点击(有收入的点击)，不包括调整金
        BigDecimal clickNum = tkioFlowRepository.sumFlowByContractCodeAndDs(contract.getContractCode(),usePart[0].toString("yyyy-MM-dd"),usedEnd.toString("yyyy-MM-dd"));
        int clickFlow = clickNum==null?0:clickNum.intValue();
        BigDecimal clickTenThousand = new BigDecimal(0);
        if(clickFlow!=0){
            clickTenThousand = new BigDecimal(clickFlow / 10000.0 * 100);
            //区间点击数
            contract.setClickFlow(new BigDecimal(clickFlow / 10000.0).setScale(4,BigDecimal.ROUND_HALF_UP).doubleValue());
        }
        //区间分摊收入,乘以100，前端除以100
        long share = unitPriceAccurate.multiply(clickTenThousand).setScale(0, BigDecimal.ROUND_HALF_UP).longValue();
        contract.setIntervaIncomeShare(share);
        contract.setIncomeShareAll(share+adjustmentFund);

        if(checkTwoTime(selected[0],contractPart[1]) && checkTwoTime(contractPart[1],selected[1])){
            contract.setIncomeGross(contract.getIncomeExcludingTax());
        }else{
            //累计总收入
            clickNum = tkioFlowRepository.sumFlowByContractCodeAndDs(contract.getContractCode(),contractPart[0].toString("yyyy-MM-dd"),selected[1].toString("yyyy-MM-dd"));
            clickFlow = clickNum==null?0:clickNum.intValue();
            contract.setIncomeGross(unitPriceAccurate.multiply(new BigDecimal(clickFlow / 10000.0 * 100)).setScale(0, BigDecimal.ROUND_HALF_UP).longValue());
        }
        return contract;
    }

    private Contract cancledShareFlow(Contract contract, BigDecimal unitPriceAccurate, DateTime[] usePart) {
        if (!ContractStatusEnum.CANCEL.getKey().equals(contract.getStatus())) {
            return null;
        }
        ContractChange contractChange = contractChangeRepository.findByContentCode(ContractStatusEnum.CANCEL.getValue(), contract.getContractCode());
        if (contractChange == null) {
            contract.setAdjustmentFund(0L);
            contract.setIntervaIncomeShare(0L);
            contract.setIncomeShareAll(0L);
            contract.setClickFlow(0.0);
            return contract;
        }

        DateTime cancelDate = new DateTime(contractChange.getDs());//合同作废日
        DateTime usedEnd = usePart[1].compareTo(cancelDate) <= 0 ? usePart[1] : cancelDate;


        BigDecimal clickNum = tkioFlowRepository.sumFlowByContractCodeAndDs(contract.getContractCode(),usePart[0].toString("yyyy-MM-dd"),usedEnd.toString("yyyy-MM-dd"));
        int clickFlow = clickNum==null?0:clickNum.intValue();
        //区间点击数
        contract.setClickFlow(0.0);
        BigDecimal clickTenThousand = new BigDecimal(0);
        if(clickFlow!=0){
            clickTenThousand = new BigDecimal(clickFlow / 10000.0 * 100);
            //区间点击数
            contract.setClickFlow(new BigDecimal(clickFlow / 10000.0).setScale(4,BigDecimal.ROUND_HALF_UP).doubleValue());
        }
        //区间分摊收入,乘以100，前端除以100
        long share = unitPriceAccurate.multiply(clickTenThousand).setScale(0, BigDecimal.ROUND_HALF_UP).longValue();
        contract.setIntervaIncomeShare(share);
        //调整金
        contract.setAdjustmentFund(share*-1L);
        //分摊总收入
        contract.setIncomeShareAll(0L);
        contract.setIncomeGross(0L);
        return contract;
    }

    //需求禅道 1608
    public void shareIncome4ContractTwo(Contract contract, DateTime start, DateTime end) {
        DateTime[] selected = new DateTime[]{
                start,
                end};//用户筛选开始/结束日期
        DateTime[] contractPart = new DateTime[]{
                new DateTime(contract.getStartDate()),
                new DateTime(contract.getEndDate())};//合同开始结束 时间
        DateTime[] usePart = new DateTime[]{
                selected[0].compareTo(contractPart[0]) <= 0 ? contractPart[0] : selected[0],
                selected[1].compareTo(contractPart[1]) >= 0 ? contractPart[1] : selected[1]
        };
        usePart[0] = usePart[0].compareTo(usePart[1]) >= 0 ? usePart[1] : usePart[0];

        Long excludTax = new BigDecimal(contract.getMoney() / 1.06)
                .setScale(2, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100L)).longValue();//不含税收入*100
        contract.setIncomeExcludingTax(excludTax);

        //计算单价,精准保留16位数
        BigDecimal unitPriceAccurate = new BigDecimal(contract.getMoney()/1.06/contract.getTrackFlow())
                .setScale(16, BigDecimal.ROUND_HALF_UP);
        //四舍五入单价
        double unitPrice = unitPriceAccurate.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
        //不限量套餐会在方法里面重新赋值单价
        contract.setUnitPrice(unitPrice);
        //查询用户下所有appkey
        Account account = accountRepository.findByEmail(contract.getEmail());
        List<Account> accountList = accountRepository.findByRootParent(account.getRootParent());
        List<Long> idList = new ArrayList<>();
        for (Account ac : accountList) {
            idList.add(ac.getId());
        }
        List<String> appkeys = appRepository.findAppkeysNotDebug(idList);
        String appkeyStr = String.join("','", appkeys);
        appkeyStr= "'"+appkeyStr+"'";

        //作废合同  累计收入= 0
        //中止合同  累计收入= 如果中止日期在选择日期之内，【合同开始日期-中止日期】，否则【合同开始日期-选择结束日期】，不需要考虑调整金
        //晚录合同  累计收入= 同下
        //正常合同  累计收入= 如果合同结束日期在选择日期之内，则直接取 [合同金额/1.06]得到总金额 ，否则 【合同开始日期-选择结束日期】

        //作废合同处理
        Contract cancleContract = this.cancledShareTKIO(contract, appkeyStr, unitPriceAccurate, usePart);
        if (cancleContract != null) {
            return;
        }

        //中止合同处理
        Contract suspendContract = this.suspendShareTKIO(contract, appkeyStr, unitPriceAccurate,contractPart, usePart, selected);
        if (suspendContract != null) {
            return;
        }

        //晚录合同处理//正常合同处理
        DateTime create = new DateTime(new DateTime(contract.getCreateTime()).toString("yyyy-MM-dd")); //录入时间点
        DateTime[] creatPoints = new DateTime[]{
                create, //录入日
                create.dayOfMonth().withMinimumValue() //录入月1日
        };
        this.afterContractTKIO(contract, appkeyStr,unitPriceAccurate, contractPart, usePart, selected, creatPoints);




    }

    private void afterContractTKIO(Contract contract, String appkeyStr,BigDecimal unitPriceAccurate, DateTime[] contractPart,DateTime[] usePart, DateTime[] selected, DateTime[] creatPoints) {


        Long adjustmentFund = 0L;//调整金
        contract.setClickFlow(0.0);
        boolean isLateContract = false; // 是否为晚录合同（为了兼容历史数据 此处做冗余判断）
        if (ContractStatusEnum.LATE.getKey().equals(contract.getStatus())) {
            isLateContract = true;
        } else if (checkLateContract(contractPart[0], creatPoints[0])) {
            isLateContract = true;
            contract.setStatus(ContractStatusEnum.LATE.getKey());
        }

        boolean isLater = true;
        if (!isLateContract) {
            //非合同晚录
            BigInteger clickNum = accountFlowRestrictService.getTotalNum(usePart[0].toString("yyyy-MM-dd"), usePart[1].toString("yyyy-MM-dd"), appkeyStr, "account_track_flow_restrict", "click_sum");
            int clickFlow = clickNum==null?0:clickNum.intValue();
            BigDecimal clickTenThousand = new BigDecimal(0);

            if(clickFlow!=0){
                clickTenThousand = new BigDecimal(clickFlow / 10000.0 * 100);
                //区间点击数
                contract.setClickFlow(new BigDecimal(clickFlow / 10000.0).setScale(4,BigDecimal.ROUND_HALF_UP).doubleValue());
            }
            //区间分摊收入
            contract.setIntervaIncomeShare(unitPriceAccurate.multiply(clickTenThousand).setScale(0, BigDecimal.ROUND_HALF_UP).longValue());

            contract.setAdjustmentFund(0L);
            contract.setIncomeShareAll(contract.getIntervaIncomeShare());

            if(checkTwoTime(selected[0],contractPart[1]) && checkTwoTime(contractPart[1],selected[1])){
                contract.setIncomeGross(contract.getIncomeExcludingTax());
            }else{
                //累计总收入
                clickNum = accountFlowRestrictService.getTotalNum(contractPart[0].toString("yyyy-MM-dd"), selected[1].toString("yyyy-MM-dd"), appkeyStr, "account_track_flow_restrict", "click_sum");
                clickFlow = clickNum==null?0:clickNum.intValue();
                contract.setIncomeGross(unitPriceAccurate.multiply(new BigDecimal(clickFlow / 10000.0 * 100)).setScale(0, BigDecimal.ROUND_HALF_UP).longValue());
            }

            isLater = false;
        } else if (selected[1].isBefore(creatPoints[1])) {
            //录入月1号之前 调整金为 0 分摊为 0
            contract.setIntervaIncomeShare(0L);
            contract.setAdjustmentFund(0L);
            contract.setIncomeShareAll(contract.getIntervaIncomeShare());
            contract.setClickFlow(0.0);
            contract.setIncomeGross(0L);
            contract.setStatus(ContractStatusEnum.LATE.getKey());
        } else {
            contract.setStatus(ContractStatusEnum.LATE.getKey());
            //合同晚录
            //所选时间范围内的分摊收入(录入月1号 即creatPoints[1] 开始计算)
            DateTime useStart = creatPoints[1].compareTo(selected[0]) >= 0 ? creatPoints[1] : selected[0];

            BigInteger clickNum = accountFlowRestrictService.getTotalNum(useStart.toString("yyyy-MM-dd"), usePart[1].toString("yyyy-MM-dd"), appkeyStr, "account_track_flow_restrict", "click_sum");
            int clickFlow = clickNum==null?0:clickNum.intValue();
            BigDecimal clickTenThousand = new BigDecimal(0);

            if(clickFlow!=0){
                clickTenThousand = new BigDecimal(clickFlow / 10000.0 * 100);
                //区间点击数
                System.out.println(new BigDecimal(clickFlow / 10000.0));
                contract.setClickFlow(new BigDecimal(clickFlow / 10000.0).setScale(4,BigDecimal.ROUND_HALF_UP).doubleValue());
            }
            //区间分摊收入
            contract.setIntervaIncomeShare(unitPriceAccurate.multiply(clickTenThousand).setScale(0, BigDecimal.ROUND_HALF_UP).longValue());


            if (checkTwoTime(selected[0], creatPoints[1]) && checkTwoTime(creatPoints[1], selected[1])) {
                //所选时间范围包含 录入月 1 号 显示统计的调整金
                //合同开始日期，合同录入日期的一号，-1就是上个月最后一天
                //contractPart[0], creatPoints[1].plusDays(-1)
                clickNum = accountFlowRestrictService.getTotalNum(contractPart[0].toString("yyyy-MM-dd"),creatPoints[1].plusDays(-1).toString("yyyy-MM-dd"), appkeyStr, "account_track_flow_restrict", "click_sum");
                clickFlow = clickNum==null?0:clickNum.intValue();
                clickTenThousand = new BigDecimal(0);
                if(clickFlow!=0){
                    clickTenThousand = new BigDecimal(clickFlow / 10000.0 * 100);
                    //区间点击数
                }
                contract.setAdjustmentFund(unitPriceAccurate.multiply(clickTenThousand).setScale(0, BigDecimal.ROUND_HALF_UP).longValue());
            } else {
                contract.setAdjustmentFund(0L);
            }

            if(checkTwoTime(selected[0],contractPart[1]) && checkTwoTime(contractPart[1],selected[1])){
                contract.setIncomeGross(contract.getIncomeExcludingTax());
            }else{
                //累计总收入
                clickNum = accountFlowRestrictService.getTotalNum(contractPart[0].toString("yyyy-MM-dd"), selected[1].toString("yyyy-MM-dd"), appkeyStr, "account_track_flow_restrict", "click_sum");
                clickFlow = clickNum==null?0:clickNum.intValue();
                contract.setIncomeGross(unitPriceAccurate.multiply(new BigDecimal(clickFlow / 10000.0 * 100)).setScale(0, BigDecimal.ROUND_HALF_UP).longValue());
            }
        }

        if (checkTwoTime(contractPart[1], selected[1])) {
            //最后一日分摊收入计算处理(合同的最后一天，不管流量剩余多少，都算作做最后一天的收入)
            Long lastDay;
            DateTime lastDate[];
            if (isLater) {
                lastDate = new  DateTime[]{creatPoints[1],contractPart[1].plusDays(-1)};
            } else {
                lastDate = new  DateTime[]{contractPart[0],contractPart[1].plusDays(-1)};
            }
            //合同除去最后一天的流量
            BigInteger clickNum = accountFlowRestrictService.getTotalNum(lastDate[0].toString("yyyy-MM-dd"), lastDate[1].toString("yyyy-MM-dd"), appkeyStr, "account_track_flow_restrict", "click_sum");
            int clickFlow = clickNum==null?0:clickNum.intValue();
            BigDecimal clickTenThousand = new BigDecimal(0);
            if(clickFlow!=0){
                clickTenThousand = new BigDecimal(clickFlow / 10000.0 * 100);
            }
            long beforeTheMoney = unitPriceAccurate.multiply(clickTenThousand).setScale(0, BigDecimal.ROUND_HALF_UP).longValue();

            //最后一天的流量
            clickNum = accountFlowRestrictService.getTotalNum(contractPart[1].toString("yyyy-MM-dd"), contractPart[1].toString("yyyy-MM-dd"), appkeyStr, "account_track_flow_restrict", "click_sum");
            clickFlow = clickNum==null?0:clickNum.intValue();
            clickTenThousand = new BigDecimal(0);
            if(clickFlow!=0)clickTenThousand = new BigDecimal(clickFlow / 10000.0 * 100);
            long lastDayTheMoney = unitPriceAccurate.multiply(clickTenThousand).setScale(0, BigDecimal.ROUND_HALF_UP).longValue();
            //合同的税后总金额减去最后合同一日之前的钱和调整金
            lastDay = contract.getIncomeExcludingTax() - contract.getAdjustmentFund() - beforeTheMoney;
            //最后一日 或 包含最后一日 时
            contract.setIntervaIncomeShare(contract.getIntervaIncomeShare() - lastDayTheMoney + lastDay);
        }

        contract.setIncomeShareAll(contract.getIntervaIncomeShare() + contract.getAdjustmentFund());

    }

    private Contract suspendShareTKIO(Contract contract, String appkeys, BigDecimal unitPriceAccurate,DateTime[] contractPart, DateTime[] usePart,DateTime[] selected) {
        if (!ContractStatusEnum.SUSPEND.getKey().equals(contract.getStatus())) {
            return null;
        }
        ContractChange contractChange = contractChangeRepository.findByContentCode(ContractStatusEnum.SUSPEND.getValue(),
                contract.getContractCode());

        if (contractChange == null) {
            contract.setAdjustmentFund(0L);
            contract.setIntervaIncomeShare(0L);
            contract.setIncomeShareAll(0L);
            contract.setClickFlow(0.0);
            return contract;
        }
        // 合同中止日
        DateTime cancelDate = new DateTime(contractChange.getDs());

        //中止操作入库时间
        DateTime suspendDate = new DateTime(new DateTime(contractChange.getCreateTime()).toString("yyyy-MM-dd"));
        contract.setClickFlow(0.0);
        //调整金
        Long adjustmentFund = 0L;
        if (checkTwoTime(suspendDate, cancelDate)) {
            adjustmentFund = 0L;
        } else {
            //查询调整金的点击，日期开始结束时间注意不能颠倒
            BigInteger clickNum = accountFlowRestrictService.getTotalNum(cancelDate.toString("yyyy-MM-dd"), suspendDate.toString("yyyy-MM-dd"), appkeys, "account_track_flow_restrict", "click_sum");
            int clickFlow = clickNum==null?0:clickNum.intValue();

            BigDecimal clickTenThousand = new BigDecimal(0);
            if(clickFlow!=0){
                clickTenThousand = new BigDecimal(clickFlow / 10000.0 * 100);
            }
            adjustmentFund = unitPriceAccurate.multiply(clickTenThousand.multiply(new BigDecimal(-1))).setScale(0, BigDecimal.ROUND_HALF_UP).longValue();
        }
        //调整金
        contract.setAdjustmentFund(adjustmentFund);
        DateTime usedEnd = usePart[1].compareTo(cancelDate) <= 0 ? usePart[1] : cancelDate;
        //查询开始->中止日期的点击(有收入的点击)，不包括调整金
        BigInteger clickNum = accountFlowRestrictService.getTotalNum(usePart[0].toString("yyyy-MM-dd"), usedEnd.toString("yyyy-MM-dd"), appkeys, "account_track_flow_restrict", "click_sum");
        int clickFlow = clickNum==null?0:clickNum.intValue();
        BigDecimal clickTenThousand = new BigDecimal(0);
        if(clickFlow!=0){
            clickTenThousand = new BigDecimal(clickFlow / 10000.0 * 100);
            //区间点击数
            contract.setClickFlow(new BigDecimal(clickFlow / 10000.0).setScale(4,BigDecimal.ROUND_HALF_UP).doubleValue());
        }
        //区间分摊收入,乘以100，前端除以100
        long share = unitPriceAccurate.multiply(clickTenThousand).setScale(0, BigDecimal.ROUND_HALF_UP).longValue();
        contract.setIntervaIncomeShare(share);
        contract.setIncomeShareAll(share+adjustmentFund);

        if(checkTwoTime(selected[0],contractPart[1]) && checkTwoTime(contractPart[1],selected[1])){
            contract.setIncomeGross(contract.getIncomeExcludingTax());
        }else{
            //累计总收入
            clickNum = accountFlowRestrictService.getTotalNum(contractPart[0].toString("yyyy-MM-dd"), selected[1].toString("yyyy-MM-dd"), appkeys, "account_track_flow_restrict", "click_sum");
            clickFlow = clickNum==null?0:clickNum.intValue();
            contract.setIncomeGross(unitPriceAccurate.multiply(new BigDecimal(clickFlow / 10000.0 * 100)).setScale(0, BigDecimal.ROUND_HALF_UP).longValue());
        }
        return contract;
    }

    private Contract cancledShareTKIO(Contract contract, String appkeys, BigDecimal unitPriceAccurate,DateTime[] usePart) {
        if (!ContractStatusEnum.CANCEL.getKey().equals(contract.getStatus())) {
            return null;
        }
        ContractChange contractChange = contractChangeRepository.findByContentCode(ContractStatusEnum.CANCEL.getValue(), contract.getContractCode());
        if (contractChange == null) {
            contract.setAdjustmentFund(0L);
            contract.setIntervaIncomeShare(0L);
            contract.setIncomeShareAll(0L);
            contract.setClickFlow(0.0);
            return contract;
        }

        DateTime cancelDate = new DateTime(contractChange.getDs());//合同作废日
        DateTime usedEnd = usePart[1].compareTo(cancelDate) <= 0 ? usePart[1] : cancelDate;

        BigInteger clickNum = accountFlowRestrictService.getTotalNum(usePart[0].toString("yyyy-MM-dd"), usedEnd.toString("yyyy-MM-dd"), appkeys, "account_track_flow_restrict", "click_sum");
        int clickFlow = clickNum==null?0:clickNum.intValue();
        //区间点击数
        contract.setClickFlow(0.0);
        BigDecimal clickTenThousand = new BigDecimal(0);
        if(clickFlow!=0){
            clickTenThousand = new BigDecimal(clickFlow / 10000.0 * 100);
            //区间点击数
            contract.setClickFlow(new BigDecimal(clickFlow / 10000.0).setScale(4,BigDecimal.ROUND_HALF_UP).doubleValue());
        }
        //区间分摊收入,乘以100，前端除以100
        long share = unitPriceAccurate.multiply(clickTenThousand).setScale(0, BigDecimal.ROUND_HALF_UP).longValue();
        contract.setIntervaIncomeShare(share);
        //调整金
        contract.setAdjustmentFund(share*-1L);
        //分摊总收入
        contract.setIncomeShareAll(0L);
        contract.setIncomeGross(0L);
        return contract;
    }

    public void shareIncome4Contract(Contract contract, DateTime start, DateTime end) {

        DateTime[] selected = new DateTime[]{
                start,
                end};//用户筛选开始/结束日期
        DateTime[] contractPart = new DateTime[]{
                new DateTime(contract.getStartDate()),
                new DateTime(contract.getEndDate())};//合同开始结束 时间
        DateTime[] usePart = new DateTime[]{
                selected[0].compareTo(contractPart[0]) <= 0 ? contractPart[0] : selected[0],
                selected[1].compareTo(contractPart[1]) >= 0 ? contractPart[1] : selected[1]
        };

        usePart[0] = usePart[0].compareTo(usePart[1]) >= 0 ? usePart[1] : usePart[0];

        contract.setIntervalUseDays(getDayRange(contractPart[0], usePart[1]) + 1);

        Long excludTax = new BigDecimal(contract.getMoney() / 1.06)
                .setScale(2, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100L)).longValue();//不含税收入*100
        contract.setIncomeExcludingTax(excludTax);
        int contractAllDay = getDayRange(contractPart[0], contractPart[1]) + 1;//合同总天数

        //处理精度
        BigDecimal dayShareIncome = new BigDecimal(excludTax * 1.0 / contractAllDay);

        if("tkio".equals(contract.getPlatform())){//设置tkio无限流量的日单价
            contract.setUnitPrice(dayShareIncome.divide(new BigDecimal(100)).setScale(2,BigDecimal.ROUND_HALF_UP).doubleValue());
        }

        //作废合同处理
        Contract cancleContract = this.cancledShare(contract, contractAllDay, dayShareIncome, contractPart, usePart, selected);
        if (cancleContract != null) {
            return;
        }

        //中止合同处理
        Contract suspendContract = this.suspendShare(contract, contractAllDay, dayShareIncome, contractPart, usePart, selected);
        if (suspendContract != null) {
            return;
        }

        //特殊合同处理
        Contract specilContract = this.specilContract(contract, dayShareIncome, contractPart, usePart, selected);
        if (specilContract != null) {
            return;
        }

        //晚录合同处理
        DateTime create = new DateTime(new DateTime(contract.getCreateTime()).toString("yyyy-MM-dd")); //录入时间点
        DateTime[] creatPoints = new DateTime[]{
                create, //录入日
                create.dayOfMonth().withMinimumValue() //录入月1日
        };

        this.afterContract(contract, contractAllDay, dayShareIncome, contractPart, usePart, selected, creatPoints);

    }


    private Contract specilContract(Contract contract, BigDecimal dayShareIncome, DateTime[] contractPart, DateTime[] usePart, DateTime[] selected) {

        if (!"QQ-ADI-20190729-57".equals(contract.getContractCode())) {
            return null;
        }

        /*19年不含税金额:24268.88
        已摊销天数：161
        20不含税金额：31202.8181132075
        未摊销天数：205
        合同日期2019.7.24-2020.7.23，
        合同编号：QQ-ADI-20190729-57*/

        DateTime[] middlePoiont = new DateTime[]{new DateTime("2019-12-31"), new DateTime("2020-01-01")};

        contract.setAdjustmentFund(0L);
        contract.setIncomeExcludingTax(new BigDecimal(24268.88 * 100).add(new BigDecimal(31202.8181132075 * 100))
                .setScale(2, BigDecimal.ROUND_HALF_UP).longValue());

        BigDecimal dayShare_19 = new BigDecimal(24268.88).multiply(new BigDecimal(100))
                .divide(new BigDecimal(161), 15, BigDecimal.ROUND_HALF_UP);

        //选择时间范围内 20 年分摊天数 及每天分摊
        BigDecimal dayShare_20 = new BigDecimal(31202.8181132075).multiply(new BigDecimal(100))
                .divide(new BigDecimal(205), 15, BigDecimal.ROUND_HALF_UP);

        if (checkTwoTime(usePart[0], middlePoiont[0]) && checkTwoTime(middlePoiont[1], usePart[1])) {
            //选择时间范围内 19 + 20  年分摊天数 及每天分摊
            Long allDayShare = dayShare_19.multiply(new BigDecimal(getDayRange(usePart[0], middlePoiont[0]) + 1))
                    .add(dayShare_20.multiply(new BigDecimal(getDayRange(middlePoiont[1], usePart[1]) + 1)))
                    .setScale(2, BigDecimal.ROUND_HALF_UP).longValue();
            contract.setIntervaIncomeShare(allDayShare);

        } else {

            int days = getDayRange(usePart[0], usePart[1]) + 1;
            if (checkTwoTime(usePart[1], middlePoiont[0])) {
                //19 年
                contract.setIntervaIncomeShare(shareMultiply(dayShare_19, new BigDecimal(days), 2));

            } else {
                //20 年
                contract.setIntervaIncomeShare(shareMultiply(dayShare_20, new BigDecimal(days), 2));

            }
        }

        contract.setIncomeShareAll(contract.getIntervaIncomeShare());
        return contract;

    }

    private void afterContract(Contract contract, int contractAllDay, BigDecimal dayShareIncome,
                               DateTime[] contractPart, DateTime[] usePart, DateTime[] selected, DateTime[] creatPoints) {

        int betweenMonth = Months.monthsBetween(contractPart[0], creatPoints[0]).getMonths();
        //时间范围内用于计算分摊金额的天数
        int daysIncom = getDayRange(usePart[0], usePart[1]) + 1;
        //区间分摊总收入
        contract.setIntervaIncomeShare(shareMultiply(dayShareIncome, new BigDecimal(daysIncom), 0));

        Long adjustmentFund = 0L;//调整金

        boolean isLateContract = false; // 是否为晚录合同（为了兼容历史数据 此处做冗余判断）
        if (ContractStatusEnum.LATE.getKey().equals(contract.getStatus())) {
            isLateContract = true;
        } else if (checkLateContract(contractPart[0], creatPoints[0])) {
            isLateContract = true;
        }

        if (isLateContract) {
            contract.setStatus(ContractStatusEnum.LATE.getKey());
        }

        boolean isLater = true;
        if (!isLateContract || betweenMonth < 1) {
            //非合同晚录
            contract.setAdjustmentFund(0L);
            contract.setIncomeShareAll(contract.getIntervaIncomeShare());
            isLater = false;


        } else if (selected[1].isBefore(creatPoints[1])) {
            //录入月1号之前 调整金为 0 分摊为 0
            contract.setIntervaIncomeShare(0L);
            contract.setAdjustmentFund(0L);
            contract.setIncomeShareAll(contract.getIntervaIncomeShare());
            contract.setStatus(ContractStatusEnum.LATE.getKey());
        } else {
            contract.setStatus(ContractStatusEnum.LATE.getKey());
            //合同晚录
            //所选时间范围内的分摊收入(录入月1号 即creatPoints[1] 开始计算)
            DateTime useStart = creatPoints[1].compareTo(selected[0]) >= 0 ? creatPoints[1] : selected[0];
            daysIncom = getDayRange(useStart, usePart[1]) + 1;

            contract.setIntervaIncomeShare(shareMultiply(dayShareIncome, new BigDecimal(daysIncom), 0));
            adjustmentFund = shareMultiply(dayShareIncome, new BigDecimal(getDayRange(contractPart[0], creatPoints[1].plusDays(-1)) + 1), 0);

            if (checkTwoTime(selected[0], creatPoints[1]) && checkTwoTime(creatPoints[1], selected[1])) {
                //所选时间范围包含 录入月 1 号 显示统计的调整金
                contract.setAdjustmentFund(adjustmentFund);
            } else {
                contract.setAdjustmentFund(0L);
            }
        }

        if (checkTwoTime(selected[0], contractPart[1]) && checkTwoTime(contractPart[1], selected[1])) {
            contract.setIncomeGross(shareMultiply(new BigDecimal(getDayRange(contractPart[0], contractPart[1]) + 1), dayShareIncome, 0));
        } else {
            contract.setIncomeGross(shareMultiply(new BigDecimal(getDayRange(contractPart[0], selected[1]) + 1), dayShareIncome, 0));
        }

        if (checkTwoTime(contractPart[1], selected[1])) {
            //最后一日分摊金计算处理
            Long lastDay;
            if (isLater) {


                lastDay = contract.getIncomeExcludingTax() - adjustmentFund
                        - shareMultiply(dayShareIncome, new BigDecimal(getDayRange(creatPoints[1], contractPart[1])), 0);
            } else {
                lastDay = contract.getIncomeExcludingTax() - adjustmentFund
                        - shareMultiply(dayShareIncome, new BigDecimal(getDayRange(contractPart[0], contractPart[1])), 0);
            }

            //最后一日 或 包含最后一日 时
            contract.setIntervaIncomeShare(contract.getIntervaIncomeShare() -
                    dayShareIncome.setScale(0, BigDecimal.ROUND_HALF_UP).longValue() + lastDay);

        }

        contract.setIncomeShareAll(contract.getIntervaIncomeShare() + contract.getAdjustmentFund());

    }

    private Contract suspendShare(Contract contract, int contractAllDay, BigDecimal dayShareIncome,
                                  DateTime[] contractPart, DateTime[] usePart, DateTime[] selected) {
        if (!ContractStatusEnum.SUSPEND.getKey().equals(contract.getStatus())) {
            return null;
        }

        ContractChange contractChange = contractChangeRepository.findByContentCode(ContractStatusEnum.SUSPEND.getValue(),
                contract.getContractCode());

        if (contractChange == null) {
            contract.setAdjustmentFund(0L);
            contract.setIntervaIncomeShare(0L);
            contract.setIncomeShareAll(0L);
            return contract;
        }
        // 合同终止日 或 作废日
        DateTime cancelDate = new DateTime(contractChange.getDs());

        //中止操作入库时间
        DateTime suspendDate = new DateTime(new DateTime(contractChange.getCreateTime()).toString("yyyy-MM-dd"));

        Long adjustmentFund = 0L;
        if (checkTwoTime(suspendDate, cancelDate)) {
            adjustmentFund = 0L;
        } else {
            adjustmentFund = shareMultiply(new BigDecimal((getDayRange(cancelDate, suspendDate) + 1) * -1), dayShareIncome, 0);
        }

        DateTime usedEnd = usePart[1].compareTo(cancelDate) <= 0 ? usePart[1] : cancelDate;
        int daysIncom = Days.daysBetween(usePart[0], usedEnd).getDays() + 1;
        daysIncom = daysIncom < 0 ? 0 : daysIncom;

        //区间分摊总收入
        contract.setIntervaIncomeShare(shareMultiply(dayShareIncome, new BigDecimal(daysIncom), 0));

        if (checkTwoTime(selected[0], cancelDate) && checkTwoTime(cancelDate, selected[1])) {
            contract.setAdjustmentFund(adjustmentFund);
            contract.setIncomeGross(shareMultiply(new BigDecimal(getDayRange(contractPart[0], cancelDate) + 1), dayShareIncome, 0));
        } else {
            contract.setAdjustmentFund(0L);
            contract.setIncomeGross(shareMultiply(new BigDecimal(getDayRange(contractPart[0], selected[1]) + 1), dayShareIncome, 0));
        }

        contract.setIncomeShareAll(contract.getIntervaIncomeShare() + contract.getAdjustmentFund());

        return contract;
    }

    private Contract cancledShare(Contract contract, int contractAllDay, BigDecimal dayShareIncome,
                                  DateTime[] contractPart, DateTime[] usePart, DateTime[] selected) {

        if (!ContractStatusEnum.CANCEL.getKey().equals(contract.getStatus())) {
            return null;
        }

        ContractChange contractChange = contractChangeRepository.findByContentCode(ContractStatusEnum.CANCEL.getValue(), contract.getContractCode());

        if (contractChange == null) {
            contract.setAdjustmentFund(0L);
            contract.setIntervaIncomeShare(0L);
            contract.setIncomeShareAll(0L);
            return contract;
        }

        // 合同终止日 或 作废日
        DateTime cancelDate = new DateTime(contractChange.getDs());
        Long adjustmentFund = shareMultiply(new BigDecimal((getDayRange(contractPart[0], cancelDate) + 1) * -1), dayShareIncome, 0);
        DateTime usedEnd = usePart[1].compareTo(cancelDate) <= 0 ? usePart[1] : cancelDate;

        int daysIncom = Days.daysBetween(usePart[0], usedEnd).getDays() + 1;
        daysIncom = daysIncom < 0 ? 0 : daysIncom;

        contract.setIntervalUseDays(getDayRange(contractPart[0], usedEnd) + 1);
        //区间分摊总收入

        contract.setIntervaIncomeShare(shareMultiply(dayShareIncome, new BigDecimal(daysIncom), 0));

        if (checkTwoTime(selected[0], cancelDate) && checkTwoTime(cancelDate, selected[1])) {
            contract.setAdjustmentFund(adjustmentFund);
        } else {
            contract.setAdjustmentFund(0L);
        }
        contract.setIncomeGross(0L);
        contract.setIncomeShareAll(contract.getIntervaIncomeShare() + contract.getAdjustmentFund());
        return contract;
    }

    private Long shareMultiply(BigDecimal one, BigDecimal two, int scale) {
        return one.multiply(two).setScale(scale, BigDecimal.ROUND_HALF_UP).longValue();
    }

    @Override
    public boolean checkLateContract(DateTime dateTime, DateTime creatTime) {
        int aferDays = dateTime.monthOfYear().get() == 12 ? 29 : 9;
        return dateTime.dayOfMonth().withMaximumValue().plusDays(aferDays).isBefore(creatTime);

    }

    private int getDayRange(DateTime range1, DateTime range2) {
        return Days.daysBetween(range1, range2).getDays();
    }

    public boolean checkTwoTime(DateTime dateTime1, DateTime dateTime2) {
        return dateTime1.isBefore(dateTime2) || dateTime1.isEqual(dateTime2);
    }

    public static void main(String[] args) {
        System.out.println(new BigDecimal(34009003 / 10000.0));

    }

    public static void main2(String[] args) {
        DateTime contractStart = new DateTime("2020-05-15");
        DateTime create = new DateTime("2020-06-15");
        System.out.println(contractStart.monthOfYear().getDateTime());
        System.out.println(contractStart.dayOfMonth().withMaximumValue().plusDays(1));
        System.out.println(contractStart.dayOfMonth().withMaximumValue().plusDays(9).isBefore(create));
        System.out.println(contractStart.compareTo(create));

        long ss = new BigDecimal(94000 * 1.0 / 52)
                .setScale(0, BigDecimal.ROUND_HALF_UP).longValue();
        System.out.println(ss);

        DateTime[][] times = new DateTime[][]{
                {new DateTime(), new DateTime()},
                {new DateTime(), new DateTime()}
        };
        System.out.println(times[1][0].toString());
    }
}
