package common.controller;

import common.model.Menu;
import common.model.User;
import common.repository.AuthRepository;
import common.repository.RoleRepository;
import common.repository.RoleTypeRepository;
import common.repository.UserRepository;
import common.service.MenuService;
import common.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import security.annotation.CurrentAccount;
import util.CipherUtil;
import util.ResultModel;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * Created by mxq on 2017/12/21.
 */
@Controller
@RequestMapping("system/user")
public class UserController {
    @Autowired
    private UserService userService;

    @Autowired
    UserRepository userRepository;

    @Autowired
    RoleRepository roleRepository;

    @Autowired
    RoleTypeRepository roleTypeRepository;

    @Autowired
    AuthRepository authRepository;

    @RequestMapping(value = "/valid/email", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel validEmail(@RequestParam String email) {
        return ResultModel.OK(userService.validEmail(email));
    }

    @RequestMapping(value = "/create", method = RequestMethod.POST)
    @ResponseBody
    public ResultModel create(@CurrentAccount User loginAccount, @RequestBody User resource) {
        if(userService.validEmail(resource.getEmail())){
            userService.create(loginAccount, resource);
            return ResultModel.OK(true);
        }else{
            return ResultModel.OK(false);
        }
    }

    @RequestMapping(value = "/update", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel update(@CurrentAccount User loginAccount, @RequestBody User resource) {
        return ResultModel.OK(userService.update(loginAccount, resource));
    }

    @RequestMapping(value = "/find", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel find(@CurrentAccount User loginAccount) {
        return ResultModel.OK(userService.find(loginAccount));
    }

    @RequestMapping(value = "/find/role", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findRole(@CurrentAccount User loginAccount) {
        return ResultModel.OK(roleRepository.findAll());
    }

    @RequestMapping(value = "/find/roletype", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findRoleType(@CurrentAccount User loginAccount) {
        return ResultModel.OK(roleTypeRepository.findAll());
    }

    @RequestMapping(value = "/find/auth", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findAuth(@CurrentAccount User loginAccount) {
        return ResultModel.OK(authRepository.findByUser(loginAccount.getId()));
    }

    @RequestMapping(value = "/delete/{id}", method = RequestMethod.DELETE)
    @ResponseBody
    public ResultModel delete(@CurrentAccount User loginAccount, @PathVariable Long id) {
        return ResultModel.OK(userService.delete(loginAccount, id));
    }

    @RequestMapping(value = "/enable/{id}", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel enable(@CurrentAccount User loginAccount, @PathVariable Long id) {
        return ResultModel.OK(userService.enable(loginAccount, id));
    }

    @RequestMapping(value = "/forbiden/{id}", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel forbiden(@CurrentAccount User loginAccount, @PathVariable Long id) {
        return ResultModel.OK(userService.forbiden(loginAccount, id));
    }

    @RequestMapping(value = "/update/name", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel updateName(@CurrentAccount User loginAccount, @RequestParam String name) {
        User login = userRepository.login(name);
        if(null == login){
            userService.updateName(loginAccount, name);
            return ResultModel.OK(true);
        }else{
            return ResultModel.OK(false);
        }

    }

    @RequestMapping(value = "/update/password", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel updatePwd(@CurrentAccount User loginAccount, @RequestParam String pwd, @RequestParam String oldpwd) {
        User login = userRepository.login(loginAccount.getEmail(), CipherUtil.generatePassword(oldpwd));
        if(null != login){
            userService.updatePwd(loginAccount, pwd);
            return ResultModel.OK(true);
        }else{
            return ResultModel.OK(false);
        }
    }

    //忘记密码时，修改密码
    @RequestMapping(value = "/update/pwd", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel updatePwd(@RequestParam String email, @RequestParam String pwd) {

        return ResultModel.OK(userService.updatePwd(email, pwd));
    }

    //忘记密码时，发送验证码
    @RequestMapping(value = "/code", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel sengCode(@RequestParam String email) {

        return ResultModel.OK(userService.sendCode(email));
    }

    //验证码验证
    @RequestMapping(value = "/update/pwd", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel validCode(@RequestParam String email, @RequestParam String code, @RequestParam String pwd) {
        return ResultModel.OK(userService.validCode(email, code, pwd));
    }
}
